/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function.avg;

import com.google.common.base.Strings;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.meter.function.PercentileArgument;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntList;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MultiIntValuesHolder;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MeterFunction(functionName="avgHistogramPercentile")
public abstract class AvgHistogramPercentileFunction
extends Meter
implements AcceptableValue<PercentileArgument>,
MultiIntValuesHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AvgHistogramPercentileFunction.class);
    private static final String DEFAULT_GROUP = "pD";
    public static final String DATASET = "dataset";
    public static final String RANKS = "ranks";
    public static final String VALUE = "value";
    protected static final String SUMMATION = "summation";
    protected static final String COUNT = "count";
    @Column(columnName="entity_id")
    @BanyanDB.ShardingKey(index=0)
    private String entityId;
    @Column(columnName="value", dataType=Column.ValueDataType.LABELED_VALUE, storageOnly=true)
    @ElasticSearch.Column(columnAlias="datatable_value")
    private DataTable percentileValues = new DataTable(10);
    @Column(columnName="summation", storageOnly=true)
    @ElasticSearch.Column(columnAlias="datatable_summation")
    protected DataTable summation = new DataTable(30);
    @Column(columnName="count", storageOnly=true)
    @ElasticSearch.Column(columnAlias="datatable_count")
    protected DataTable count = new DataTable(30);
    @Column(columnName="dataset", storageOnly=true)
    private DataTable dataset = new DataTable(30);
    @Column(columnName="ranks", storageOnly=true)
    private IntList ranks = new IntList(10);
    private boolean isCalculated = false;

    @Override
    public void accept(MeterEntity entity, PercentileArgument value) {
        if (this.dataset.size() > 0 && !value.getBucketedValues().isCompatible(this.dataset)) {
            throw new IllegalArgumentException("Incompatible BucketedValues [" + value + "] for current PercentileFunction[" + this.dataset + "]");
        }
        for (int rank : value.getRanks()) {
            if (rank > 0) continue;
            throw new IllegalArgumentException("Illegal rank value " + rank + ", must be positive");
        }
        if (this.ranks.size() > 0) {
            if (this.ranks.size() != value.getRanks().length) {
                throw new IllegalArgumentException("Incompatible ranks size = [" + value.getRanks().length + "] for current PercentileFunction[" + this.ranks.size() + "]");
            }
            for (int rank : value.getRanks()) {
                if (this.ranks.include(rank)) continue;
                throw new IllegalArgumentException("Rank " + rank + " doesn't exist in the previous ranks " + this.ranks);
            }
        } else {
            for (int rank : value.getRanks()) {
                this.ranks.add(rank);
            }
        }
        this.entityId = entity.id();
        String template = "%s";
        if (!Strings.isNullOrEmpty((String)value.getBucketedValues().getGroup())) {
            template = value.getBucketedValues().getGroup() + ":%s";
        }
        long[] values = value.getBucketedValues().getValues();
        for (int i = 0; i < values.length; ++i) {
            long bucket = value.getBucketedValues().getBuckets()[i];
            String bucketName = bucket == Long.MIN_VALUE ? "infinite-" : String.valueOf(bucket);
            String key = String.format(template, bucketName);
            this.summation.valueAccumulation(key, values[i]);
            this.count.valueAccumulation(key, 1L);
        }
        this.isCalculated = false;
    }

    @Override
    public boolean combine(Metrics metrics) {
        AvgHistogramPercentileFunction percentile = (AvgHistogramPercentileFunction)metrics;
        if (this.ranks.size() > 0) {
            IntList ranksOfThat = percentile.getRanks();
            if (this.ranks.size() != ranksOfThat.size()) {
                log.warn("Incompatible ranks size = [{}}] for current PercentileFunction[{}]", (Object)ranksOfThat.size(), (Object)this.ranks.size());
                return true;
            }
            if (!this.ranks.equals(ranksOfThat)) {
                log.warn("Rank {} doesn't exist in the previous ranks {}", (Object)ranksOfThat, (Object)this.ranks);
                return true;
            }
        }
        this.summation.append(percentile.summation);
        this.count.append(percentile.count);
        this.isCalculated = false;
        return true;
    }

    @Override
    public void calculate() {
        if (!this.isCalculated) {
            Set<String> keys = this.summation.keys();
            for (String key2 : keys) {
                long value = 0L;
                if (this.count.get(key2) != 0L && (value = this.summation.get(key2) / this.count.get(key2)) == 0L && this.summation.get(key2) > 0L) {
                    value = 1L;
                }
                this.dataset.put(key2, value);
            }
            this.dataset.keys().stream().map(key -> {
                if (key.contains(":")) {
                    int index = key.lastIndexOf(":");
                    return Tuple.of((Object)key.substring(0, index), (Object)key);
                }
                return Tuple.of((Object)DEFAULT_GROUP, (Object)key);
            }).collect(Collectors.groupingBy(Tuple2::_1, Collectors.mapping(Tuple2::_2, Collector.of(DataTable::new, (dt, key) -> {
                String v;
                if (key.contains(":")) {
                    int index = key.lastIndexOf(":");
                    v = key.substring(index + 1);
                } else {
                    v = key;
                }
                dt.put(v, this.dataset.get((String)key));
            }, DataTable::append, new Collector.Characteristics[0])))).forEach((group, subDataset) -> {
                long total = subDataset.sumOfValues();
                int[] roofs = new int[this.ranks.size()];
                for (int i = 0; i < this.ranks.size(); ++i) {
                    roofs[i] = Math.round((float)(total * (long)this.ranks.get(i)) * 1.0f / 100.0f);
                }
                int count = 0;
                List<String> sortedKeys = subDataset.sortedKeys(Comparator.comparingLong(Long::parseLong));
                int loopIndex = 0;
                for (String key : sortedKeys) {
                    int roof;
                    Long value = subDataset.get(key);
                    count = (int)((long)count + value);
                    for (int rankIdx = loopIndex; rankIdx < roofs.length && count >= (roof = roofs[rankIdx]); ++rankIdx) {
                        if (group.equals(DEFAULT_GROUP)) {
                            this.percentileValues.put(String.valueOf(this.ranks.get(rankIdx)), Long.parseLong(key));
                        } else {
                            this.percentileValues.put(String.format("%s:%s", group, this.ranks.get(rankIdx)), Long.parseLong(key));
                        }
                        ++loopIndex;
                    }
                }
            });
        }
    }

    @Override
    public Metrics toHour() {
        AvgHistogramPercentileFunction metrics = (AvgHistogramPercentileFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setSummation(this.getSummation());
        metrics.setCount(this.getCount());
        metrics.setRanks(this.getRanks());
        metrics.setPercentileValues(this.getPercentileValues());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        AvgHistogramPercentileFunction metrics = (AvgHistogramPercentileFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setSummation(this.getSummation());
        metrics.setCount(this.getCount());
        metrics.setRanks(this.getRanks());
        metrics.setPercentileValues(this.getPercentileValues());
        return metrics;
    }

    @Override
    public int[] getValues() {
        return this.percentileValues.sortedValues(Comparator.comparingInt(Integer::parseInt)).stream().flatMapToInt(l -> IntStream.of(l.intValue())).toArray();
    }

    @Override
    public int remoteHashCode() {
        return this.entityId.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setEntityId(remoteData.getDataStrings(0));
        this.setSummation(new DataTable(remoteData.getDataObjectStrings(0)));
        this.setCount(new DataTable(remoteData.getDataObjectStrings(1)));
        this.setRanks(new IntList(remoteData.getDataObjectStrings(2)));
        this.setPercentileValues(new DataTable(remoteData.getDataObjectStrings(3)));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.entityId);
        remoteBuilder.addDataObjectStrings(this.summation.toStorageData());
        remoteBuilder.addDataObjectStrings(this.count.toStorageData());
        remoteBuilder.addDataObjectStrings(this.ranks.toStorageData());
        remoteBuilder.addDataObjectStrings(this.percentileValues.toStorageData());
        return remoteBuilder;
    }

    @Override
    protected String id0() {
        return this.getTimeBucket() + "_" + this.entityId;
    }

    @Override
    public Class<? extends AvgPercentileFunctionBuilder> builder() {
        return AvgPercentileFunctionBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AvgHistogramPercentileFunction)) {
            return false;
        }
        AvgHistogramPercentileFunction function = (AvgHistogramPercentileFunction)o;
        return Objects.equals(this.entityId, function.entityId) && this.getTimeBucket() == function.getTimeBucket();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityId, this.getTimeBucket());
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public DataTable getPercentileValues() {
        return this.percentileValues;
    }

    @Generated
    public void setPercentileValues(DataTable percentileValues) {
        this.percentileValues = percentileValues;
    }

    @Generated
    public DataTable getSummation() {
        return this.summation;
    }

    @Generated
    public void setSummation(DataTable summation) {
        this.summation = summation;
    }

    @Generated
    public DataTable getCount() {
        return this.count;
    }

    @Generated
    public void setCount(DataTable count) {
        this.count = count;
    }

    @Generated
    public DataTable getDataset() {
        return this.dataset;
    }

    @Generated
    public void setDataset(DataTable dataset) {
        this.dataset = dataset;
    }

    @Generated
    public IntList getRanks() {
        return this.ranks;
    }

    @Generated
    public void setRanks(IntList ranks) {
        this.ranks = ranks;
    }

    public static class AvgPercentileFunctionBuilder
    implements StorageBuilder<AvgHistogramPercentileFunction> {
        @Override
        public AvgHistogramPercentileFunction storage2Entity(Convert2Entity converter) {
            AvgHistogramPercentileFunction metrics = new AvgHistogramPercentileFunction(){

                @Override
                public AcceptableValue<PercentileArgument> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setDataset(new DataTable((String)converter.get(AvgHistogramPercentileFunction.DATASET)));
            metrics.setSummation(new DataTable((String)converter.get(AvgHistogramPercentileFunction.SUMMATION)));
            metrics.setCount(new DataTable((String)converter.get(AvgHistogramPercentileFunction.COUNT)));
            metrics.setRanks(new IntList((String)converter.get(AvgHistogramPercentileFunction.RANKS)));
            metrics.setPercentileValues(new DataTable((String)converter.get(AvgHistogramPercentileFunction.VALUE)));
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(AvgHistogramPercentileFunction storageData, Convert2Storage converter) {
            converter.accept(AvgHistogramPercentileFunction.SUMMATION, storageData.getSummation());
            converter.accept(AvgHistogramPercentileFunction.COUNT, storageData.getCount());
            converter.accept(AvgHistogramPercentileFunction.DATASET, storageData.getDataset());
            converter.accept(AvgHistogramPercentileFunction.RANKS, storageData.getRanks());
            converter.accept(AvgHistogramPercentileFunction.VALUE, storageData.getPercentileValues());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

