/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function.avg;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ConstOne;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@MeterFunction(functionName="avg")
public abstract class AvgFunction
extends Meter
implements AcceptableValue<Long>,
LongValueHolder {
    protected static final String SUMMATION = "summation";
    protected static final String COUNT = "count";
    protected static final String VALUE = "value";
    @Column(columnName="entity_id", length=512)
    @BanyanDB.ShardingKey(index=0)
    private String entityId;
    @Column(columnName="service_id")
    private String serviceId;
    @Column(columnName="summation", storageOnly=true)
    protected long summation;
    @Column(columnName="count", storageOnly=true)
    protected long count;
    @Column(columnName="value", dataType=Column.ValueDataType.COMMON_VALUE, function=Function.Avg)
    private long value;

    @Entrance
    public final void combine(@SourceFrom long summation, @ConstOne long count) {
        this.summation += summation;
        this.count += count;
    }

    @Override
    public final boolean combine(Metrics metrics) {
        AvgFunction longAvgMetrics = (AvgFunction)metrics;
        this.combine(longAvgMetrics.summation, longAvgMetrics.count);
        return true;
    }

    @Override
    public final void calculate() {
        long result = this.summation / this.count;
        if (result == 0L && this.summation > 0L) {
            result = 1L;
        }
        this.value = result;
    }

    @Override
    public Metrics toHour() {
        AvgFunction metrics = (AvgFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setServiceId(this.getServiceId());
        metrics.setSummation(this.getSummation());
        metrics.setCount(this.getCount());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        AvgFunction metrics = (AvgFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setServiceId(this.getServiceId());
        metrics.setSummation(this.getSummation());
        metrics.setCount(this.getCount());
        return metrics;
    }

    @Override
    public int remoteHashCode() {
        return this.entityId.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.count = remoteData.getDataLongs(0);
        this.summation = remoteData.getDataLongs(1);
        this.setTimeBucket(remoteData.getDataLongs(2));
        this.entityId = remoteData.getDataStrings(0);
        this.serviceId = remoteData.getDataStrings(1);
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.count);
        remoteBuilder.addDataLongs(this.summation);
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.entityId);
        remoteBuilder.addDataStrings(this.serviceId);
        return remoteBuilder;
    }

    @Override
    protected String id0() {
        return this.getTimeBucket() + "_" + this.entityId;
    }

    @Override
    public void accept(MeterEntity entity, Long value) {
        this.entityId = entity.id();
        this.serviceId = entity.serviceId();
        this.summation += value.longValue();
        ++this.count;
    }

    @Override
    public Class<? extends StorageBuilder> builder() {
        return AvgStorageBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AvgFunction)) {
            return false;
        }
        AvgFunction function = (AvgFunction)o;
        return Objects.equals(this.entityId, function.entityId) && this.getTimeBucket() == function.getTimeBucket();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityId, this.getTimeBucket());
    }

    @Generated
    public String toString() {
        return "AvgFunction(entityId=" + this.getEntityId() + ", serviceId=" + this.getServiceId() + ", summation=" + this.getSummation() + ", count=" + this.getCount() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public long getSummation() {
        return this.summation;
    }

    @Generated
    public void setSummation(long summation) {
        this.summation = summation;
    }

    @Generated
    public long getCount() {
        return this.count;
    }

    @Generated
    public void setCount(long count) {
        this.count = count;
    }

    @Override
    @Generated
    public long getValue() {
        return this.value;
    }

    @Generated
    public void setValue(long value) {
        this.value = value;
    }

    public static class AvgStorageBuilder
    implements StorageBuilder<AvgFunction> {
        @Override
        public AvgFunction storage2Entity(Convert2Entity converter) {
            AvgFunction metrics = new AvgFunction(){

                @Override
                public AcceptableValue<Long> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setSummation(((Number)converter.get(AvgFunction.SUMMATION)).longValue());
            metrics.setValue(((Number)converter.get(AvgFunction.VALUE)).longValue());
            metrics.setCount(((Number)converter.get(AvgFunction.COUNT)).longValue());
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setServiceId((String)converter.get("service_id"));
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(AvgFunction storageData, Convert2Storage converter) {
            converter.accept(AvgFunction.SUMMATION, storageData.getSummation());
            converter.accept(AvgFunction.VALUE, storageData.getValue());
            converter.accept(AvgFunction.COUNT, storageData.getCount());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("service_id", storageData.getServiceId());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

