/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.BucketedValues;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MeterFunction(functionName="sumHistogram")
public abstract class HistogramFunction
extends Meter
implements AcceptableValue<BucketedValues> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HistogramFunction.class);
    public static final String DATASET = "dataset";
    @Column(columnName="entity_id", length=512)
    @BanyanDB.ShardingKey(index=0)
    private String entityId;
    @Column(columnName="dataset", dataType=Column.ValueDataType.HISTOGRAM, storageOnly=true, defaultValue=0)
    private DataTable dataset = new DataTable(30);

    @Override
    public void accept(MeterEntity entity, BucketedValues value) {
        if (this.dataset.size() > 0 && !value.isCompatible(this.dataset)) {
            throw new IllegalArgumentException("Incompatible BucketedValues [" + value + "] for current HistogramFunction[" + this.dataset + "]");
        }
        this.entityId = entity.id();
        long[] values = value.getValues();
        for (int i = 0; i < values.length; ++i) {
            long bucket = value.getBuckets()[i];
            String bucketName = bucket == Long.MIN_VALUE ? "infinite-" : String.valueOf(bucket);
            long bucketValue = values[i];
            this.dataset.valueAccumulation(bucketName, bucketValue);
        }
    }

    @Override
    public boolean combine(Metrics metrics) {
        HistogramFunction histogram = (HistogramFunction)metrics;
        if (!this.dataset.keysEqual(histogram.getDataset())) {
            log.warn("Incompatible input [{}}] for current HistogramFunction[{}], entity {}", new Object[]{histogram, this, this.entityId});
            return true;
        }
        this.dataset.append(histogram.dataset);
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        HistogramFunction metrics = (HistogramFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setDataset(this.getDataset());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        HistogramFunction metrics = (HistogramFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setDataset(this.getDataset());
        return metrics;
    }

    @Override
    public int remoteHashCode() {
        return this.entityId.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setEntityId(remoteData.getDataStrings(0));
        this.setDataset(new DataTable(remoteData.getDataObjectStrings(0)));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.entityId);
        remoteBuilder.addDataObjectStrings(this.dataset.toStorageData());
        return remoteBuilder;
    }

    @Override
    protected String id0() {
        return this.getTimeBucket() + "_" + this.entityId;
    }

    @Override
    public Class<? extends HistogramFunctionBuilder> builder() {
        return HistogramFunctionBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistogramFunction)) {
            return false;
        }
        HistogramFunction function = (HistogramFunction)o;
        return Objects.equals(this.entityId, function.entityId) && this.getTimeBucket() == function.getTimeBucket();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityId, this.getTimeBucket());
    }

    @Generated
    public String toString() {
        return "HistogramFunction(entityId=" + this.getEntityId() + ", dataset=" + this.getDataset() + ")";
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public DataTable getDataset() {
        return this.dataset;
    }

    @Generated
    public void setDataset(DataTable dataset) {
        this.dataset = dataset;
    }

    public static class HistogramFunctionBuilder
    implements StorageBuilder<HistogramFunction> {
        @Override
        public HistogramFunction storage2Entity(Convert2Entity converter) {
            HistogramFunction metrics = new HistogramFunction(){

                @Override
                public AcceptableValue<BucketedValues> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setDataset(new DataTable((String)converter.get(HistogramFunction.DATASET)));
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(HistogramFunction storageData, Convert2Storage converter) {
            converter.accept(HistogramFunction.DATASET, storageData.getDataset());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

