/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.segment;

import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.SQLDatabase;
import org.apache.skywalking.oap.server.core.storage.annotation.SuperDataset;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@SuperDataset
@Stream(name="segment", scopeId=12, builder=Builder.class, processor=RecordStreamProcessor.class)
@SQLDatabase.ExtraColumn4AdditionalEntity(additionalTable="segment_tag", parentColumn="time_bucket")
public class SegmentRecord
extends Record {
    public static final String INDEX_NAME = "segment";
    public static final String ADDITIONAL_TAG_TABLE = "segment_tag";
    public static final String SEGMENT_ID = "segment_id";
    public static final String TRACE_ID = "trace_id";
    public static final String SERVICE_ID = "service_id";
    public static final String SERVICE_INSTANCE_ID = "service_instance_id";
    public static final String ENDPOINT_ID = "endpoint_id";
    public static final String START_TIME = "start_time";
    public static final String LATENCY = "latency";
    public static final String IS_ERROR = "is_error";
    public static final String DATA_BINARY = "data_binary";
    public static final String TAGS = "tags";
    @Column(columnName="segment_id", length=150)
    private String segmentId;
    @Column(columnName="trace_id", length=150)
    @BanyanDB.GlobalIndex
    private String traceId;
    @Column(columnName="service_id")
    @BanyanDB.ShardingKey(index=0)
    private String serviceId;
    @Column(columnName="service_instance_id")
    @BanyanDB.ShardingKey(index=1)
    private String serviceInstanceId;
    @Column(columnName="endpoint_id")
    private String endpointId;
    @Column(columnName="start_time")
    private long startTime;
    @Column(columnName="latency")
    private int latency;
    @Column(columnName="is_error")
    @BanyanDB.ShardingKey(index=2)
    private int isError;
    @Column(columnName="data_binary", storageOnly=true)
    private byte[] dataBinary;
    @Column(columnName="tags", indexOnly=true)
    @SQLDatabase.AdditionalEntity(additionalTables={"segment_tag"})
    private List<String> tags;

    @Override
    public String id() {
        return this.segmentId;
    }

    @Generated
    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    @Generated
    public String getSegmentId() {
        return this.segmentId;
    }

    @Generated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public void setServiceInstanceId(String serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    @Generated
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Generated
    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    @Generated
    public String getEndpointId() {
        return this.endpointId;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public void setLatency(int latency) {
        this.latency = latency;
    }

    @Generated
    public int getLatency() {
        return this.latency;
    }

    @Generated
    public void setIsError(int isError) {
        this.isError = isError;
    }

    @Generated
    public int getIsError() {
        return this.isError;
    }

    @Generated
    public void setDataBinary(byte[] dataBinary) {
        this.dataBinary = dataBinary;
    }

    @Generated
    public byte[] getDataBinary() {
        return this.dataBinary;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    public static class Builder
    implements StorageBuilder<SegmentRecord> {
        @Override
        public SegmentRecord storage2Entity(Convert2Entity converter) {
            SegmentRecord record = new SegmentRecord();
            record.setSegmentId((String)converter.get(SegmentRecord.SEGMENT_ID));
            record.setTraceId((String)converter.get(SegmentRecord.TRACE_ID));
            record.setServiceId((String)converter.get(SegmentRecord.SERVICE_ID));
            record.setServiceInstanceId((String)converter.get(SegmentRecord.SERVICE_INSTANCE_ID));
            record.setEndpointId((String)converter.get(SegmentRecord.ENDPOINT_ID));
            record.setStartTime(((Number)converter.get(SegmentRecord.START_TIME)).longValue());
            record.setLatency(((Number)converter.get(SegmentRecord.LATENCY)).intValue());
            record.setIsError(((Number)converter.get(SegmentRecord.IS_ERROR)).intValue());
            record.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            record.setDataBinary(converter.getBytes(SegmentRecord.DATA_BINARY));
            return record;
        }

        @Override
        public void entity2Storage(SegmentRecord storageData, Convert2Storage converter) {
            converter.accept(SegmentRecord.SEGMENT_ID, storageData.getSegmentId());
            converter.accept(SegmentRecord.TRACE_ID, storageData.getTraceId());
            converter.accept(SegmentRecord.SERVICE_ID, storageData.getServiceId());
            converter.accept(SegmentRecord.SERVICE_INSTANCE_ID, storageData.getServiceInstanceId());
            converter.accept(SegmentRecord.ENDPOINT_ID, storageData.getEndpointId());
            converter.accept(SegmentRecord.START_TIME, storageData.getStartTime());
            converter.accept(SegmentRecord.LATENCY, storageData.getLatency());
            converter.accept(SegmentRecord.IS_ERROR, storageData.getIsError());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept(SegmentRecord.DATA_BINARY, storageData.getDataBinary());
            converter.accept(SegmentRecord.TAGS, storageData.getTags());
        }
    }
}

