/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.relation.service;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="service_relation_client_side", scopeId=4, builder=Builder.class, processor=MetricsStreamProcessor.class)
public class ServiceRelationClientSideMetrics
extends Metrics {
    public static final String INDEX_NAME = "service_relation_client_side";
    public static final String SOURCE_SERVICE_ID = "source_service_id";
    public static final String DEST_SERVICE_ID = "dest_service_id";
    public static final String COMPONENT_ID = "component_id";
    @Column(columnName="source_service_id")
    private String sourceServiceId;
    @Column(columnName="dest_service_id")
    private String destServiceId;
    @Column(columnName="component_id", storageOnly=true)
    private int componentId;
    @Column(columnName="entity_id", length=512)
    private String entityId;

    @Override
    protected String id0() {
        return this.getTimeBucket() + "_" + this.entityId;
    }

    @Override
    public boolean combine(Metrics metrics) {
        ServiceRelationClientSideMetrics serviceRelationClientSideMetrics = (ServiceRelationClientSideMetrics)metrics;
        if (this.getComponentId() == 0 && serviceRelationClientSideMetrics.getComponentId() != 0) {
            this.componentId = serviceRelationClientSideMetrics.getComponentId();
        }
        if (this.getTimeBucket() > metrics.getTimeBucket()) {
            this.setTimeBucket(metrics.getTimeBucket());
        }
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        ServiceRelationClientSideMetrics metrics = new ServiceRelationClientSideMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setSourceServiceId(this.getSourceServiceId());
        metrics.setDestServiceId(this.getDestServiceId());
        metrics.setComponentId(this.getComponentId());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        ServiceRelationClientSideMetrics metrics = new ServiceRelationClientSideMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setSourceServiceId(this.getSourceServiceId());
        metrics.setDestServiceId(this.getDestServiceId());
        metrics.setComponentId(this.getComponentId());
        return metrics;
    }

    @Override
    public int remoteHashCode() {
        int n = 17;
        n = 31 * n + this.entityId.hashCode();
        return n;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setEntityId(remoteData.getDataStrings(0));
        this.setSourceServiceId(remoteData.getDataStrings(1));
        this.setDestServiceId(remoteData.getDataStrings(2));
        this.setComponentId(remoteData.getDataIntegers(0));
        this.setTimeBucket(remoteData.getDataLongs(0));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataStrings(this.getSourceServiceId());
        remoteBuilder.addDataStrings(this.getDestServiceId());
        remoteBuilder.addDataIntegers(this.getComponentId());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        return remoteBuilder;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceRelationClientSideMetrics)) {
            return false;
        }
        ServiceRelationClientSideMetrics other = (ServiceRelationClientSideMetrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        return !(this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceRelationClientSideMetrics;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        return result;
    }

    @Generated
    public void setSourceServiceId(String sourceServiceId) {
        this.sourceServiceId = sourceServiceId;
    }

    @Generated
    public String getSourceServiceId() {
        return this.sourceServiceId;
    }

    @Generated
    public void setDestServiceId(String destServiceId) {
        this.destServiceId = destServiceId;
    }

    @Generated
    public String getDestServiceId() {
        return this.destServiceId;
    }

    @Generated
    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    @Generated
    public int getComponentId() {
        return this.componentId;
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    public static class Builder
    implements StorageBuilder<ServiceRelationClientSideMetrics> {
        @Override
        public ServiceRelationClientSideMetrics storage2Entity(Convert2Entity converter) {
            ServiceRelationClientSideMetrics metrics = new ServiceRelationClientSideMetrics();
            metrics.setSourceServiceId((String)converter.get(ServiceRelationClientSideMetrics.SOURCE_SERVICE_ID));
            metrics.setDestServiceId((String)converter.get(ServiceRelationClientSideMetrics.DEST_SERVICE_ID));
            metrics.setComponentId(((Number)converter.get(ServiceRelationClientSideMetrics.COMPONENT_ID)).intValue());
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(ServiceRelationClientSideMetrics storageData, Convert2Storage converter) {
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept(ServiceRelationClientSideMetrics.SOURCE_SERVICE_ID, storageData.getSourceServiceId());
            converter.accept(ServiceRelationClientSideMetrics.DEST_SERVICE_ID, storageData.getDestServiceId());
            converter.accept(ServiceRelationClientSideMetrics.COMPONENT_ID, storageData.getComponentId());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

