/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.relation.process;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="process_relation_client_side", scopeId=54, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=true, timeRelativeID=true)
public class ProcessRelationClientSideMetrics
extends Metrics {
    public static final String INDEX_NAME = "process_relation_client_side";
    public static final String SERVICE_INSTANCE_ID = "service_instance_id";
    public static final String SOURCE_PROCESS_ID = "source_process_id";
    public static final String DEST_PROCESS_ID = "dest_process_id";
    public static final String COMPONENT_ID = "component_id";
    @Column(columnName="service_instance_id")
    private String serviceInstanceId;
    @Column(columnName="source_process_id")
    private String sourceProcessId;
    @Column(columnName="dest_process_id")
    private String destProcessId;
    @Column(columnName="entity_id", length=512)
    private String entityId;
    @Column(columnName="component_id", storageOnly=true)
    private int componentId;

    @Override
    protected String id0() {
        return this.getTimeBucket() + "_" + this.entityId;
    }

    @Override
    public boolean combine(Metrics metrics) {
        if (this.getTimeBucket() > metrics.getTimeBucket()) {
            this.setTimeBucket(metrics.getTimeBucket());
        }
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setServiceInstanceId(remoteData.getDataStrings(0));
        this.setSourceProcessId(remoteData.getDataStrings(1));
        this.setDestProcessId(remoteData.getDataStrings(2));
        this.setEntityId(remoteData.getDataStrings(3));
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setComponentId(remoteData.getDataIntegers(0));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder builder = RemoteData.newBuilder();
        builder.addDataStrings(this.getServiceInstanceId());
        builder.addDataStrings(this.getSourceProcessId());
        builder.addDataStrings(this.getDestProcessId());
        builder.addDataStrings(this.getEntityId());
        builder.addDataLongs(this.getTimeBucket());
        builder.addDataIntegers(this.getComponentId());
        return builder;
    }

    @Override
    public int remoteHashCode() {
        return this.entityId.hashCode();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessRelationClientSideMetrics)) {
            return false;
        }
        ProcessRelationClientSideMetrics other = (ProcessRelationClientSideMetrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        return !(this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessRelationClientSideMetrics;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        return result;
    }

    @Generated
    public void setServiceInstanceId(String serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    @Generated
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Generated
    public void setSourceProcessId(String sourceProcessId) {
        this.sourceProcessId = sourceProcessId;
    }

    @Generated
    public String getSourceProcessId() {
        return this.sourceProcessId;
    }

    @Generated
    public void setDestProcessId(String destProcessId) {
        this.destProcessId = destProcessId;
    }

    @Generated
    public String getDestProcessId() {
        return this.destProcessId;
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    @Generated
    public int getComponentId() {
        return this.componentId;
    }

    public static class Builder
    implements StorageBuilder<ProcessRelationClientSideMetrics> {
        @Override
        public ProcessRelationClientSideMetrics storage2Entity(Convert2Entity converter) {
            ProcessRelationClientSideMetrics metrics = new ProcessRelationClientSideMetrics();
            metrics.setServiceInstanceId((String)converter.get(ProcessRelationClientSideMetrics.SERVICE_INSTANCE_ID));
            metrics.setSourceProcessId((String)converter.get(ProcessRelationClientSideMetrics.SOURCE_PROCESS_ID));
            metrics.setDestProcessId((String)converter.get(ProcessRelationClientSideMetrics.DEST_PROCESS_ID));
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setEntityId((String)converter.get("entity_id"));
            metrics.setComponentId(((Number)converter.get(ProcessRelationClientSideMetrics.COMPONENT_ID)).intValue());
            return metrics;
        }

        @Override
        public void entity2Storage(ProcessRelationClientSideMetrics storageData, Convert2Storage converter) {
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept(ProcessRelationClientSideMetrics.SERVICE_INSTANCE_ID, storageData.getServiceInstanceId());
            converter.accept(ProcessRelationClientSideMetrics.SOURCE_PROCESS_ID, storageData.getSourceProcessId());
            converter.accept(ProcessRelationClientSideMetrics.DEST_PROCESS_ID, storageData.getDestProcessId());
            converter.accept("entity_id", storageData.getEntityId());
            converter.accept(ProcessRelationClientSideMetrics.COMPONENT_ID, storageData.getComponentId());
        }
    }
}

