/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.relation.endpoint;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="endpoint_relation_server_side", scopeId=6, builder=Builder.class, processor=MetricsStreamProcessor.class)
public class EndpointRelationServerSideMetrics
extends Metrics {
    public static final String INDEX_NAME = "endpoint_relation_server_side";
    public static final String SOURCE_ENDPOINT = "source_endpoint";
    public static final String DEST_ENDPOINT = "dest_endpoint";
    public static final String COMPONENT_ID = "component_id";
    @Column(columnName="source_endpoint")
    private String sourceEndpoint;
    @Column(columnName="dest_endpoint")
    private String destEndpoint;
    @Column(columnName="component_id", storageOnly=true)
    private int componentId;
    @Column(columnName="entity_id", length=512)
    @BanyanDB.ShardingKey(index=0)
    private String entityId;

    @Override
    protected String id0() {
        String splitJointId = String.valueOf(this.getTimeBucket());
        splitJointId = splitJointId + "_" + this.entityId;
        return splitJointId;
    }

    @Override
    public boolean combine(Metrics metrics) {
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        EndpointRelationServerSideMetrics metrics = new EndpointRelationServerSideMetrics();
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setSourceEndpoint(this.getSourceEndpoint());
        metrics.setDestEndpoint(this.getDestEndpoint());
        metrics.setComponentId(this.getComponentId());
        metrics.setEntityId(this.getEntityId());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        EndpointRelationServerSideMetrics metrics = new EndpointRelationServerSideMetrics();
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setSourceEndpoint(this.getSourceEndpoint());
        metrics.setDestEndpoint(this.getDestEndpoint());
        metrics.setComponentId(this.getComponentId());
        metrics.setEntityId(this.getEntityId());
        return metrics;
    }

    @Override
    public int remoteHashCode() {
        int n = 17;
        n = 31 * n + this.entityId.hashCode();
        return n;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setComponentId(remoteData.getDataIntegers(0));
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setEntityId(remoteData.getDataStrings(0));
        this.setSourceEndpoint(remoteData.getDataStrings(1));
        this.setDestEndpoint(remoteData.getDataStrings(2));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataIntegers(this.getComponentId());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataStrings(this.getSourceEndpoint());
        remoteBuilder.addDataStrings(this.getDestEndpoint());
        return remoteBuilder;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointRelationServerSideMetrics)) {
            return false;
        }
        EndpointRelationServerSideMetrics other = (EndpointRelationServerSideMetrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        return !(this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EndpointRelationServerSideMetrics;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        return result;
    }

    @Generated
    public void setSourceEndpoint(String sourceEndpoint) {
        this.sourceEndpoint = sourceEndpoint;
    }

    @Generated
    public String getSourceEndpoint() {
        return this.sourceEndpoint;
    }

    @Generated
    public void setDestEndpoint(String destEndpoint) {
        this.destEndpoint = destEndpoint;
    }

    @Generated
    public String getDestEndpoint() {
        return this.destEndpoint;
    }

    @Generated
    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    @Generated
    public int getComponentId() {
        return this.componentId;
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    public static class Builder
    implements StorageBuilder<EndpointRelationServerSideMetrics> {
        @Override
        public EndpointRelationServerSideMetrics storage2Entity(Convert2Entity converter) {
            EndpointRelationServerSideMetrics metrics = new EndpointRelationServerSideMetrics();
            metrics.setSourceEndpoint((String)converter.get(EndpointRelationServerSideMetrics.SOURCE_ENDPOINT));
            metrics.setDestEndpoint((String)converter.get(EndpointRelationServerSideMetrics.DEST_ENDPOINT));
            metrics.setComponentId(((Number)converter.get(EndpointRelationServerSideMetrics.COMPONENT_ID)).intValue());
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(EndpointRelationServerSideMetrics storageData, Convert2Storage converter) {
            converter.accept(EndpointRelationServerSideMetrics.SOURCE_ENDPOINT, storageData.getSourceEndpoint());
            converter.accept(EndpointRelationServerSideMetrics.DEST_ENDPOINT, storageData.getDestEndpoint());
            converter.accept(EndpointRelationServerSideMetrics.COMPONENT_ID, storageData.getComponentId());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

