/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.process;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="service_label", scopeId=49, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=false)
public class ServiceLabelRecord
extends Metrics {
    public static final String INDEX_NAME = "service_label";
    public static final String SERVICE_ID = "service_id";
    public static final String LABEL = "label";
    @Column(columnName="service_id")
    private String serviceId;
    @Column(columnName="label", length=50)
    private String label;

    @Override
    public boolean combine(Metrics metrics) {
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    protected String id0() {
        return this.serviceId + "_" + new String(Base64.getEncoder().encode(this.label.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setServiceId(remoteData.getDataStrings(0));
        this.setLabel(remoteData.getDataStrings(1));
        this.setTimeBucket(remoteData.getDataLongs(0));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder builder = RemoteData.newBuilder();
        builder.addDataStrings(this.serviceId);
        builder.addDataStrings(this.label);
        builder.addDataLongs(this.getTimeBucket());
        return builder;
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceLabelRecord)) {
            return false;
        }
        ServiceLabelRecord other = (ServiceLabelRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceLabelRecord;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }

    public static class Builder
    implements StorageBuilder<ServiceLabelRecord> {
        @Override
        public ServiceLabelRecord storage2Entity(Convert2Entity converter) {
            ServiceLabelRecord record = new ServiceLabelRecord();
            record.setServiceId((String)converter.get(ServiceLabelRecord.SERVICE_ID));
            record.setLabel((String)converter.get(ServiceLabelRecord.LABEL));
            record.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return record;
        }

        @Override
        public void entity2Storage(ServiceLabelRecord entity, Convert2Storage converter) {
            converter.accept(ServiceLabelRecord.SERVICE_ID, entity.getServiceId());
            converter.accept(ServiceLabelRecord.LABEL, entity.getLabel());
            converter.accept("time_bucket", entity.getTimeBucket());
        }
    }
}

