/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.log;

import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.annotation.SQLDatabase;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

public abstract class AbstractLogRecord
extends Record {
    public static final String ADDITIONAL_TAG_TABLE = "log_tag";
    public static final String SERVICE_ID = "service_id";
    public static final String SERVICE_INSTANCE_ID = "service_instance_id";
    public static final String ENDPOINT_ID = "endpoint_id";
    public static final String TRACE_ID = "trace_id";
    public static final String TRACE_SEGMENT_ID = "trace_segment_id";
    public static final String SPAN_ID = "span_id";
    public static final String CONTENT_TYPE = "content_type";
    public static final String CONTENT = "content";
    public static final String TAGS_RAW_DATA = "tags_raw_data";
    public static final String TIMESTAMP = "timestamp";
    public static final String TAGS = "tags";
    @Column(columnName="service_id")
    @BanyanDB.ShardingKey(index=0)
    private String serviceId;
    @Column(columnName="service_instance_id")
    @BanyanDB.ShardingKey(index=1)
    private String serviceInstanceId;
    @Column(columnName="endpoint_id")
    private String endpointId;
    @Column(columnName="trace_id", length=150)
    @BanyanDB.GlobalIndex
    private String traceId;
    @Column(columnName="trace_segment_id", length=150)
    @BanyanDB.GlobalIndex
    private String traceSegmentId;
    @Column(columnName="span_id")
    @BanyanDB.NoIndexing
    private int spanId;
    @Column(columnName="content_type", storageOnly=true)
    private int contentType = ContentType.NONE.value();
    @Column(columnName="content", length=1000000)
    @ElasticSearch.MatchQuery(analyzer=ElasticSearch.MatchQuery.AnalyzerType.OAP_LOG_ANALYZER)
    private String content;
    @Column(columnName="timestamp")
    private long timestamp;
    @Column(columnName="tags_raw_data", storageOnly=true)
    private byte[] tagsRawData;
    @Column(columnName="tags", indexOnly=true)
    @SQLDatabase.AdditionalEntity(additionalTables={"log_tag"})
    private List<String> tagsInString;

    @Override
    public String id() {
        throw new UnexpectedException("AbstractLogRecord doesn't provide id()");
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public void setServiceInstanceId(String serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    @Generated
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Generated
    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    @Generated
    public String getEndpointId() {
        return this.endpointId;
    }

    @Generated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public void setTraceSegmentId(String traceSegmentId) {
        this.traceSegmentId = traceSegmentId;
    }

    @Generated
    public String getTraceSegmentId() {
        return this.traceSegmentId;
    }

    @Generated
    public void setSpanId(int spanId) {
        this.spanId = spanId;
    }

    @Generated
    public int getSpanId() {
        return this.spanId;
    }

    @Generated
    public void setContentType(int contentType) {
        this.contentType = contentType;
    }

    @Generated
    public int getContentType() {
        return this.contentType;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setTagsRawData(byte[] tagsRawData) {
        this.tagsRawData = tagsRawData;
    }

    @Generated
    public byte[] getTagsRawData() {
        return this.tagsRawData;
    }

    @Generated
    public void setTagsInString(List<String> tagsInString) {
        this.tagsInString = tagsInString;
    }

    @Generated
    public List<String> getTagsInString() {
        return this.tagsInString;
    }

    public static abstract class Builder<T extends AbstractLogRecord>
    implements StorageBuilder<T> {
        protected void map2Data(T record, Convert2Entity converter) {
            ((AbstractLogRecord)record).setServiceId((String)converter.get(AbstractLogRecord.SERVICE_ID));
            ((AbstractLogRecord)record).setServiceInstanceId((String)converter.get(AbstractLogRecord.SERVICE_INSTANCE_ID));
            ((AbstractLogRecord)record).setEndpointId((String)converter.get(AbstractLogRecord.ENDPOINT_ID));
            ((AbstractLogRecord)record).setTraceId((String)converter.get(AbstractLogRecord.TRACE_ID));
            ((AbstractLogRecord)record).setTraceSegmentId((String)converter.get(AbstractLogRecord.TRACE_SEGMENT_ID));
            ((AbstractLogRecord)record).setSpanId(((Number)converter.get(AbstractLogRecord.SPAN_ID)).intValue());
            ((AbstractLogRecord)record).setContentType(((Number)converter.get(AbstractLogRecord.CONTENT_TYPE)).intValue());
            ((AbstractLogRecord)record).setContent((String)converter.get(AbstractLogRecord.CONTENT));
            ((AbstractLogRecord)record).setTimestamp(((Number)converter.get(AbstractLogRecord.TIMESTAMP)).longValue());
            ((AbstractLogRecord)record).setTagsRawData(converter.getBytes(AbstractLogRecord.TAGS_RAW_DATA));
            ((Record)record).setTimeBucket(((Number)converter.get("time_bucket")).longValue());
        }

        protected void data2Map(T record, Convert2Storage converter) {
            converter.accept(AbstractLogRecord.SERVICE_ID, ((AbstractLogRecord)record).getServiceId());
            converter.accept(AbstractLogRecord.SERVICE_INSTANCE_ID, ((AbstractLogRecord)record).getServiceInstanceId());
            converter.accept(AbstractLogRecord.ENDPOINT_ID, ((AbstractLogRecord)record).getEndpointId());
            converter.accept(AbstractLogRecord.TRACE_ID, ((AbstractLogRecord)record).getTraceId());
            converter.accept(AbstractLogRecord.TRACE_SEGMENT_ID, ((AbstractLogRecord)record).getTraceSegmentId());
            converter.accept(AbstractLogRecord.SPAN_ID, ((AbstractLogRecord)record).getSpanId());
            converter.accept("time_bucket", ((Record)record).getTimeBucket());
            converter.accept(AbstractLogRecord.CONTENT_TYPE, ((AbstractLogRecord)record).getContentType());
            converter.accept(AbstractLogRecord.CONTENT, ((AbstractLogRecord)record).getContent());
            converter.accept(AbstractLogRecord.TIMESTAMP, ((AbstractLogRecord)record).getTimestamp());
            converter.accept(AbstractLogRecord.TAGS_RAW_DATA, ((AbstractLogRecord)record).getTagsRawData());
            converter.accept(AbstractLogRecord.TAGS, ((AbstractLogRecord)record).getTagsInString());
        }
    }
}

