/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.instance;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.util.StringUtil;

@Stream(name="instance_traffic", scopeId=2, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=true)
public class InstanceTraffic
extends Metrics {
    public static final String INDEX_NAME = "instance_traffic";
    public static final String SERVICE_ID = "service_id";
    public static final String NAME = "name";
    public static final String LAST_PING_TIME_BUCKET = "last_ping";
    public static final String PROPERTIES = "properties";
    private static final Gson GSON = new Gson();
    @Column(columnName="service_id")
    private String serviceId;
    @Column(columnName="name", storageOnly=true)
    @ElasticSearch.Column(columnAlias="instance_traffic_name")
    private String name;
    @Column(columnName="last_ping")
    private long lastPingTimestamp;
    @Column(columnName="properties", storageOnly=true, length=50000)
    private JsonObject properties;

    @Override
    public boolean combine(Metrics metrics) {
        InstanceTraffic instanceTraffic = (InstanceTraffic)metrics;
        this.lastPingTimestamp = instanceTraffic.getLastPingTimestamp();
        if (instanceTraffic.getProperties() != null && instanceTraffic.getProperties().size() > 0) {
            if (this.properties == null) {
                this.properties = new JsonObject();
            }
            instanceTraffic.getProperties().entrySet().forEach(it -> this.properties.add((String)it.getKey(), (JsonElement)it.getValue()));
        }
        if (this.getTimeBucket() > metrics.getTimeBucket()) {
            this.setTimeBucket(metrics.getTimeBucket());
        }
        return true;
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setServiceId(remoteData.getDataStrings(0));
        this.setName(remoteData.getDataStrings(1));
        String propString = remoteData.getDataStrings(2);
        if (StringUtil.isNotEmpty((String)propString)) {
            this.setProperties((JsonObject)GSON.fromJson(propString, JsonObject.class));
        }
        this.setLastPingTimestamp(remoteData.getDataLongs(0));
        this.setTimeBucket(remoteData.getDataLongs(1));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder builder = RemoteData.newBuilder();
        builder.addDataStrings(this.serviceId);
        builder.addDataStrings(this.name);
        if (this.properties == null) {
            builder.addDataStrings("");
        } else {
            builder.addDataStrings(GSON.toJson((JsonElement)this.properties));
        }
        builder.addDataLongs(this.lastPingTimestamp);
        builder.addDataLongs(this.getTimeBucket());
        return builder;
    }

    @Override
    protected String id0() {
        return IDManager.ServiceInstanceID.buildId(this.serviceId, this.name);
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceTraffic)) {
            return false;
        }
        InstanceTraffic other = (InstanceTraffic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InstanceTraffic;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setLastPingTimestamp(long lastPingTimestamp) {
        this.lastPingTimestamp = lastPingTimestamp;
    }

    @Generated
    public long getLastPingTimestamp() {
        return this.lastPingTimestamp;
    }

    @Generated
    public void setProperties(JsonObject properties) {
        this.properties = properties;
    }

    @Generated
    public JsonObject getProperties() {
        return this.properties;
    }

    public static class PropertyUtil {
        public static final String NAMESPACE = "namespace";
        public static final String POD = "pod";
        public static final String LANGUAGE = "language";
        public static final String IPV4 = "ipv4";
        public static final String IPV4S = "ipv4s";
    }

    public static class Builder
    implements StorageBuilder<InstanceTraffic> {
        @Override
        public InstanceTraffic storage2Entity(Convert2Entity converter) {
            InstanceTraffic instanceTraffic = new InstanceTraffic();
            instanceTraffic.setServiceId((String)converter.get(InstanceTraffic.SERVICE_ID));
            instanceTraffic.setName((String)converter.get(InstanceTraffic.NAME));
            String propString = (String)converter.get(InstanceTraffic.PROPERTIES);
            if (StringUtil.isNotEmpty((String)propString)) {
                instanceTraffic.setProperties((JsonObject)GSON.fromJson(propString, JsonObject.class));
            }
            instanceTraffic.setLastPingTimestamp(((Number)converter.get(InstanceTraffic.LAST_PING_TIME_BUCKET)).longValue());
            instanceTraffic.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return instanceTraffic;
        }

        @Override
        public void entity2Storage(InstanceTraffic storageData, Convert2Storage converter) {
            converter.accept(InstanceTraffic.SERVICE_ID, storageData.getServiceId());
            converter.accept(InstanceTraffic.NAME, storageData.getName());
            if (storageData.getProperties() != null) {
                converter.accept(InstanceTraffic.PROPERTIES, GSON.toJson((JsonElement)storageData.getProperties()));
            } else {
                converter.accept(InstanceTraffic.PROPERTIES, "");
            }
            converter.accept(InstanceTraffic.LAST_PING_TIME_BUCKET, storageData.getLastPingTimestamp());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

