/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.endpoint;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="endpoint_traffic", scopeId=3, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=false)
public class EndpointTraffic
extends Metrics {
    public static final String INDEX_NAME = "endpoint_traffic";
    public static final String SERVICE_ID = "service_id";
    public static final String NAME = "name";
    @Column(columnName="service_id")
    private String serviceId;
    @Column(columnName="name")
    @ElasticSearch.MatchQuery
    @ElasticSearch.Column(columnAlias="endpoint_traffic_name")
    private String name = "";

    @Override
    protected String id0() {
        return IDManager.EndpointID.buildId(this.getServiceId(), this.getName());
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.serviceId);
        remoteBuilder.addDataStrings(Strings.isNullOrEmpty((String)this.name) ? "" : this.name);
        return remoteBuilder;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setServiceId(remoteData.getDataStrings(0));
        this.setName(remoteData.getDataStrings(1));
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Override
    public boolean combine(Metrics metrics) {
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointTraffic)) {
            return false;
        }
        EndpointTraffic other = (EndpointTraffic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EndpointTraffic;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    public static class Builder
    implements StorageBuilder<EndpointTraffic> {
        @Override
        public EndpointTraffic storage2Entity(Convert2Entity converter) {
            EndpointTraffic inventory = new EndpointTraffic();
            inventory.setServiceId((String)converter.get(EndpointTraffic.SERVICE_ID));
            inventory.setName((String)converter.get(EndpointTraffic.NAME));
            inventory.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return inventory;
        }

        @Override
        public void entity2Storage(EndpointTraffic storageData, Convert2Storage converter) {
            converter.accept(EndpointTraffic.SERVICE_ID, storageData.getServiceId());
            converter.accept(EndpointTraffic.NAME, storageData.getName());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

