/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.database;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.topn.TopN;
import org.apache.skywalking.oap.server.core.analysis.worker.TopNStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="top_n_database_statement", scopeId=18, builder=Builder.class, processor=TopNStreamProcessor.class)
public class TopNDatabaseStatement
extends TopN {
    public static final String INDEX_NAME = "top_n_database_statement";
    private String id;
    @Column(columnName="statement", length=2000, lengthEnvVariable="SW_SLOW_DB_THRESHOLD", storageOnly=true)
    private String statement;

    @Override
    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopNDatabaseStatement statement = (TopNDatabaseStatement)o;
        return this.getServiceId() == statement.getServiceId();
    }

    public int hashCode() {
        return Objects.hash(this.getServiceId());
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public String getStatement() {
        return this.statement;
    }

    @Generated
    public void setStatement(String statement) {
        this.statement = statement;
    }

    public static class Builder
    implements StorageBuilder<TopNDatabaseStatement> {
        @Override
        public TopNDatabaseStatement storage2Entity(Convert2Entity converter) {
            TopNDatabaseStatement statement = new TopNDatabaseStatement();
            statement.setStatement((String)converter.get("statement"));
            statement.setTraceId((String)converter.get("trace_id"));
            statement.setLatency(((Number)converter.get("latency")).longValue());
            statement.setServiceId((String)converter.get("service_id"));
            statement.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return statement;
        }

        @Override
        public void entity2Storage(TopNDatabaseStatement storageData, Convert2Storage converter) {
            converter.accept("statement", storageData.getStatement());
            converter.accept("trace_id", storageData.getTraceId());
            converter.accept("latency", storageData.getLatency());
            converter.accept("service_id", storageData.getServiceId());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

