/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis;

import java.util.Calendar;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;

public class TimeBucket {
    public static long getRecordTimeBucket(long time) {
        return TimeBucket.getTimeBucket(time, DownSampling.Second);
    }

    public static long getMinuteTimeBucket(long time) {
        return TimeBucket.getTimeBucket(time, DownSampling.Minute);
    }

    public static long getTimestamp(long timeBucket) {
        if (TimeBucket.isSecondBucket(timeBucket)) {
            return TimeBucket.getTimestamp(timeBucket, DownSampling.Second);
        }
        if (TimeBucket.isMinuteBucket(timeBucket)) {
            return TimeBucket.getTimestamp(timeBucket, DownSampling.Minute);
        }
        if (TimeBucket.isHourBucket(timeBucket)) {
            return TimeBucket.getTimestamp(timeBucket, DownSampling.Hour);
        }
        if (TimeBucket.isDayBucket(timeBucket)) {
            return TimeBucket.getTimestamp(timeBucket, DownSampling.Day);
        }
        throw new UnexpectedException("Unknown downsampling value.");
    }

    public static boolean isSecondBucket(long timeBucket) {
        return timeBucket < 99999999999999L && timeBucket > 10000000000000L;
    }

    public static boolean isMinuteBucket(long timeBucket) {
        return timeBucket < 999999999999L && timeBucket > 100000000000L;
    }

    public static boolean isHourBucket(long timeBucket) {
        return timeBucket < 9999999999L && timeBucket > 1000000000L;
    }

    public static boolean isDayBucket(long timeBucket) {
        return timeBucket < 99999999L && timeBucket > 10000000L;
    }

    public static long getTimestamp(long timeBucket, DownSampling downsampling) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(0L);
        calendar.set(12, 0);
        calendar.set(11, 0);
        switch (downsampling) {
            case Second: {
                calendar.set(13, (int)(timeBucket % 100L));
                timeBucket /= 100L;
            }
            case Minute: {
                calendar.set(12, (int)(timeBucket % 100L));
                timeBucket /= 100L;
            }
            case Hour: {
                calendar.set(11, (int)(timeBucket % 100L));
                timeBucket /= 100L;
            }
            case Day: {
                calendar.set(5, (int)(timeBucket % 100L));
                calendar.set(2, (int)((timeBucket /= 100L) % 100L) - 1);
                calendar.set(1, (int)(timeBucket / 100L));
                break;
            }
            default: {
                throw new UnexpectedException("Unknown downsampling value.");
            }
        }
        return calendar.getTimeInMillis();
    }

    public static long getTimeBucket(long timestamp, DownSampling downsampling) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        long year = calendar.get(1);
        long month = calendar.get(2) + 1;
        long day = calendar.get(5);
        long hour = calendar.get(11);
        long minute = calendar.get(12);
        long second = calendar.get(13);
        switch (downsampling) {
            case Second: {
                return year * 10000000000L + month * 100000000L + day * 1000000L + hour * 10000L + minute * 100L + second;
            }
            case Minute: {
                return year * 100000000L + month * 1000000L + day * 10000L + hour * 100L + minute;
            }
            case Hour: {
                return year * 1000000L + month * 10000L + day * 100L + hour;
            }
            case Day: {
                return year * 10000L + month * 100L + day;
            }
        }
        throw new UnexpectedException("Unknown downsampling value.");
    }
}

