/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;

public class IDManager {
    private static String encode(String text) {
        return new String(Base64.getEncoder().encode(text.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    private static String decode(String base64text) {
        return new String(Base64.getDecoder().decode(base64text), StandardCharsets.UTF_8);
    }

    public static class NetworkAddressAliasDefine {
        public static String buildId(String name) {
            return IDManager.encode(name);
        }

        public static String analysisId(String id) {
            return IDManager.decode(id);
        }
    }

    public static class ProcessID {
        public static String buildId(String instanceId, String name) {
            return Hashing.sha256().newHasher().putString((CharSequence)String.format("%s_%s", name, instanceId), Charsets.UTF_8).hash().toString();
        }

        public static String buildRelationId(ProcessRelationDefine define) {
            return define.sourceId + "-" + define.destId;
        }

        public static ProcessRelationDefine analysisRelationId(String entityId) {
            String[] parts = entityId.split("\\-");
            if (parts.length != 2) {
                throw new RuntimeException("Illegal Process Relation entity id");
            }
            return new ProcessRelationDefine(parts[0], parts[1]);
        }

        public static class ProcessRelationDefine {
            private final String sourceId;
            private final String destId;

            @Generated
            public ProcessRelationDefine(String sourceId, String destId) {
                this.sourceId = sourceId;
                this.destId = destId;
            }

            @Generated
            public String getSourceId() {
                return this.sourceId;
            }

            @Generated
            public String getDestId() {
                return this.destId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ProcessRelationDefine)) {
                    return false;
                }
                ProcessRelationDefine other = (ProcessRelationDefine)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$sourceId = this.getSourceId();
                String other$sourceId = other.getSourceId();
                if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
                    return false;
                }
                String this$destId = this.getDestId();
                String other$destId = other.getDestId();
                return !(this$destId == null ? other$destId != null : !this$destId.equals(other$destId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ProcessRelationDefine;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $sourceId = this.getSourceId();
                result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
                String $destId = this.getDestId();
                result = result * 59 + ($destId == null ? 43 : $destId.hashCode());
                return result;
            }
        }
    }

    public static class EndpointID {
        public static String buildId(String serviceId, String endpointName) {
            return serviceId + "_" + IDManager.encode(endpointName);
        }

        public static EndpointIDDefinition analysisId(String id) {
            String[] strings = id.split("\\_");
            if (strings.length != 2) {
                throw new UnexpectedException("Can't split endpoint id into 2 parts, " + id);
            }
            return new EndpointIDDefinition(strings[0], IDManager.decode(strings[1]));
        }

        public static String buildRelationId(EndpointRelationDefine define) {
            return define.sourceServiceId + "-" + IDManager.encode(define.source) + "-" + define.destServiceId + "-" + IDManager.encode(define.dest);
        }

        public static EndpointRelationDefine analysisRelationId(String entityId) {
            String[] parts = entityId.split("\\-");
            if (parts.length != 4) {
                throw new UnexpectedException("Illegal endpoint Relation entity id, " + entityId);
            }
            return new EndpointRelationDefine(parts[0], IDManager.decode(parts[1]), parts[2], IDManager.decode(parts[3]));
        }

        public static class EndpointRelationDefine {
            private final String sourceServiceId;
            private final String source;
            private final String destServiceId;
            private final String dest;

            @Generated
            public EndpointRelationDefine(String sourceServiceId, String source, String destServiceId, String dest) {
                this.sourceServiceId = sourceServiceId;
                this.source = source;
                this.destServiceId = destServiceId;
                this.dest = dest;
            }

            @Generated
            public String getSourceServiceId() {
                return this.sourceServiceId;
            }

            @Generated
            public String getSource() {
                return this.source;
            }

            @Generated
            public String getDestServiceId() {
                return this.destServiceId;
            }

            @Generated
            public String getDest() {
                return this.dest;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof EndpointRelationDefine)) {
                    return false;
                }
                EndpointRelationDefine other = (EndpointRelationDefine)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$sourceServiceId = this.getSourceServiceId();
                String other$sourceServiceId = other.getSourceServiceId();
                if (this$sourceServiceId == null ? other$sourceServiceId != null : !this$sourceServiceId.equals(other$sourceServiceId)) {
                    return false;
                }
                String this$source = this.getSource();
                String other$source = other.getSource();
                if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                    return false;
                }
                String this$destServiceId = this.getDestServiceId();
                String other$destServiceId = other.getDestServiceId();
                if (this$destServiceId == null ? other$destServiceId != null : !this$destServiceId.equals(other$destServiceId)) {
                    return false;
                }
                String this$dest = this.getDest();
                String other$dest = other.getDest();
                return !(this$dest == null ? other$dest != null : !this$dest.equals(other$dest));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof EndpointRelationDefine;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $sourceServiceId = this.getSourceServiceId();
                result = result * 59 + ($sourceServiceId == null ? 43 : $sourceServiceId.hashCode());
                String $source = this.getSource();
                result = result * 59 + ($source == null ? 43 : $source.hashCode());
                String $destServiceId = this.getDestServiceId();
                result = result * 59 + ($destServiceId == null ? 43 : $destServiceId.hashCode());
                String $dest = this.getDest();
                result = result * 59 + ($dest == null ? 43 : $dest.hashCode());
                return result;
            }
        }

        public static class EndpointIDDefinition {
            private final String serviceId;
            private final String endpointName;

            @Generated
            public EndpointIDDefinition(String serviceId, String endpointName) {
                this.serviceId = serviceId;
                this.endpointName = endpointName;
            }

            @Generated
            public String getServiceId() {
                return this.serviceId;
            }

            @Generated
            public String getEndpointName() {
                return this.endpointName;
            }
        }
    }

    public static class ServiceInstanceID {
        public static String buildId(String serviceId, String instanceName) {
            return serviceId + "_" + IDManager.encode(instanceName);
        }

        public static InstanceIDDefinition analysisId(String id) {
            String[] strings = id.split("\\_");
            if (strings.length != 2) {
                throw new UnexpectedException("Can't split instance id into 2 parts, " + id);
            }
            return new InstanceIDDefinition(strings[0], IDManager.decode(strings[1]));
        }

        public static String buildRelationId(ServiceInstanceRelationDefine define) {
            return define.sourceId + "-" + define.destId;
        }

        public static ServiceInstanceRelationDefine analysisRelationId(String entityId) {
            String[] parts = entityId.split("\\-");
            if (parts.length != 2) {
                throw new RuntimeException("Illegal Service Instance Relation entity id");
            }
            return new ServiceInstanceRelationDefine(parts[0], parts[1]);
        }

        public static class ServiceInstanceRelationDefine {
            private final String sourceId;
            private final String destId;

            @Generated
            public ServiceInstanceRelationDefine(String sourceId, String destId) {
                this.sourceId = sourceId;
                this.destId = destId;
            }

            @Generated
            public String getSourceId() {
                return this.sourceId;
            }

            @Generated
            public String getDestId() {
                return this.destId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ServiceInstanceRelationDefine)) {
                    return false;
                }
                ServiceInstanceRelationDefine other = (ServiceInstanceRelationDefine)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$sourceId = this.getSourceId();
                String other$sourceId = other.getSourceId();
                if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
                    return false;
                }
                String this$destId = this.getDestId();
                String other$destId = other.getDestId();
                return !(this$destId == null ? other$destId != null : !this$destId.equals(other$destId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ServiceInstanceRelationDefine;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $sourceId = this.getSourceId();
                result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
                String $destId = this.getDestId();
                result = result * 59 + ($destId == null ? 43 : $destId.hashCode());
                return result;
            }
        }

        public static class InstanceIDDefinition {
            private final String serviceId;
            private final String name;

            @Generated
            public InstanceIDDefinition(String serviceId, String name) {
                this.serviceId = serviceId;
                this.name = name;
            }

            @Generated
            public String getServiceId() {
                return this.serviceId;
            }

            @Generated
            public String getName() {
                return this.name;
            }
        }
    }

    public static class ServiceID {
        public static String buildId(String name, boolean isNormal) {
            return IDManager.encode(name) + "." + BooleanUtils.booleanToValue((Boolean)isNormal);
        }

        public static ServiceIDDefinition analysisId(String id) {
            String[] strings = id.split("\\.");
            if (strings.length != 2) {
                throw new UnexpectedException("Can't split service id into 2 parts, " + id);
            }
            return new ServiceIDDefinition(IDManager.decode(strings[0]), BooleanUtils.valueToBoolean((int)Integer.parseInt(strings[1])));
        }

        public static String buildRelationId(ServiceRelationDefine define) {
            return define.sourceId + "-" + define.destId;
        }

        public static ServiceRelationDefine analysisRelationId(String entityId) {
            String[] parts = entityId.split("\\-");
            if (parts.length != 2) {
                throw new RuntimeException("Illegal Service Relation entity id");
            }
            return new ServiceRelationDefine(parts[0], parts[1]);
        }

        public static class ServiceRelationDefine {
            private final String sourceId;
            private final String destId;

            @Generated
            public ServiceRelationDefine(String sourceId, String destId) {
                this.sourceId = sourceId;
                this.destId = destId;
            }

            @Generated
            public String getSourceId() {
                return this.sourceId;
            }

            @Generated
            public String getDestId() {
                return this.destId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ServiceRelationDefine)) {
                    return false;
                }
                ServiceRelationDefine other = (ServiceRelationDefine)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$sourceId = this.getSourceId();
                String other$sourceId = other.getSourceId();
                if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
                    return false;
                }
                String this$destId = this.getDestId();
                String other$destId = other.getDestId();
                return !(this$destId == null ? other$destId != null : !this$destId.equals(other$destId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ServiceRelationDefine;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $sourceId = this.getSourceId();
                result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
                String $destId = this.getDestId();
                result = result * 59 + ($destId == null ? 43 : $destId.hashCode());
                return result;
            }
        }

        public static class ServiceIDDefinition {
            private final String name;
            private final boolean isReal;

            @Generated
            public ServiceIDDefinition(String name, boolean isReal) {
                this.name = name;
                this.isReal = isReal;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public boolean isReal() {
                return this.isReal;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ServiceIDDefinition)) {
                    return false;
                }
                ServiceIDDefinition other = (ServiceIDDefinition)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isReal() != other.isReal()) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ServiceIDDefinition;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isReal() ? 79 : 97);
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }
        }
    }
}

