/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis;

import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.core.CoreModuleProvider;
import org.apache.skywalking.oap.server.core.analysis.ConfigurationDictionary;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ApdexThresholdConfig
extends ConfigChangeWatcher
implements ConfigurationDictionary {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApdexThresholdConfig.class);
    private static final String CONFIG_FILE_NAME = "service-apdex-threshold.yml";
    private static final int SYSTEM_RESERVED_THRESHOLD = 500;
    private Map<String, Integer> dictionary = Collections.emptyMap();
    private String rawConfig = null;

    public ApdexThresholdConfig(CoreModuleProvider provider) {
        super("core", (ModuleProvider)provider, "apdexThreshold");
        try {
            this.updateConfig(ResourceUtils.read((String)CONFIG_FILE_NAME));
        }
        catch (FileNotFoundException e) {
            log.error("Cannot config from: {}", (Object)CONFIG_FILE_NAME, (Object)e);
        }
    }

    @Override
    public Number lookup(String name) {
        int t = this.dictionary.getOrDefault(name, -1);
        if (t < 0) {
            t = this.dictionary.getOrDefault("default", -1);
        }
        if (t < 0) {
            log.warn("Pick up system reserved threshold {}ms because of config missing", (Object)500);
            return 500;
        }
        if (log.isDebugEnabled()) {
            log.debug("Apdex threshold of {} is {}ms", (Object)name, (Object)t);
        }
        return t;
    }

    public void notify(ConfigChangeWatcher.ConfigChangeEvent value) {
        if (ConfigChangeWatcher.EventType.DELETE.equals((Object)value.getEventType())) {
            this.activeSetting(null);
        } else {
            this.activeSetting(value.getNewValue());
        }
    }

    public String value() {
        return this.rawConfig;
    }

    private synchronized void activeSetting(String config) {
        if (log.isDebugEnabled()) {
            log.debug("Updating using new static config: {}", (Object)config);
        }
        this.rawConfig = config;
        this.updateConfig(new StringReader(Strings.nullToEmpty((String)config)));
    }

    private void updateConfig(Reader contentRender) {
        this.dictionary = (Map)new Yaml((BaseConstructor)new SafeConstructor()).load(contentRender);
        if (this.dictionary == null) {
            this.dictionary = Collections.emptyMap();
        }
    }
}

