/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.agent.DebugConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="DebugConfig", generator="Immutables")
@Immutable
public final class ImmutableDebugConfig
extends DebugConfig {
    private final boolean bootstrap;
    private final String datacenter;
    private final String dataDir;
    private final ImmutableList<String> dnsRecursors;
    private final String dnsDomain;
    private final String logLevel;
    private final String nodeName;
    private final ImmutableList<String> clientAddrs;
    private final String bindAddr;
    private final boolean leaveOnTerm;
    private final boolean skipLeaveOnInt;
    private final boolean enableDebug;
    private final boolean verifyIncoming;
    private final boolean verifyOutgoing;
    private final String caFile;
    private final String certFile;
    private final String keyFile;
    @Nullable
    private final String uiDir;
    private final String pidFile;
    private final boolean enableSyslog;
    private final boolean rejoinAfterLeave;
    private final String advertiseAddrLAN;
    private final String advertiseAddrWAN;

    private ImmutableDebugConfig(boolean bootstrap, String datacenter, String dataDir, ImmutableList<String> dnsRecursors, String dnsDomain, String logLevel, String nodeName, ImmutableList<String> clientAddrs, String bindAddr, boolean leaveOnTerm, boolean skipLeaveOnInt, boolean enableDebug, boolean verifyIncoming, boolean verifyOutgoing, String caFile, String certFile, String keyFile, @Nullable String uiDir, String pidFile, boolean enableSyslog, boolean rejoinAfterLeave, String advertiseAddrLAN, String advertiseAddrWAN) {
        this.bootstrap = bootstrap;
        this.datacenter = datacenter;
        this.dataDir = dataDir;
        this.dnsRecursors = dnsRecursors;
        this.dnsDomain = dnsDomain;
        this.logLevel = logLevel;
        this.nodeName = nodeName;
        this.clientAddrs = clientAddrs;
        this.bindAddr = bindAddr;
        this.leaveOnTerm = leaveOnTerm;
        this.skipLeaveOnInt = skipLeaveOnInt;
        this.enableDebug = enableDebug;
        this.verifyIncoming = verifyIncoming;
        this.verifyOutgoing = verifyOutgoing;
        this.caFile = caFile;
        this.certFile = certFile;
        this.keyFile = keyFile;
        this.uiDir = uiDir;
        this.pidFile = pidFile;
        this.enableSyslog = enableSyslog;
        this.rejoinAfterLeave = rejoinAfterLeave;
        this.advertiseAddrLAN = advertiseAddrLAN;
        this.advertiseAddrWAN = advertiseAddrWAN;
    }

    @Override
    @JsonProperty(value="Bootstrap")
    public boolean getBootstrap() {
        return this.bootstrap;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public String getDatacenter() {
        return this.datacenter;
    }

    @Override
    @JsonProperty(value="DataDir")
    public String getDataDir() {
        return this.dataDir;
    }

    @JsonProperty(value="DNSRecursors")
    public ImmutableList<String> dnsRecursors() {
        return this.dnsRecursors;
    }

    @Override
    @JsonProperty(value="DNSDomain")
    public String getDnsDomain() {
        return this.dnsDomain;
    }

    @Override
    @JsonProperty(value="LogLevel")
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    @JsonProperty(value="NodeName")
    public String getNodeName() {
        return this.nodeName;
    }

    @JsonProperty(value="ClientAddrs")
    public ImmutableList<String> getClientAddrs() {
        return this.clientAddrs;
    }

    @Override
    @JsonProperty(value="BindAddr")
    public String getBindAddr() {
        return this.bindAddr;
    }

    @Override
    @JsonProperty(value="LeaveOnTerm")
    public boolean getLeaveOnTerm() {
        return this.leaveOnTerm;
    }

    @Override
    @JsonProperty(value="SkipLeaveOnInt")
    public boolean getSkipLeaveOnInt() {
        return this.skipLeaveOnInt;
    }

    @Override
    @JsonProperty(value="EnableDebug")
    public boolean getEnableDebug() {
        return this.enableDebug;
    }

    @Override
    @JsonProperty(value="VerifyIncoming")
    public boolean getVerifyIncoming() {
        return this.verifyIncoming;
    }

    @Override
    @JsonProperty(value="VerifyOutgoing")
    public boolean getVerifyOutgoing() {
        return this.verifyOutgoing;
    }

    @Override
    @JsonProperty(value="CAFile")
    public String getCaFile() {
        return this.caFile;
    }

    @Override
    @JsonProperty(value="CertFile")
    public String getCertFile() {
        return this.certFile;
    }

    @Override
    @JsonProperty(value="KeyFile")
    public String getKeyFile() {
        return this.keyFile;
    }

    @Override
    @JsonProperty(value="UiDir")
    public Optional<String> getUiDir() {
        return Optional.ofNullable(this.uiDir);
    }

    @Override
    @JsonProperty(value="PidFile")
    public String getPidFile() {
        return this.pidFile;
    }

    @Override
    @JsonProperty(value="EnableSyslog")
    public boolean getEnableSyslog() {
        return this.enableSyslog;
    }

    @Override
    @JsonProperty(value="RejoinAfterLeave")
    public boolean getRejoinAfterLeave() {
        return this.rejoinAfterLeave;
    }

    @Override
    @JsonProperty(value="AdvertiseAddrLAN")
    public String getAdvertiseAddrLAN() {
        return this.advertiseAddrLAN;
    }

    @Override
    @JsonProperty(value="AdvertiseAddrWAN")
    public String getAdvertiseAddrWAN() {
        return this.advertiseAddrWAN;
    }

    public final ImmutableDebugConfig withBootstrap(boolean value) {
        if (this.bootstrap == value) {
            return this;
        }
        return new ImmutableDebugConfig(value, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (this.datacenter.equals(newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, newValue, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withDataDir(String value) {
        String newValue = Objects.requireNonNull(value, "dataDir");
        if (this.dataDir.equals(newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, newValue, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withDnsRecursors(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, (ImmutableList<String>)newValue, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withDnsRecursors(Iterable<String> elements) {
        if (this.dnsRecursors == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, (ImmutableList<String>)newValue, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withDnsDomain(String value) {
        String newValue = Objects.requireNonNull(value, "dnsDomain");
        if (this.dnsDomain.equals(newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, newValue, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withLogLevel(String value) {
        String newValue = Objects.requireNonNull(value, "logLevel");
        if (this.logLevel.equals(newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, newValue, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withNodeName(String value) {
        String newValue = Objects.requireNonNull(value, "nodeName");
        if (this.nodeName.equals(newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, newValue, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withClientAddrs(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, (ImmutableList<String>)newValue, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withClientAddrs(Iterable<String> elements) {
        if (this.clientAddrs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, (ImmutableList<String>)newValue, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withBindAddr(String value) {
        String newValue = Objects.requireNonNull(value, "bindAddr");
        if (this.bindAddr.equals(newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, newValue, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withLeaveOnTerm(boolean value) {
        if (this.leaveOnTerm == value) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, value, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withSkipLeaveOnInt(boolean value) {
        if (this.skipLeaveOnInt == value) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, value, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withEnableDebug(boolean value) {
        if (this.enableDebug == value) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, value, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withVerifyIncoming(boolean value) {
        if (this.verifyIncoming == value) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, value, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withVerifyOutgoing(boolean value) {
        if (this.verifyOutgoing == value) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, value, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withCaFile(String value) {
        String newValue = Objects.requireNonNull(value, "caFile");
        if (this.caFile.equals(newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, newValue, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withCertFile(String value) {
        String newValue = Objects.requireNonNull(value, "certFile");
        if (this.certFile.equals(newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, newValue, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withKeyFile(String value) {
        String newValue = Objects.requireNonNull(value, "keyFile");
        if (this.keyFile.equals(newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, newValue, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withUiDir(String value) {
        String newValue = Objects.requireNonNull(value, "uiDir");
        if (Objects.equals(this.uiDir, newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, newValue, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withUiDir(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.uiDir, value)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, value, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withPidFile(String value) {
        String newValue = Objects.requireNonNull(value, "pidFile");
        if (this.pidFile.equals(newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, newValue, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withEnableSyslog(boolean value) {
        if (this.enableSyslog == value) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, value, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withRejoinAfterLeave(boolean value) {
        if (this.rejoinAfterLeave == value) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, value, this.advertiseAddrLAN, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withAdvertiseAddrLAN(String value) {
        String newValue = Objects.requireNonNull(value, "advertiseAddrLAN");
        if (this.advertiseAddrLAN.equals(newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, newValue, this.advertiseAddrWAN);
    }

    public final ImmutableDebugConfig withAdvertiseAddrWAN(String value) {
        String newValue = Objects.requireNonNull(value, "advertiseAddrWAN");
        if (this.advertiseAddrWAN.equals(newValue)) {
            return this;
        }
        return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors, this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs, this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDebugConfig && this.equalTo((ImmutableDebugConfig)another);
    }

    private boolean equalTo(ImmutableDebugConfig another) {
        return this.bootstrap == another.bootstrap && this.datacenter.equals(another.datacenter) && this.dataDir.equals(another.dataDir) && this.dnsRecursors.equals(another.dnsRecursors) && this.dnsDomain.equals(another.dnsDomain) && this.logLevel.equals(another.logLevel) && this.nodeName.equals(another.nodeName) && this.clientAddrs.equals(another.clientAddrs) && this.bindAddr.equals(another.bindAddr) && this.leaveOnTerm == another.leaveOnTerm && this.skipLeaveOnInt == another.skipLeaveOnInt && this.enableDebug == another.enableDebug && this.verifyIncoming == another.verifyIncoming && this.verifyOutgoing == another.verifyOutgoing && this.caFile.equals(another.caFile) && this.certFile.equals(another.certFile) && this.keyFile.equals(another.keyFile) && Objects.equals(this.uiDir, another.uiDir) && this.pidFile.equals(another.pidFile) && this.enableSyslog == another.enableSyslog && this.rejoinAfterLeave == another.rejoinAfterLeave && this.advertiseAddrLAN.equals(another.advertiseAddrLAN) && this.advertiseAddrWAN.equals(another.advertiseAddrWAN);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.bootstrap);
        h += (h << 5) + this.datacenter.hashCode();
        h += (h << 5) + this.dataDir.hashCode();
        h += (h << 5) + this.dnsRecursors.hashCode();
        h += (h << 5) + this.dnsDomain.hashCode();
        h += (h << 5) + this.logLevel.hashCode();
        h += (h << 5) + this.nodeName.hashCode();
        h += (h << 5) + this.clientAddrs.hashCode();
        h += (h << 5) + this.bindAddr.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.leaveOnTerm);
        h += (h << 5) + Booleans.hashCode((boolean)this.skipLeaveOnInt);
        h += (h << 5) + Booleans.hashCode((boolean)this.enableDebug);
        h += (h << 5) + Booleans.hashCode((boolean)this.verifyIncoming);
        h += (h << 5) + Booleans.hashCode((boolean)this.verifyOutgoing);
        h += (h << 5) + this.caFile.hashCode();
        h += (h << 5) + this.certFile.hashCode();
        h += (h << 5) + this.keyFile.hashCode();
        h += (h << 5) + Objects.hashCode(this.uiDir);
        h += (h << 5) + this.pidFile.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.enableSyslog);
        h += (h << 5) + Booleans.hashCode((boolean)this.rejoinAfterLeave);
        h += (h << 5) + this.advertiseAddrLAN.hashCode();
        h += (h << 5) + this.advertiseAddrWAN.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DebugConfig").omitNullValues().add("bootstrap", this.bootstrap).add("datacenter", (Object)this.datacenter).add("dataDir", (Object)this.dataDir).add("dnsRecursors", this.dnsRecursors).add("dnsDomain", (Object)this.dnsDomain).add("logLevel", (Object)this.logLevel).add("nodeName", (Object)this.nodeName).add("clientAddrs", this.clientAddrs).add("bindAddr", (Object)this.bindAddr).add("leaveOnTerm", this.leaveOnTerm).add("skipLeaveOnInt", this.skipLeaveOnInt).add("enableDebug", this.enableDebug).add("verifyIncoming", this.verifyIncoming).add("verifyOutgoing", this.verifyOutgoing).add("caFile", (Object)this.caFile).add("certFile", (Object)this.certFile).add("keyFile", (Object)this.keyFile).add("uiDir", (Object)this.uiDir).add("pidFile", (Object)this.pidFile).add("enableSyslog", this.enableSyslog).add("rejoinAfterLeave", this.rejoinAfterLeave).add("advertiseAddrLAN", (Object)this.advertiseAddrLAN).add("advertiseAddrWAN", (Object)this.advertiseAddrWAN).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDebugConfig fromJson(Json json) {
        Builder builder = ImmutableDebugConfig.builder();
        if (json.bootstrapIsSet) {
            builder.bootstrap(json.bootstrap);
        }
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        if (json.dataDir != null) {
            builder.dataDir(json.dataDir);
        }
        if (json.dnsRecursors != null) {
            builder.addAllDnsRecursors(json.dnsRecursors);
        }
        if (json.dnsDomain != null) {
            builder.dnsDomain(json.dnsDomain);
        }
        if (json.logLevel != null) {
            builder.logLevel(json.logLevel);
        }
        if (json.nodeName != null) {
            builder.nodeName(json.nodeName);
        }
        if (json.clientAddrs != null) {
            builder.addAllClientAddrs(json.clientAddrs);
        }
        if (json.bindAddr != null) {
            builder.bindAddr(json.bindAddr);
        }
        if (json.leaveOnTermIsSet) {
            builder.leaveOnTerm(json.leaveOnTerm);
        }
        if (json.skipLeaveOnIntIsSet) {
            builder.skipLeaveOnInt(json.skipLeaveOnInt);
        }
        if (json.enableDebugIsSet) {
            builder.enableDebug(json.enableDebug);
        }
        if (json.verifyIncomingIsSet) {
            builder.verifyIncoming(json.verifyIncoming);
        }
        if (json.verifyOutgoingIsSet) {
            builder.verifyOutgoing(json.verifyOutgoing);
        }
        if (json.caFile != null) {
            builder.caFile(json.caFile);
        }
        if (json.certFile != null) {
            builder.certFile(json.certFile);
        }
        if (json.keyFile != null) {
            builder.keyFile(json.keyFile);
        }
        if (json.uiDir != null) {
            builder.uiDir(json.uiDir);
        }
        if (json.pidFile != null) {
            builder.pidFile(json.pidFile);
        }
        if (json.enableSyslogIsSet) {
            builder.enableSyslog(json.enableSyslog);
        }
        if (json.rejoinAfterLeaveIsSet) {
            builder.rejoinAfterLeave(json.rejoinAfterLeave);
        }
        if (json.advertiseAddrLAN != null) {
            builder.advertiseAddrLAN(json.advertiseAddrLAN);
        }
        if (json.advertiseAddrWAN != null) {
            builder.advertiseAddrWAN(json.advertiseAddrWAN);
        }
        return builder.build();
    }

    public static ImmutableDebugConfig copyOf(DebugConfig instance) {
        if (instance instanceof ImmutableDebugConfig) {
            return (ImmutableDebugConfig)instance;
        }
        return ImmutableDebugConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DebugConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BOOTSTRAP = 1L;
        private static final long INIT_BIT_DATACENTER = 2L;
        private static final long INIT_BIT_DATA_DIR = 4L;
        private static final long INIT_BIT_DNS_DOMAIN = 8L;
        private static final long INIT_BIT_LOG_LEVEL = 16L;
        private static final long INIT_BIT_NODE_NAME = 32L;
        private static final long INIT_BIT_BIND_ADDR = 64L;
        private static final long INIT_BIT_LEAVE_ON_TERM = 128L;
        private static final long INIT_BIT_SKIP_LEAVE_ON_INT = 256L;
        private static final long INIT_BIT_ENABLE_DEBUG = 512L;
        private static final long INIT_BIT_VERIFY_INCOMING = 1024L;
        private static final long INIT_BIT_VERIFY_OUTGOING = 2048L;
        private static final long INIT_BIT_CA_FILE = 4096L;
        private static final long INIT_BIT_CERT_FILE = 8192L;
        private static final long INIT_BIT_KEY_FILE = 16384L;
        private static final long INIT_BIT_PID_FILE = 32768L;
        private static final long INIT_BIT_ENABLE_SYSLOG = 65536L;
        private static final long INIT_BIT_REJOIN_AFTER_LEAVE = 131072L;
        private static final long INIT_BIT_ADVERTISE_ADDR_L_A_N = 262144L;
        private static final long INIT_BIT_ADVERTISE_ADDR_W_A_N = 524288L;
        private long initBits = 1048575L;
        private boolean bootstrap;
        @Nullable
        private String datacenter;
        @Nullable
        private String dataDir;
        private ImmutableList.Builder<String> dnsRecursors = ImmutableList.builder();
        @Nullable
        private String dnsDomain;
        @Nullable
        private String logLevel;
        @Nullable
        private String nodeName;
        private ImmutableList.Builder<String> clientAddrs = ImmutableList.builder();
        @Nullable
        private String bindAddr;
        private boolean leaveOnTerm;
        private boolean skipLeaveOnInt;
        private boolean enableDebug;
        private boolean verifyIncoming;
        private boolean verifyOutgoing;
        @Nullable
        private String caFile;
        @Nullable
        private String certFile;
        @Nullable
        private String keyFile;
        @Nullable
        private String uiDir;
        @Nullable
        private String pidFile;
        private boolean enableSyslog;
        private boolean rejoinAfterLeave;
        @Nullable
        private String advertiseAddrLAN;
        @Nullable
        private String advertiseAddrWAN;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DebugConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.bootstrap(instance.getBootstrap());
            this.datacenter(instance.getDatacenter());
            this.dataDir(instance.getDataDir());
            this.addAllDnsRecursors(instance.dnsRecursors());
            this.dnsDomain(instance.getDnsDomain());
            this.logLevel(instance.getLogLevel());
            this.nodeName(instance.getNodeName());
            this.addAllClientAddrs(instance.getClientAddrs());
            this.bindAddr(instance.getBindAddr());
            this.leaveOnTerm(instance.getLeaveOnTerm());
            this.skipLeaveOnInt(instance.getSkipLeaveOnInt());
            this.enableDebug(instance.getEnableDebug());
            this.verifyIncoming(instance.getVerifyIncoming());
            this.verifyOutgoing(instance.getVerifyOutgoing());
            this.caFile(instance.getCaFile());
            this.certFile(instance.getCertFile());
            this.keyFile(instance.getKeyFile());
            Optional<String> uiDirOptional = instance.getUiDir();
            if (uiDirOptional.isPresent()) {
                this.uiDir(uiDirOptional);
            }
            this.pidFile(instance.getPidFile());
            this.enableSyslog(instance.getEnableSyslog());
            this.rejoinAfterLeave(instance.getRejoinAfterLeave());
            this.advertiseAddrLAN(instance.getAdvertiseAddrLAN());
            this.advertiseAddrWAN(instance.getAdvertiseAddrWAN());
            return this;
        }

        @JsonProperty(value="Bootstrap")
        @CanIgnoreReturnValue
        public final Builder bootstrap(boolean bootstrap) {
            this.bootstrap = bootstrap;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Datacenter")
        @CanIgnoreReturnValue
        public final Builder datacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="DataDir")
        @CanIgnoreReturnValue
        public final Builder dataDir(String dataDir) {
            this.dataDir = Objects.requireNonNull(dataDir, "dataDir");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDnsRecursors(String element) {
            this.dnsRecursors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDnsRecursors(String ... elements) {
            this.dnsRecursors.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="DNSRecursors")
        @CanIgnoreReturnValue
        public final Builder dnsRecursors(Iterable<String> elements) {
            this.dnsRecursors = ImmutableList.builder();
            return this.addAllDnsRecursors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDnsRecursors(Iterable<String> elements) {
            this.dnsRecursors.addAll(elements);
            return this;
        }

        @JsonProperty(value="DNSDomain")
        @CanIgnoreReturnValue
        public final Builder dnsDomain(String dnsDomain) {
            this.dnsDomain = Objects.requireNonNull(dnsDomain, "dnsDomain");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="LogLevel")
        @CanIgnoreReturnValue
        public final Builder logLevel(String logLevel) {
            this.logLevel = Objects.requireNonNull(logLevel, "logLevel");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="NodeName")
        @CanIgnoreReturnValue
        public final Builder nodeName(String nodeName) {
            this.nodeName = Objects.requireNonNull(nodeName, "nodeName");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addClientAddrs(String element) {
            this.clientAddrs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addClientAddrs(String ... elements) {
            this.clientAddrs.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="ClientAddrs")
        @CanIgnoreReturnValue
        public final Builder clientAddrs(Iterable<String> elements) {
            this.clientAddrs = ImmutableList.builder();
            return this.addAllClientAddrs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllClientAddrs(Iterable<String> elements) {
            this.clientAddrs.addAll(elements);
            return this;
        }

        @JsonProperty(value="BindAddr")
        @CanIgnoreReturnValue
        public final Builder bindAddr(String bindAddr) {
            this.bindAddr = Objects.requireNonNull(bindAddr, "bindAddr");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="LeaveOnTerm")
        @CanIgnoreReturnValue
        public final Builder leaveOnTerm(boolean leaveOnTerm) {
            this.leaveOnTerm = leaveOnTerm;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="SkipLeaveOnInt")
        @CanIgnoreReturnValue
        public final Builder skipLeaveOnInt(boolean skipLeaveOnInt) {
            this.skipLeaveOnInt = skipLeaveOnInt;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="EnableDebug")
        @CanIgnoreReturnValue
        public final Builder enableDebug(boolean enableDebug) {
            this.enableDebug = enableDebug;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @JsonProperty(value="VerifyIncoming")
        @CanIgnoreReturnValue
        public final Builder verifyIncoming(boolean verifyIncoming) {
            this.verifyIncoming = verifyIncoming;
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @JsonProperty(value="VerifyOutgoing")
        @CanIgnoreReturnValue
        public final Builder verifyOutgoing(boolean verifyOutgoing) {
            this.verifyOutgoing = verifyOutgoing;
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        @JsonProperty(value="CAFile")
        @CanIgnoreReturnValue
        public final Builder caFile(String caFile) {
            this.caFile = Objects.requireNonNull(caFile, "caFile");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        @JsonProperty(value="CertFile")
        @CanIgnoreReturnValue
        public final Builder certFile(String certFile) {
            this.certFile = Objects.requireNonNull(certFile, "certFile");
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        @JsonProperty(value="KeyFile")
        @CanIgnoreReturnValue
        public final Builder keyFile(String keyFile) {
            this.keyFile = Objects.requireNonNull(keyFile, "keyFile");
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uiDir(String uiDir) {
            this.uiDir = Objects.requireNonNull(uiDir, "uiDir");
            return this;
        }

        @JsonProperty(value="UiDir")
        @CanIgnoreReturnValue
        public final Builder uiDir(Optional<String> uiDir) {
            this.uiDir = uiDir.orElse(null);
            return this;
        }

        @JsonProperty(value="PidFile")
        @CanIgnoreReturnValue
        public final Builder pidFile(String pidFile) {
            this.pidFile = Objects.requireNonNull(pidFile, "pidFile");
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        @JsonProperty(value="EnableSyslog")
        @CanIgnoreReturnValue
        public final Builder enableSyslog(boolean enableSyslog) {
            this.enableSyslog = enableSyslog;
            this.initBits &= 0xFFFFFFFFFFFEFFFFL;
            return this;
        }

        @JsonProperty(value="RejoinAfterLeave")
        @CanIgnoreReturnValue
        public final Builder rejoinAfterLeave(boolean rejoinAfterLeave) {
            this.rejoinAfterLeave = rejoinAfterLeave;
            this.initBits &= 0xFFFFFFFFFFFDFFFFL;
            return this;
        }

        @JsonProperty(value="AdvertiseAddrLAN")
        @CanIgnoreReturnValue
        public final Builder advertiseAddrLAN(String advertiseAddrLAN) {
            this.advertiseAddrLAN = Objects.requireNonNull(advertiseAddrLAN, "advertiseAddrLAN");
            this.initBits &= 0xFFFFFFFFFFFBFFFFL;
            return this;
        }

        @JsonProperty(value="AdvertiseAddrWAN")
        @CanIgnoreReturnValue
        public final Builder advertiseAddrWAN(String advertiseAddrWAN) {
            this.advertiseAddrWAN = Objects.requireNonNull(advertiseAddrWAN, "advertiseAddrWAN");
            this.initBits &= 0xFFFFFFFFFFF7FFFFL;
            return this;
        }

        public ImmutableDebugConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDebugConfig(this.bootstrap, this.datacenter, this.dataDir, this.dnsRecursors.build(), this.dnsDomain, this.logLevel, this.nodeName, this.clientAddrs.build(), this.bindAddr, this.leaveOnTerm, this.skipLeaveOnInt, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave, this.advertiseAddrLAN, this.advertiseAddrWAN);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bootstrap");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("datacenter");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("dataDir");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("dnsDomain");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("logLevel");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("nodeName");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("bindAddr");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("leaveOnTerm");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("skipLeaveOnInt");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("enableDebug");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("verifyIncoming");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("verifyOutgoing");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("caFile");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("certFile");
            }
            if ((this.initBits & 0x4000L) != 0L) {
                attributes.add("keyFile");
            }
            if ((this.initBits & 0x8000L) != 0L) {
                attributes.add("pidFile");
            }
            if ((this.initBits & 0x10000L) != 0L) {
                attributes.add("enableSyslog");
            }
            if ((this.initBits & 0x20000L) != 0L) {
                attributes.add("rejoinAfterLeave");
            }
            if ((this.initBits & 0x40000L) != 0L) {
                attributes.add("advertiseAddrLAN");
            }
            if ((this.initBits & 0x80000L) != 0L) {
                attributes.add("advertiseAddrWAN");
            }
            return "Cannot build DebugConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DebugConfig", generator="Immutables")
    static final class Json
    extends DebugConfig {
        boolean bootstrap;
        boolean bootstrapIsSet;
        @Nullable
        String datacenter;
        @Nullable
        String dataDir;
        @Nullable
        List<String> dnsRecursors = ImmutableList.of();
        @Nullable
        String dnsDomain;
        @Nullable
        String logLevel;
        @Nullable
        String nodeName;
        @Nullable
        List<String> clientAddrs = ImmutableList.of();
        @Nullable
        String bindAddr;
        boolean leaveOnTerm;
        boolean leaveOnTermIsSet;
        boolean skipLeaveOnInt;
        boolean skipLeaveOnIntIsSet;
        boolean enableDebug;
        boolean enableDebugIsSet;
        boolean verifyIncoming;
        boolean verifyIncomingIsSet;
        boolean verifyOutgoing;
        boolean verifyOutgoingIsSet;
        @Nullable
        String caFile;
        @Nullable
        String certFile;
        @Nullable
        String keyFile;
        @Nullable
        Optional<String> uiDir = Optional.empty();
        @Nullable
        String pidFile;
        boolean enableSyslog;
        boolean enableSyslogIsSet;
        boolean rejoinAfterLeave;
        boolean rejoinAfterLeaveIsSet;
        @Nullable
        String advertiseAddrLAN;
        @Nullable
        String advertiseAddrWAN;

        Json() {
        }

        @JsonProperty(value="Bootstrap")
        public void setBootstrap(boolean bootstrap) {
            this.bootstrap = bootstrap;
            this.bootstrapIsSet = true;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(String datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="DataDir")
        public void setDataDir(String dataDir) {
            this.dataDir = dataDir;
        }

        @JsonProperty(value="DNSRecursors")
        public void setDnsRecursors(List<String> dnsRecursors) {
            this.dnsRecursors = dnsRecursors;
        }

        @JsonProperty(value="DNSDomain")
        public void setDnsDomain(String dnsDomain) {
            this.dnsDomain = dnsDomain;
        }

        @JsonProperty(value="LogLevel")
        public void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @JsonProperty(value="NodeName")
        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @JsonProperty(value="ClientAddrs")
        public void setClientAddrs(List<String> clientAddrs) {
            this.clientAddrs = clientAddrs;
        }

        @JsonProperty(value="BindAddr")
        public void setBindAddr(String bindAddr) {
            this.bindAddr = bindAddr;
        }

        @JsonProperty(value="LeaveOnTerm")
        public void setLeaveOnTerm(boolean leaveOnTerm) {
            this.leaveOnTerm = leaveOnTerm;
            this.leaveOnTermIsSet = true;
        }

        @JsonProperty(value="SkipLeaveOnInt")
        public void setSkipLeaveOnInt(boolean skipLeaveOnInt) {
            this.skipLeaveOnInt = skipLeaveOnInt;
            this.skipLeaveOnIntIsSet = true;
        }

        @JsonProperty(value="EnableDebug")
        public void setEnableDebug(boolean enableDebug) {
            this.enableDebug = enableDebug;
            this.enableDebugIsSet = true;
        }

        @JsonProperty(value="VerifyIncoming")
        public void setVerifyIncoming(boolean verifyIncoming) {
            this.verifyIncoming = verifyIncoming;
            this.verifyIncomingIsSet = true;
        }

        @JsonProperty(value="VerifyOutgoing")
        public void setVerifyOutgoing(boolean verifyOutgoing) {
            this.verifyOutgoing = verifyOutgoing;
            this.verifyOutgoingIsSet = true;
        }

        @JsonProperty(value="CAFile")
        public void setCaFile(String caFile) {
            this.caFile = caFile;
        }

        @JsonProperty(value="CertFile")
        public void setCertFile(String certFile) {
            this.certFile = certFile;
        }

        @JsonProperty(value="KeyFile")
        public void setKeyFile(String keyFile) {
            this.keyFile = keyFile;
        }

        @JsonProperty(value="UiDir")
        public void setUiDir(Optional<String> uiDir) {
            this.uiDir = uiDir;
        }

        @JsonProperty(value="PidFile")
        public void setPidFile(String pidFile) {
            this.pidFile = pidFile;
        }

        @JsonProperty(value="EnableSyslog")
        public void setEnableSyslog(boolean enableSyslog) {
            this.enableSyslog = enableSyslog;
            this.enableSyslogIsSet = true;
        }

        @JsonProperty(value="RejoinAfterLeave")
        public void setRejoinAfterLeave(boolean rejoinAfterLeave) {
            this.rejoinAfterLeave = rejoinAfterLeave;
            this.rejoinAfterLeaveIsSet = true;
        }

        @JsonProperty(value="AdvertiseAddrLAN")
        public void setAdvertiseAddrLAN(String advertiseAddrLAN) {
            this.advertiseAddrLAN = advertiseAddrLAN;
        }

        @JsonProperty(value="AdvertiseAddrWAN")
        public void setAdvertiseAddrWAN(String advertiseAddrWAN) {
            this.advertiseAddrWAN = advertiseAddrWAN;
        }

        @Override
        public boolean getBootstrap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDatacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDataDir() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> dnsRecursors() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDnsDomain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLogLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNodeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getClientAddrs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBindAddr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getLeaveOnTerm() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getSkipLeaveOnInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getEnableDebug() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getVerifyIncoming() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getVerifyOutgoing() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCaFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCertFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getKeyFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUiDir() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPidFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getEnableSyslog() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getRejoinAfterLeave() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAdvertiseAddrLAN() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAdvertiseAddrWAN() {
            throw new UnsupportedOperationException();
        }
    }
}

