/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.primitives.Ints;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.cache.CacheDescriptor;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.config.CacheConfig;
import com.orbitz.consul.model.State;
import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public class HealthCheckCache
extends ConsulCache<String, HealthCheck> {
    private HealthCheckCache(HealthClient healthClient, State state, int watchSeconds, QueryOptions queryOptions, Function<HealthCheck, String> keyExtractor, ConsulCache.Scheduler callbackScheduler) {
        super(keyExtractor, (BigInteger index, ConsulResponseCallback<List<V>> callback) -> {
            QueryOptions params = HealthCheckCache.watchParams(index, watchSeconds, queryOptions);
            healthClient.getChecksByState(state, params, callback);
        }, healthClient.getConfig().getCacheConfig(), healthClient.getEventHandler(), new CacheDescriptor("health.state", state.getName()), callbackScheduler);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State state, int watchSeconds, QueryOptions queryOptions, Function<HealthCheck, String> keyExtractor, ScheduledExecutorService callbackExecutorService) {
        ConsulCache.Scheduler callbackScheduler = HealthCheckCache.createExternal(callbackExecutorService);
        return new HealthCheckCache(healthClient, state, watchSeconds, queryOptions, keyExtractor, callbackScheduler);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State state, int watchSeconds, QueryOptions queryOptions, Function<HealthCheck, String> keyExtractor) {
        return new HealthCheckCache(healthClient, state, watchSeconds, queryOptions, keyExtractor, HealthCheckCache.createDefault());
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State state, int watchSeconds, QueryOptions queryOptions) {
        return HealthCheckCache.newCache(healthClient, state, watchSeconds, queryOptions, HealthCheck::getCheckId);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State state, int watchSeconds) {
        return HealthCheckCache.newCache(healthClient, state, watchSeconds, QueryOptions.BLANK);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State state) {
        CacheConfig cacheConfig = healthClient.getConfig().getCacheConfig();
        int watchSeconds = Ints.checkedCast((long)cacheConfig.getWatchDuration().getSeconds());
        return HealthCheckCache.newCache(healthClient, state, watchSeconds);
    }
}

