/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.search.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.AvgAggregationBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.MaxAggregationBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.MinAggregationBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.SumAggregationBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.TermsAggregationBuilder;

public abstract class Aggregation {
    public abstract String name();

    public static TermsAggregationBuilder terms(String name) {
        return new TermsAggregationBuilder(name);
    }

    public static AvgAggregationBuilder avg(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be blank");
        return new AvgAggregationBuilder(name);
    }

    public static MinAggregationBuilder min(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be blank");
        return new MinAggregationBuilder(name);
    }

    public static MaxAggregationBuilder max(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be blank");
        return new MaxAggregationBuilder(name);
    }

    public static SumAggregationBuilder sum(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be blank");
        return new SumAggregationBuilder(name);
    }
}

