/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.system;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sis.system.Threads;

public final class CommonExecutor
extends AtomicInteger
implements ThreadFactory {
    public static final int PARALLELISM = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
    private static final ThreadPoolExecutor INSTANCE;

    public static ExecutorService instance() {
        return INSTANCE;
    }

    public static boolean unschedule(Future<?> task) {
        if (task instanceof Runnable) {
            return INSTANCE.remove((Runnable)((Object)task));
        }
        return false;
    }

    private CommonExecutor() {
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(Threads.SIS, r, "Background worker #" + this.incrementAndGet());
        t.setPriority(3);
        t.setDaemon(true);
        return t;
    }

    static {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(PARALLELISM, PARALLELISM, 2L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(1000000), new CommonExecutor());
        executor.allowCoreThreadTimeOut(true);
        INSTANCE = executor;
    }
}

