/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.provider.Molodensky;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ComparisonMode;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.Matrix;

public abstract class DatumShiftTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -4492222496475405226L;
    final ContextualParameters context;
    final DatumShiftGrid<?, ?> grid;
    private transient double scaleX;
    private transient double scaleY;
    private transient double x0;
    private transient double y0;

    DatumShiftTransform(ParameterDescriptorGroup descriptor, DatumShiftGrid<?, ?> grid) {
        int dim = grid.getTranslationDimensions();
        this.context = new ContextualParameters(descriptor, dim, dim);
        this.grid = grid;
        this.computeConversionFactors();
    }

    DatumShiftTransform(ParameterDescriptorGroup descriptor, boolean isSource3D, boolean isTarget3D, DatumShiftGrid<?, ?> grid) {
        this.context = new ContextualParameters(descriptor, isSource3D ? 3 : 2, isTarget3D ? 3 : 2);
        this.grid = grid;
        this.computeConversionFactors();
    }

    DatumShiftTransform(DatumShiftTransform other, int srcDim, int tgtDim) {
        this.context = other.context.redimension(srcDim, tgtDim);
        this.grid = other.grid;
        this.scaleX = other.scaleX;
        this.scaleY = other.scaleY;
        this.x0 = other.x0;
        this.y0 = other.y0;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.computeConversionFactors();
    }

    private void computeConversionFactors() {
        this.scaleX = Double.NaN;
        this.scaleY = Double.NaN;
        this.x0 = Double.NaN;
        this.y0 = Double.NaN;
        if (this.grid != null) {
            Matrix m;
            LinearTransform coordinateToGrid = this.grid.getCoordinateToGrid();
            double toStandardUnit = Units.toStandardUnit(this.grid.getCoordinateUnit());
            if (!Double.isNaN(toStandardUnit) && Matrices.isAffine(m = coordinateToGrid.getMatrix())) {
                int n = m.getNumCol() - 1;
                switch (m.getNumRow()) {
                    default: {
                        this.y0 = m.getElement(1, n);
                        this.scaleY = DatumShiftTransform.diagonal(m, 1, n) / toStandardUnit;
                    }
                    case 1: {
                        this.x0 = m.getElement(0, n);
                        this.scaleX = DatumShiftTransform.diagonal(m, 0, n) / toStandardUnit;
                    }
                    case 0: 
                }
            }
        }
    }

    private static double diagonal(Matrix m, int j, int n) {
        while (--n >= 0) {
            if (j == n || m.getElement(j, n) == 0.0) continue;
            return Double.NaN;
        }
        return m.getElement(j, j);
    }

    final void setContextParameters(double semiMajor, double semiMinor, Unit<Length> unit, Ellipsoid target) {
        UnitConverter c = target.getAxisUnit().getConverterTo(unit);
        this.context.getOrCreate(Molodensky.SRC_SEMI_MAJOR).setValue(semiMajor, unit);
        this.context.getOrCreate(Molodensky.SRC_SEMI_MINOR).setValue(semiMinor, unit);
        this.context.getOrCreate(Molodensky.TGT_SEMI_MAJOR).setValue(c.convert(target.getSemiMajorAxis()), unit);
        this.context.getOrCreate(Molodensky.TGT_SEMI_MINOR).setValue(c.convert(target.getSemiMinorAxis()), unit);
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.context;
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.context;
    }

    final double normalizedToGridX(double x) {
        return x * this.scaleX + this.x0;
    }

    final double normalizedToGridY(double y) {
        return y * this.scaleY + this.y0;
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Objects.hashCode(this.grid);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        return super.equals(object, mode) && Objects.equals(this.grid, ((DatumShiftTransform)object).grid);
    }
}

