/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.MatrixParameters;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.internal.ParameterizedTransformBuilder;
import org.apache.sis.referencing.internal.shared.CoordinateOperations;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.operation.LooselyDefinedMethod;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.Affine;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.MathTransformBuilder;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

final class MathTransformContext
extends ParameterizedTransformBuilder {
    private double sourceMeridian;
    private double targetMeridian;

    MathTransformContext(MathTransformFactory factory, GeodeticDatum source, GeodeticDatum target) {
        super(factory, null);
        double rs = ReferencingUtilities.getGreenwichLongitude(source.getPrimeMeridian(), (Unit<Angle>)Units.DEGREE);
        double rt = ReferencingUtilities.getGreenwichLongitude(target.getPrimeMeridian(), (Unit<Angle>)Units.DEGREE);
        if (rs != rt) {
            this.sourceMeridian = rs;
            this.targetMeridian = rt;
        }
    }

    private MathTransform createCoordinateSystemChange(CoordinateSystem source, CoordinateSystem target, Ellipsoid ellipsoid) throws FactoryException {
        MathTransformBuilder builder = CoordinateOperations.builder(this.factory, "Coordinate system conversion");
        builder.setSourceAxes(source, ellipsoid);
        builder.setTargetAxes(target, ellipsoid);
        return builder.create();
    }

    final MathTransform createAffineGeocentric(Matrix datumShift) throws FactoryException {
        if (datumShift != null) {
            Map<String, String> properties = Map.of("name", "Affine");
            this.parameters = MatrixParameters.WKT1.createValueGroup(properties, datumShift);
        } else {
            this.parameters = Affine.identity(3);
        }
        this.provider = Affine.provider();
        CoordinateSystem normalized = CommonCRS.WGS84.geocentric().getCoordinateSystem();
        MathTransform before = this.createCoordinateSystemChange(this.sourceCS, normalized, this.sourceEllipsoid);
        MathTransform after = this.createCoordinateSystemChange(normalized, this.targetCS, this.targetEllipsoid);
        this.setSourceAxes(normalized, null);
        this.setTargetAxes(normalized, null);
        MathTransform tr = this.factory.createConcatenatedTransform(before, this.factory.createConcatenatedTransform(this.create(), after));
        if (!before.isIdentity() || !after.isIdentity()) {
            this.provider = LooselyDefinedMethod.AFFINE_GEOCENTRIC;
            this.parameters = null;
        }
        return tr;
    }

    final ParameterValueGroup parametersForMetadata() {
        return this.parameters;
    }

    @Override
    public Matrix getMatrix(ContextualParameters.MatrixRole role) throws FactoryException {
        Class<? extends CoordinateSystem> userCS;
        double rotation;
        boolean inverse = false;
        switch (role) {
            default: {
                throw new IllegalArgumentException(Errors.format((short)59, (Object)"role", (Object)((Object)role)));
            }
            case INVERSE_NORMALIZATION: {
                inverse = true;
            }
            case NORMALIZATION: {
                rotation = this.sourceMeridian;
                userCS = this.getSourceCSType();
                break;
            }
            case INVERSE_DENORMALIZATION: {
                inverse = true;
            }
            case DENORMALIZATION: {
                inverse = !inverse;
                rotation = this.targetMeridian;
                userCS = this.getTargetCSType();
            }
        }
        Matrix matrix = super.getMatrix(role);
        if (rotation != 0.0) {
            if (inverse) {
                rotation = -rotation;
            }
            MatrixSIS cm = MatrixSIS.castOrCopy(matrix);
            if (CartesianCS.class.isAssignableFrom(userCS)) {
                rotation = Math.toRadians(rotation);
                Matrix4 rot = new Matrix4();
                rot.m00 = rot.m11 = Math.cos(rotation);
                rot.m10 = Math.sin(rotation);
                rot.m01 = -rot.m10;
                matrix = inverse ? Matrices.multiply(rot, cm) : cm.multiply(rot);
            } else if (userCS == CoordinateSystem.class || EllipsoidalCS.class.isAssignableFrom(userCS) || SphericalCS.class.isAssignableFrom(userCS)) {
                Double value = rotation;
                if (inverse) {
                    cm.convertBefore(0, null, value);
                } else {
                    cm.convertAfter(0, null, value);
                }
                matrix = cm;
            } else {
                throw new FactoryException(Errors.format((short)193, (Object)userCS.getName()));
            }
        }
        return matrix;
    }
}

