/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Apache SIS services made available to Apache <a href="http://www.openoffice.org">OpenOffice</a> or LibreOffice.
 * Functions to make available in OpenOffice are defined in {@code X*.idl} files,
 * which are converted to {@code X*.java} files for convenience.
 *
 * <p>Note that the {@code X*.class} files to be included in the final JAR file
 * shall be compiled from the {@code X*.idl} files, not from the {@code X*.java} files.
 * See {@code endorsed/src/org.apache.sis.openoffice/bundle/build-instruction.html} for more information.</p>
 *
 * @author  Martin Desruisseaux (IRD, Geomatys)
 * @version 0.8
 * @since   0.8
 */
package org.apache.sis.openoffice;
