/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.sis.portrayal.Canvas;
import org.apache.sis.portrayal.Observable;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public class TransformChangeEvent
extends PropertyChangeEvent {
    private static final long serialVersionUID = 4444752056666264066L;
    private final Reason reason;
    private transient LinearTransform displayChange;
    private transient LinearTransform objectiveChange;
    private AffineTransform displayChange2D;
    private AffineTransform objectiveChange2D;
    private transient Exception error;

    public TransformChangeEvent(Canvas source, LinearTransform oldValue, LinearTransform newValue, Reason reason) {
        super(source, "objectiveToDisplay", oldValue, newValue);
        ArgumentChecks.ensureNonNull((String)"reason", (Object)((Object)reason));
        this.reason = reason;
    }

    public TransformChangeEvent(Canvas source, LinearTransform oldValue, LinearTransform newValue, AffineTransform objective, AffineTransform display, Reason reason) {
        this(source, oldValue, newValue, reason);
        this.objectiveChange2D = objective;
        this.displayChange2D = display;
    }

    final boolean isSameSource(Canvas source) {
        return super.getSource() == source;
    }

    @Override
    public Canvas getSource() {
        return (Canvas)this.source;
    }

    public Reason getReason() {
        return this.reason;
    }

    public LinearTransform getOldValue() {
        return (LinearTransform)super.getOldValue();
    }

    public LinearTransform getNewValue() {
        LinearTransform value = (LinearTransform)super.getNewValue();
        if (value == null) {
            value = this.getSource().getObjectiveToDisplay();
        }
        return value;
    }

    public LinearTransform getObjectiveChange() {
        if (this.objectiveChange == null) {
            if (this.objectiveChange2D != null) {
                this.objectiveChange = AffineTransforms2D.toMathTransform((AffineTransform)this.objectiveChange2D);
            } else {
                LinearTransform newValue;
                LinearTransform oldValue = this.getOldValue();
                if (oldValue != null && (newValue = this.getNewValue()) != null) {
                    try {
                        this.objectiveChange = (LinearTransform)MathTransforms.concatenate((MathTransform)newValue, (MathTransform)oldValue.inverse());
                    }
                    catch (NoninvertibleTransformException e) {
                        this.canNotCompute("getObjectiveChange", (Exception)((Object)e));
                    }
                }
            }
        }
        return this.objectiveChange;
    }

    public LinearTransform getDisplayChange() {
        if (this.displayChange == null) {
            if (this.displayChange2D != null) {
                this.displayChange = AffineTransforms2D.toMathTransform((AffineTransform)this.displayChange2D);
            } else {
                LinearTransform newValue;
                LinearTransform oldValue = this.getOldValue();
                if (oldValue != null && (newValue = this.getNewValue()) != null) {
                    try {
                        this.displayChange = (LinearTransform)MathTransforms.concatenate((MathTransform)oldValue.inverse(), (MathTransform)newValue);
                    }
                    catch (NoninvertibleTransformException e) {
                        this.canNotCompute("getDisplayChange", (Exception)((Object)e));
                    }
                }
            }
        }
        return this.displayChange;
    }

    public Optional<AffineTransform> getObjectiveChange2D() {
        if (this.objectiveChange2D == null) {
            try {
                Object oldValue = super.getOldValue();
                Object newValue = super.getNewValue();
                if (oldValue instanceof AffineTransform && newValue instanceof AffineTransform) {
                    this.objectiveChange2D = ((AffineTransform)oldValue).createInverse();
                    this.objectiveChange2D.concatenate((AffineTransform)newValue);
                } else {
                    this.objectiveChange2D = AffineTransforms2D.castOrCopy((MathTransform)this.getObjectiveChange());
                }
            }
            catch (java.awt.geom.NoninvertibleTransformException | IllegalArgumentException e) {
                this.canNotCompute("getObjectiveChange2D", e);
            }
        }
        return Optional.ofNullable(this.objectiveChange2D);
    }

    public Optional<AffineTransform> getDisplayChange2D() {
        if (this.displayChange2D == null) {
            try {
                Object oldValue = super.getOldValue();
                Object newValue = super.getNewValue();
                if (oldValue instanceof AffineTransform && newValue instanceof AffineTransform) {
                    this.displayChange2D = ((AffineTransform)oldValue).createInverse();
                    this.displayChange2D.preConcatenate((AffineTransform)newValue);
                } else {
                    this.displayChange2D = AffineTransforms2D.castOrCopy((MathTransform)this.getDisplayChange());
                }
            }
            catch (java.awt.geom.NoninvertibleTransformException | IllegalArgumentException e) {
                this.canNotCompute("getDisplayChange2D", e);
            }
        }
        return Optional.ofNullable(this.displayChange2D);
    }

    private void canNotCompute(String method, Exception e) {
        if (this.error == null) {
            this.error = e;
            Logging.recoverableException((Logger)Observable.LOGGER, TransformChangeEvent.class, (String)method, (Throwable)e);
        } else {
            this.error.addSuppressed(e);
        }
    }

    public static enum Reason {
        GRID_GEOMETRY_CHANGE,
        CRS_CHANGE,
        ASSIGNMENT,
        OBJECTIVE_NAVIGATION,
        DISPLAY_NAVIGATION,
        INTERIM;


        final boolean isNavigation() {
            return this.ordinal() >= ASSIGNMENT.ordinal() && this.ordinal() < INTERIM.ordinal();
        }
    }
}

