/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

abstract class Observable {
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.portrayal");
    private Map<String, PropertyChangeListener[]> listeners;

    Observable() {
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        ArgumentChecks.ensureNonEmpty((String)"propertyName", (CharSequence)propertyName);
        ArgumentChecks.ensureNonNull((String)"listener", (Object)listener);
        if (this.listeners == null) {
            this.listeners = new HashMap<String, PropertyChangeListener[]>(4);
        }
        this.listeners.compute(propertyName, (key, oldList) -> {
            PropertyChangeListener[] propertyChangeListenerArray;
            if (oldList != null) {
                propertyChangeListenerArray = (PropertyChangeListener[])ArraysExt.append((Object[])oldList, (Object)listener);
            } else {
                PropertyChangeListener[] propertyChangeListenerArray2 = new PropertyChangeListener[1];
                propertyChangeListenerArray = propertyChangeListenerArray2;
                propertyChangeListenerArray2[0] = listener;
            }
            return propertyChangeListenerArray;
        });
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        ArgumentChecks.ensureNonEmpty((String)"propertyName", (CharSequence)propertyName);
        ArgumentChecks.ensureNonNull((String)"listener", (Object)listener);
        if (this.listeners != null) {
            this.listeners.computeIfPresent(propertyName, (key, oldList) -> {
                int i = ((PropertyChangeListener[])oldList).length;
                while (--i >= 0) {
                    if (oldList[i] != listener) continue;
                    if (((PropertyChangeListener[])oldList).length != 1) {
                        return (PropertyChangeListener[])ArraysExt.remove((Object[])oldList, (int)i, (int)1);
                    }
                    return null;
                }
                return oldList;
            });
        }
    }

    protected final boolean hasPropertyChangeListener(String propertyName) {
        return this.listeners != null && this.listeners.containsKey(propertyName);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeListener[] list;
        if (this.listeners != null && (list = this.listeners.get(propertyName)) != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            for (PropertyChangeListener listener : list) {
                listener.propertyChange(event);
            }
        }
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        PropertyChangeListener[] list;
        ArgumentChecks.ensureNonNull((String)"event", (Object)event);
        if (this.listeners != null && (list = this.listeners.get(event.getPropertyName())) != null) {
            for (PropertyChangeListener listener : list) {
                listener.propertyChange(event);
            }
        }
    }
}

