/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IncompleteGridGeometryException;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.portrayal.CanvasContext;
import org.apache.sis.portrayal.CanvasExtent;
import org.apache.sis.portrayal.Observable;
import org.apache.sis.portrayal.RenderException;
import org.apache.sis.portrayal.TransformChangeEvent;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.referencing.util.DirectPositionView;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.referencing.util.WraparoundApplicator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.DoubleDouble;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class Canvas
extends Observable
implements Localized {
    public static final String OBJECTIVE_CRS_PROPERTY = "objectiveCRS";
    public static final String OBJECTIVE_TO_DISPLAY_PROPERTY = "objectiveToDisplay";
    public static final String DISPLAY_BOUNDS_PROPERTY = "displayBounds";
    public static final String POINT_OF_INTEREST_PROPERTY = "pointOfInterest";
    private static final String GRID_GEOMETRY_PROPERTY = "gridGeometry";
    private static final String GEOGRAPHIC_AREA_PROPERTY = "geographicArea";
    private static final String SPATIAL_RESOLUTION_PROPERTY = "spatialResolution";
    private CoordinateReferenceSystem objectiveCRS;
    private LinearTransform objectiveToDisplay;
    final GeneralEnvelope displayBounds;
    private GeneralDirectPosition pointOfInterest;
    private DirectPosition objectivePOI;
    private MathTransform multidimToObjective;
    private CoordinateReferenceSystem augmentedObjectiveCRS;
    private long supplementalDimensions;
    private DimensionNameType[] axisTypes;
    private GridGeometry gridGeometry;
    private final CanvasContext operationContext;
    private final DefaultCoordinateOperationFactory coordinateOperationFactory;
    private final Locale locale;

    protected Canvas(EngineeringCRS displayCRS, Locale locale) {
        this.locale = locale;
        ArgumentChecks.ensureNonNull((String)"displayCRS", (Object)displayCRS);
        this.displayBounds = new GeneralEnvelope((CoordinateReferenceSystem)displayCRS);
        this.displayBounds.setToNaN();
        this.coordinateOperationFactory = DefaultCoordinateOperationFactory.provider();
        this.operationContext = new CanvasContext();
    }

    public Locale getLocale() {
        return this.locale;
    }

    int getDisplayDimensions() {
        return ReferencingUtilities.getDimension((CoordinateReferenceSystem)this.getDisplayCRS());
    }

    void getDisplayAxes(DimensionNameType[] axisTypes) {
    }

    public final EngineeringCRS getDisplayCRS() {
        return (EngineeringCRS)this.displayBounds.getCoordinateReferenceSystem();
    }

    public CoordinateReferenceSystem getObjectiveCRS() {
        return this.objectiveCRS;
    }

    public void setObjectiveCRS(CoordinateReferenceSystem newValue, DirectPosition anchor) throws RenderException {
        ArgumentChecks.ensureNonNull((String)OBJECTIVE_CRS_PROPERTY, (Object)newValue);
        ArgumentChecks.ensureDimensionMatches((String)OBJECTIVE_CRS_PROPERTY, (int)this.getDisplayDimensions(), (CoordinateReferenceSystem)newValue);
        CoordinateReferenceSystem oldValue = this.objectiveCRS;
        if (!newValue.equals(oldValue)) {
            try {
                CoordinateOperation newToGeo = this.objectiveToGeographic(newValue);
                LinearTransform oldObjectiveToDisplay = null;
                LinearTransform newObjectiveToDisplay = null;
                if (oldValue != null) {
                    MathTransform newToOld = this.findTransform(newValue, oldValue, false);
                    if (this.pointOfInterest != null && !newToOld.isIdentity()) {
                        CoordinateReferenceSystem poiCRS = this.pointOfInterest.getCoordinateReferenceSystem();
                        MathTransform poiToNew = this.findTransform(poiCRS, newValue, false);
                        DirectPosition poiInNew = poiToNew.transform((DirectPosition)this.pointOfInterest, this.allocatePosition());
                        if (anchor == null) {
                            anchor = poiInNew;
                        } else {
                            CoordinateReferenceSystem crs = anchor.getCoordinateReferenceSystem();
                            ArgumentChecks.ensureNonNull((String)"anchor.CRS", (Object)crs);
                            if (!Utilities.equalsIgnoreMetadata((Object)crs, (Object)newValue)) {
                                MathTransform anchorToNew = poiToNew;
                                if (!Utilities.equalsIgnoreMetadata((Object)crs, (Object)poiCRS)) {
                                    anchorToNew = this.findTransform(crs, newValue, true);
                                }
                                anchor = anchorToNew.transform(anchor, this.allocatePosition());
                            }
                        }
                        oldObjectiveToDisplay = this.getObjectiveToDisplay();
                        WraparoundApplicator wp = new WraparoundApplicator(null, this.objectivePOI, oldValue.getCoordinateSystem());
                        MathTransform change = Canvas.orthogonalTangent(wp.forDomainOfUse(newToOld), anchor.getCoordinate());
                        MathTransform result = MathTransforms.concatenate((MathTransform)change, (MathTransform)oldObjectiveToDisplay);
                        newObjectiveToDisplay = MathTransforms.tangent((MathTransform)result, (DirectPosition)poiInNew);
                        this.setObjectiveToDisplayImpl(newObjectiveToDisplay);
                        this.objectivePOI = poiInNew;
                        this.multidimToObjective = poiToNew;
                        this.augmentedObjectiveCRS = null;
                        this.axisTypes = null;
                        this.gridGeometry = null;
                    }
                }
                this.objectiveCRS = newValue;
                this.operationContext.setObjectiveToGeographic(newToGeo);
                this.firePropertyChange(OBJECTIVE_CRS_PROPERTY, oldValue, newValue);
                this.fireIfChanged(oldObjectiveToDisplay, newObjectiveToDisplay, false);
            }
            catch (TransformException | FactoryException e) {
                throw new RenderException(this.errors().getString((short)15, (Object)OBJECTIVE_CRS_PROPERTY), e);
            }
        }
    }

    private static MathTransform orthogonalTangent(MathTransform newToOld, double[] poiInNew) throws TransformException, RenderException {
        double[] poiInOld = new double[newToOld.getTargetDimensions()];
        MatrixSIS derivative = MatrixSIS.castOrCopy((Matrix)MathTransforms.derivativeAndTransform((MathTransform)newToOld, (double[])poiInNew, (int)0, (double[])poiInOld, (int)0));
        MatrixSIS magnitudes = derivative.normalizeColumns();
        MatrixSIS affine = Matrices.createAffine((Matrix)derivative, (DirectPosition)new DirectPositionView.Double(poiInOld));
        int srcDim = magnitudes.getNumCol();
        DoubleDouble scale = DoubleDouble.ZERO;
        for (int i = 0; i < srcDim; ++i) {
            scale = scale.add(magnitudes.getNumber(0, i), false);
        }
        scale = scale.divide(srcDim);
        if (srcDim == 2 && poiInOld.length == 2) {
            double ms = Math.max(0.0, Math.min(1.0, (Canvas.cps(affine, 0) + Canvas.cps(affine, 1) + 2.0) / 4.0));
            double sin = Math.sqrt(1.0 - ms);
            double cos = Math.sqrt(ms);
            for (int row = 0; row <= 1; ++row) {
                int sor = row ^ 1;
                affine.setElement(row, row, Math.copySign(cos, affine.getElement(row, row)));
                affine.setElement(row, sor, Math.copySign(sin, affine.getElement(row, sor)));
            }
        } else {
            throw new RenderException(Errors.format((short)178, (Object)"3D"));
        }
        for (int i = 0; i < srcDim; ++i) {
            affine.convertBefore(i, (Number)scale, null);
            affine.convertBefore(i, null, (Number)(-poiInNew[i]));
        }
        return MathTransforms.linear((Matrix)affine);
    }

    private static double cps(MatrixSIS affine, int row) {
        double cos = affine.getElement(row, row);
        double sin = affine.getElement(row, row ^ 1);
        return cos * cos - sin * sin;
    }

    public LinearTransform getObjectiveToDisplay() {
        if (this.objectiveToDisplay == null) {
            this.objectiveToDisplay = this.createObjectiveToDisplay();
        }
        return this.objectiveToDisplay;
    }

    LinearTransform createObjectiveToDisplay() {
        return MathTransforms.identity((int)this.getDisplayDimensions());
    }

    public void setObjectiveToDisplay(LinearTransform newValue) throws RenderException {
        ArgumentChecks.ensureNonNull((String)OBJECTIVE_TO_DISPLAY_PROPERTY, (Object)newValue);
        int expected = this.getDisplayDimensions();
        int actual = newValue.getSourceDimensions();
        if (actual == expected && (actual = newValue.getTargetDimensions()) == expected) {
            LinearTransform oldValue = this.objectiveToDisplay;
            if (oldValue == null) {
                oldValue = this.createObjectiveToDisplay();
            }
            if (!oldValue.equals(newValue)) {
                this.setObjectiveToDisplayImpl(newValue);
                this.firePropertyChange(new TransformChangeEvent(this, oldValue, newValue, TransformChangeEvent.Reason.ASSIGNMENT));
            }
            return;
        }
        throw new MismatchedDimensionException(this.errors().getString((short)81, (Object)OBJECTIVE_TO_DISPLAY_PROPERTY, (Object)expected, (Object)actual));
    }

    void setObjectiveToDisplayImpl(LinearTransform newValue) {
        this.objectiveToDisplay = newValue;
        this.gridGeometry = null;
        this.operationContext.clear();
    }

    public Envelope getDisplayBounds() {
        return this.displayBounds.isAllNaN() ? null : new GeneralEnvelope((Envelope)this.displayBounds);
    }

    public void setDisplayBounds(Envelope newValue) throws RenderException {
        ArgumentChecks.ensureNonNull((String)DISPLAY_BOUNDS_PROPERTY, (Object)newValue);
        CoordinateReferenceSystem crs = newValue.getCoordinateReferenceSystem();
        if (crs != null && !Utilities.equalsIgnoreMetadata((Object)this.getDisplayCRS(), (Object)crs)) {
            throw new MismatchedReferenceSystemException(this.errors().getString((short)51, (Object)IdentifiedObjects.getDisplayName((IdentifiedObject)crs, (Locale)this.getLocale())));
        }
        GeneralEnvelope oldValue = new GeneralEnvelope((Envelope)this.displayBounds);
        this.displayBounds.setEnvelope(newValue);
        this.displayBounds.setCoordinateReferenceSystem(oldValue.getCoordinateReferenceSystem());
        if (this.displayBounds.isEmpty()) {
            this.displayBounds.setEnvelope((Envelope)oldValue);
            throw new IllegalArgumentException(this.errors().getString((short)32, (Object)DISPLAY_BOUNDS_PROPERTY));
        }
        if (!oldValue.equals((Object)this.displayBounds)) {
            this.gridGeometry = null;
            this.operationContext.partialClear(false);
            this.firePropertyChange(DISPLAY_BOUNDS_PROPERTY, oldValue, newValue);
        }
    }

    public DirectPosition getPointOfInterest(boolean objective) {
        DirectPosition poi = objective ? this.objectivePOI : this.pointOfInterest;
        return poi != null ? new GeneralDirectPosition(poi) : null;
    }

    public void setPointOfInterest(DirectPosition newValue) throws RenderException {
        ArgumentChecks.ensureNonNull((String)POINT_OF_INTEREST_PROPERTY, (Object)newValue);
        GeneralDirectPosition copy = new GeneralDirectPosition(newValue);
        CoordinateReferenceSystem crs = copy.getCoordinateReferenceSystem();
        if (crs == null) {
            throw new IllegalArgumentException(this.errors().getString((short)157));
        }
        GeneralDirectPosition oldValue = this.pointOfInterest;
        if (!copy.equals((Object)oldValue)) {
            try {
                MathTransform mt;
                if (this.objectiveCRS == null) {
                    CoordinateReferenceSystem newObjectiveCRS = CRS.getComponentAt((CoordinateReferenceSystem)crs, (int)0, (int)this.getDisplayDimensions());
                    if (newObjectiveCRS == null) {
                        throw new IllegalArgumentException("Cannot infer objective CRS.");
                    }
                    this.operationContext.setObjectiveToGeographic(this.objectiveToGeographic(newObjectiveCRS));
                    this.objectiveCRS = newObjectiveCRS;
                }
                if ((mt = this.multidimToObjective) == null || !Utilities.equalsIgnoreMetadata((Object)crs, (Object)oldValue.getCoordinateReferenceSystem())) {
                    mt = this.findTransform(crs, this.objectiveCRS, false);
                }
                this.objectivePOI = mt.transform((DirectPosition)copy, this.allocatePosition());
                this.pointOfInterest = copy;
                this.multidimToObjective = mt;
                this.augmentedObjectiveCRS = null;
                this.axisTypes = null;
                this.gridGeometry = null;
                this.operationContext.partialClear(true);
                this.firePropertyChange(POINT_OF_INTEREST_PROPERTY, oldValue, newValue);
            }
            catch (TransformException | FactoryException e) {
                throw new RenderException(this.errors().getString((short)15, (Object)POINT_OF_INTEREST_PROPERTY), e);
            }
        }
    }

    final double[] getObjectivePOI() {
        return this.objectivePOI != null ? this.objectivePOI.getCoordinate() : null;
    }

    public GridGeometry getGridGeometry() throws RenderException {
        if (this.gridGeometry == null) {
            try {
                GridExtent extent;
                if (this.augmentedObjectiveCRS == null) {
                    if (this.pointOfInterest != null && this.objectiveCRS != null) {
                        CoordinateReferenceSystem crs = this.pointOfInterest.getCoordinateReferenceSystem();
                        ArrayList<CoordinateReferenceSystem> components = new ArrayList<CoordinateReferenceSystem>(4);
                        components.add(this.objectiveCRS);
                        this.supplementalDimensions = CanvasExtent.findSupplementalDimensions(crs, this.multidimToObjective.derivative((DirectPosition)this.pointOfInterest), components);
                        this.augmentedObjectiveCRS = CRS.compound((CoordinateReferenceSystem[])((CoordinateReferenceSystem[])components.toArray(CoordinateReferenceSystem[]::new)));
                        if (Utilities.equalsIgnoreMetadata((Object)this.augmentedObjectiveCRS, (Object)crs)) {
                            this.augmentedObjectiveCRS = crs;
                        }
                    } else {
                        this.augmentedObjectiveCRS = this.objectiveCRS;
                    }
                    this.axisTypes = CanvasExtent.suggestAxisTypes(this.augmentedObjectiveCRS, this.getDisplayDimensions());
                    this.getDisplayAxes(this.axisTypes);
                }
                if (this.objectiveToDisplay == null) {
                    this.objectiveToDisplay = this.createObjectiveToDisplay();
                }
                LinearTransform gridToCRS = this.objectiveToDisplay.inverse();
                if (this.supplementalDimensions != 0L) {
                    gridToCRS = CanvasExtent.createGridToCRS(gridToCRS.getMatrix(), (DirectPosition)this.pointOfInterest, this.supplementalDimensions);
                }
                if (this.displayBounds.isEmpty()) {
                    extent = null;
                } else {
                    DirectPosition poi = this.objectivePOI;
                    if (poi != null) {
                        poi = this.objectiveToDisplay.transform(this.objectivePOI, null);
                    }
                    extent = CanvasExtent.create(this.displayBounds, poi, this.axisTypes, gridToCRS.getSourceDimensions());
                }
                this.gridGeometry = new GridGeometry(extent, PixelInCell.CELL_CORNER, (MathTransform)gridToCRS, this.augmentedObjectiveCRS);
            }
            catch (TransformException | FactoryException e) {
                throw new RenderException(this.errors().getString((short)5, (Object)GRID_GEOMETRY_PROPERTY), e);
            }
        }
        return this.gridGeometry;
    }

    public void setGridGeometry(GridGeometry newValue) throws RenderException {
        ArgumentChecks.ensureNonNull((String)GRID_GEOMETRY_PROPERTY, (Object)newValue);
        if (!newValue.equals((Object)this.gridGeometry)) {
            try {
                GeneralDirectPosition newPOI;
                CoordinateReferenceSystem crs;
                GridExtent extent = newValue.getExtent();
                int[] displayDimensions = extent.getSubspaceDimensions(this.getDisplayDimensions());
                GeneralEnvelope newBounds = new GeneralEnvelope((CoordinateReferenceSystem)this.getDisplayCRS());
                for (int i = 0; i < displayDimensions.length; ++i) {
                    int s = displayDimensions[i];
                    newBounds.setRange(i, (double)extent.getLow(s), (double)Math.incrementExact(extent.getHigh(s)));
                }
                MathTransform gridToCRS = newValue.getGridToCRS(PixelInCell.CELL_CORNER);
                if (newValue.isDefined(1)) {
                    crs = newValue.getCoordinateReferenceSystem();
                    newPOI = new GeneralDirectPosition(crs);
                } else {
                    crs = null;
                    newPOI = new GeneralDirectPosition(gridToCRS.getTargetDimensions());
                }
                gridToCRS.transform(extent.getPointOfInterest(PixelInCell.CELL_CORNER), 0, newPOI.coordinates, 0, 1);
                TransformSeparator analyzer = new TransformSeparator(gridToCRS, this.coordinateOperationFactory.getMathTransformFactory());
                analyzer.addSourceDimensions(displayDimensions);
                LinearTransform newObjectiveToDisplay = MathTransforms.tangent((MathTransform)analyzer.separate().inverse(), (DirectPosition)newPOI);
                int[] objectiveDimensions = analyzer.getTargetDimensions();
                CoordinateReferenceSystem newObjectiveCRS = CRS.selectDimensions((CoordinateReferenceSystem)crs, (int[])objectiveDimensions);
                LinearTransform dimensionSelect = MathTransforms.linear((Matrix)Matrices.createDimensionSelect((int)newPOI.getDimension(), (int[])objectiveDimensions));
                GeneralEnvelope oldBounds = new GeneralEnvelope((Envelope)this.displayBounds);
                GeneralDirectPosition oldPOI = this.pointOfInterest;
                LinearTransform oldObjectiveToDisplay = this.objectiveToDisplay;
                CoordinateReferenceSystem oldObjectiveCRS = this.objectiveCRS;
                this.displayBounds.setEnvelope((Envelope)newBounds);
                this.setObjectiveToDisplayImpl(newObjectiveToDisplay);
                this.pointOfInterest = newPOI;
                this.objectivePOI = newPOI;
                this.objectiveCRS = newObjectiveCRS;
                this.multidimToObjective = dimensionSelect;
                this.augmentedObjectiveCRS = null;
                this.axisTypes = null;
                this.gridGeometry = newValue;
                this.fireIfChanged(DISPLAY_BOUNDS_PROPERTY, oldBounds, newBounds);
                this.fireIfChanged(OBJECTIVE_CRS_PROPERTY, oldObjectiveCRS, newObjectiveCRS);
                this.fireIfChanged(oldObjectiveToDisplay, newObjectiveToDisplay, true);
                this.fireIfChanged(POINT_OF_INTEREST_PROPERTY, oldPOI, newPOI);
            }
            catch (CannotEvaluateException | IncompleteGridGeometryException | TransformException | FactoryException e) {
                throw new RenderException(this.errors().getString((short)15, (Object)GRID_GEOMETRY_PROPERTY), e);
            }
        }
    }

    private void fireIfChanged(String propertyName, Object oldValue, Object newValue) {
        if (!Objects.equals(oldValue, newValue)) {
            this.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void fireIfChanged(LinearTransform oldValue, LinearTransform newValue, boolean grid) {
        if (!Objects.equals(oldValue, newValue)) {
            this.firePropertyChange(new TransformChangeEvent(this, oldValue, newValue, grid ? TransformChangeEvent.Reason.GRID_GEOMETRY_CHANGE : TransformChangeEvent.Reason.CRS_CHANGE));
        }
    }

    public Optional<GeographicBoundingBox> getGeographicArea() throws RenderException {
        try {
            return this.operationContext.getGeographicArea(this);
        }
        catch (TransformException e) {
            throw new RenderException(this.errors().getString((short)5, (Object)GEOGRAPHIC_AREA_PROPERTY), e);
        }
    }

    public OptionalDouble getSpatialResolution() throws RenderException {
        try {
            return this.operationContext.getSpatialResolution(this);
        }
        catch (TransformException e) {
            throw new RenderException(this.errors().getString((short)5, (Object)SPATIAL_RESOLUTION_PROPERTY), e);
        }
    }

    private CoordinateOperation objectiveToGeographic(CoordinateReferenceSystem crs) throws FactoryException {
        GeographicCRS geoCRS = ReferencingUtilities.toNormalizedGeographicCRS((CoordinateReferenceSystem)crs, (boolean)false, (boolean)false);
        return geoCRS != null ? this.coordinateOperationFactory.createOperation(crs, (CoordinateReferenceSystem)geoCRS) : null;
    }

    private MathTransform findTransform(CoordinateReferenceSystem source, CoordinateReferenceSystem target, boolean allowDisplayCRS) throws FactoryException, TransformException, RenderException {
        if (allowDisplayCRS) {
            allowDisplayCRS = Utilities.equalsIgnoreMetadata((Object)source, (Object)this.displayBounds.getCoordinateReferenceSystem());
        }
        if (allowDisplayCRS) {
            source = this.objectiveCRS;
        }
        this.operationContext.refresh(this);
        MathTransform tr = this.coordinateOperationFactory.createOperation(source, target, (CoordinateOperationContext)this.operationContext).getMathTransform();
        if (allowDisplayCRS) {
            tr = MathTransforms.concatenate((MathTransform)this.getObjectiveToDisplay().inverse(), (MathTransform)tr);
        }
        return tr;
    }

    DirectPosition allocatePosition() {
        return new GeneralDirectPosition(this.objectiveCRS);
    }

    private Errors errors() {
        return Errors.getResources((Locale)this.locale);
    }
}

