/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.map.coverage;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.ImageRenderer;
import org.apache.sis.coverage.grid.PixelTranslation;
import org.apache.sis.coverage.grid.j2d.ColorModelType;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.coverage.internal.SampleDimensions;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.geometry.Shapes2D;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.io.TableAppender;
import org.apache.sis.map.coverage.MultiResolutionCoverageLoader;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.portrayal.PlanarCanvas;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.util.WraparoundApplicator;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.CloneAccess;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class RenderingData
implements CloneAccess {
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.portrayal");
    private static final int BIDIMENSIONAL = 2;
    private static final boolean CREATE_INDEX_COLOR_MODEL = true;
    public MultiResolutionCoverageLoader coverageLoader;
    private int currentPyramidLevel;
    private GridExtent currentSlice;
    private int[] xyDimensions;
    private RenderedImage data;
    private GridGeometry dataGeometry;
    private SampleDimension[] dataRanges;
    private CoordinateOperation changeOfCRS;
    private MathTransform cornerToObjective;
    private MathTransform objectiveToCenter;
    private AffineTransform displayToObjective;
    private Statistics[] statistics;
    public final ImageProcessor processor = new ImageProcessor();

    public RenderingData(ErrorHandler errorHandler) {
        this.processor.setErrorHandler(errorHandler);
        this.processor.setImageResizingPolicy(ImageProcessor.Resizing.EXPAND);
    }

    public final void clear() {
        this.clearCRS();
        this.coverageLoader = null;
        this.displayToObjective = null;
        this.statistics = null;
        this.data = null;
        this.dataRanges = null;
        this.dataGeometry = null;
        this.xyDimensions = null;
        this.currentSlice = null;
    }

    private void clearCRS() {
        this.changeOfCRS = null;
        this.cornerToObjective = null;
        this.objectiveToCenter = null;
    }

    public final boolean validateCRS(CoordinateReferenceSystem objectiveCRS) {
        if (this.changeOfCRS != null && !Utilities.equalsIgnoreMetadata((Object)objectiveCRS, (Object)this.changeOfCRS.getTargetCRS())) {
            this.clearCRS();
            return false;
        }
        return true;
    }

    public final void setImageSpace(GridGeometry domain, List<SampleDimension> ranges, int[] xyDims) {
        this.dataRanges = ranges != null ? (SampleDimension[])ranges.toArray(SampleDimension[]::new) : null;
        this.dataGeometry = domain;
        this.xyDimensions = xyDims;
        this.processor.setFillValues(SampleDimensions.backgrounds((SampleDimension[])this.dataRanges));
        if (domain != null && !domain.isDefined(8) && domain.isDefined(4)) {
            CoordinateReferenceSystem crs = null;
            if (domain.isDefined(1)) {
                crs = domain.getCoordinateReferenceSystem();
            }
            GridExtent extent = domain.getExtent();
            this.dataGeometry = new GridGeometry(extent, PixelInCell.CELL_CENTER, (MathTransform)MathTransforms.identity((int)extent.getDimension()), crs);
        }
    }

    public final GridCoverage ensureCoverageLoaded(LinearTransform objectiveToDisplay, DirectPosition objectivePOI) throws TransformException, DataStoreException {
        MathTransform dataToObjective = this.changeOfCRS != null ? this.changeOfCRS.getMathTransform() : null;
        MultiResolutionCoverageLoader loader = this.coverageLoader;
        int level = loader.findPyramidLevel(dataToObjective, objectiveToDisplay, objectivePOI);
        if (this.data != null && level == this.currentPyramidLevel) {
            return null;
        }
        this.data = null;
        this.currentPyramidLevel = level;
        return loader.getOrLoad(level);
    }

    public final boolean ensureImageLoaded(GridCoverage coverage, GridExtent sliceExtent, boolean force) throws FactoryException, TransformException {
        int[] xyDims;
        GridGeometry domain;
        if (!force && this.data != null && Objects.equals(this.currentSlice, sliceExtent)) {
            return false;
        }
        coverage = coverage.forConvertedValues(true);
        GridGeometry old = this.dataGeometry;
        List ranges = coverage.getSampleDimensions();
        RenderedImage image = coverage.render(sliceExtent);
        Object value = image.getProperty("org.apache.sis.GridGeometry");
        if (value instanceof GridGeometry) {
            domain = (GridGeometry)value;
            xyDims = sliceExtent == null ? ArraysExt.range((int)0, (int)2) : sliceExtent.getSubspaceDimensions(2);
        } else {
            ImageRenderer r = new ImageRenderer(coverage, sliceExtent);
            domain = r.getImageGeometry(2);
            xyDims = r.getXYDimensions();
        }
        this.setImageSpace(domain, ranges, xyDims);
        this.currentSlice = sliceExtent;
        this.data = image;
        if (old != null && this.cornerToObjective != null && this.objectiveToCenter != null) {
            MathTransform toNew = null;
            MathTransform toOld = null;
            if (old.isDefined(1) && domain.isDefined(1)) {
                CoordinateReferenceSystem oldCRS = old.getCoordinateReferenceSystem();
                CoordinateReferenceSystem newCRS = this.dataGeometry.getCoordinateReferenceSystem();
                if (newCRS != oldCRS) {
                    GeographicBoundingBox areaOfInterest = Extents.union((GeographicBoundingBox)this.dataGeometry.getGeographicExtent().orElse(null), (GeographicBoundingBox)old.getGeographicExtent().orElse(null));
                    toNew = CRS.findOperation((CoordinateReferenceSystem)oldCRS, (CoordinateReferenceSystem)newCRS, (GeographicBoundingBox)areaOfInterest).getMathTransform();
                    toOld = toNew.inverse();
                }
            }
            MathTransform inverse = RenderingData.concatenate(PixelInCell.CELL_CORNER, this.dataGeometry, old, toOld);
            MathTransform forward = RenderingData.concatenate(PixelInCell.CELL_CENTER, old, this.dataGeometry, toNew);
            this.cornerToObjective = MathTransforms.concatenate((MathTransform)inverse, (MathTransform)this.cornerToObjective);
            this.objectiveToCenter = MathTransforms.concatenate((MathTransform)this.objectiveToCenter, (MathTransform)forward);
        }
        return true;
    }

    private static MathTransform concatenate(PixelInCell anchor, GridGeometry toCRS, GridGeometry toGrid, MathTransform changeOfCRS) throws TransformException {
        MathTransform forward = toCRS.getGridToCRS(anchor);
        MathTransform inverse = toGrid.getGridToCRS(anchor).inverse();
        if (changeOfCRS != null) {
            return MathTransforms.concatenate((MathTransform)forward, (MathTransform)changeOfCRS, (MathTransform)inverse);
        }
        return MathTransforms.concatenate((MathTransform)forward, (MathTransform)inverse);
    }

    public final RenderedImage getSourceImage() {
        return this.data;
    }

    private DirectPosition getSourceMedian() {
        if (this.dataGeometry.isDefined(2)) {
            return AbstractEnvelope.castOrCopy((Envelope)this.dataGeometry.getEnvelope()).getMedian();
        }
        return null;
    }

    protected final Map<String, Object> statistics() throws DataStoreException {
        if (this.statistics == null) {
            int level;
            RenderedImage image = this.data;
            MultiResolutionCoverageLoader loader = this.coverageLoader;
            if (loader != null && (level = loader.getLastLevel()) != this.currentPyramidLevel) {
                GridCoverage coarse = loader.getOrLoad(level).forConvertedValues(true);
                GridExtent sliceExtent = this.currentSlice;
                if (sliceExtent != null) {
                    if (sliceExtent.getDimension() <= 2) {
                        sliceExtent = null;
                    } else {
                        GridExtent ce = coarse.getGridGeometry().getExtent();
                        for (int i : this.xyDimensions) {
                            sliceExtent = sliceExtent.withRange(i, ce.getLow(i), ce.getHigh(i));
                        }
                    }
                }
                image = coarse.render(sliceExtent);
            }
            this.statistics = this.processor.valueOfStatistics(image, null, SampleDimensions.toSampleFilters((SampleDimension[])this.dataRanges));
        }
        HashMap<String, Object> modifiers = new HashMap<String, Object>(8);
        modifiers.put("statistics", this.statistics);
        modifiers.put("sampleDimensions", this.dataRanges);
        return modifiers;
    }

    public final void setObjectiveCRS(CoordinateReferenceSystem objectiveCRS) throws TransformException {
        if (this.changeOfCRS == null && objectiveCRS != null && this.dataGeometry.isDefined(1)) {
            try {
                this.changeOfCRS = CRS.findOperation((CoordinateReferenceSystem)this.dataGeometry.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)objectiveCRS, (GeographicBoundingBox)this.dataGeometry.getGeographicExtent().orElse(null));
                double accuracy = CRS.getLinearAccuracy((CoordinateOperation)this.changeOfCRS);
                this.processor.setPositionalAccuracyHints(new Quantity[]{accuracy > 0.0 ? Quantities.create((double)accuracy, (Unit)Units.METRE) : null});
            }
            catch (FactoryException e) {
                RenderingData.recoverableException((Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RenderedImage resampleAndConvert(RenderedImage recoloredImage, LinearTransform objectiveToDisplay, DirectPosition objectivePOI) throws TransformException {
        MathTransform nowrap;
        MathTransform objToCenterNoWrap = null;
        if (this.cornerToObjective == null || this.objectiveToCenter == null) {
            this.cornerToObjective = this.dataGeometry.getGridToCRS(PixelInCell.CELL_CORNER);
            this.objectiveToCenter = this.dataGeometry.getGridToCRS(PixelInCell.CELL_CENTER).inverse();
            if (this.changeOfCRS != null) {
                MathTransform inverse;
                DirectPosition median = this.getSourceMedian();
                MathTransform forward = this.changeOfCRS.getMathTransform();
                MathTransform nowrap2 = inverse = forward.inverse();
                try {
                    forward = RenderingData.applyWraparound(forward, median, objectivePOI, this.changeOfCRS.getTargetCRS());
                    inverse = RenderingData.applyWraparound(inverse, objectivePOI, median, this.changeOfCRS.getSourceCRS());
                }
                catch (TransformException e) {
                    RenderingData.recoverableException((Exception)((Object)e));
                }
                if (inverse != nowrap2) {
                    objToCenterNoWrap = MathTransforms.concatenate((MathTransform)nowrap2, (MathTransform)this.objectiveToCenter);
                }
                this.cornerToObjective = MathTransforms.concatenate((MathTransform)this.cornerToObjective, (MathTransform)forward);
                this.objectiveToCenter = MathTransforms.concatenate((MathTransform)inverse, (MathTransform)this.objectiveToCenter);
            }
        }
        LinearTransform inverse = objectiveToDisplay.inverse();
        this.displayToObjective = AffineTransforms2D.castOrCopy((MathTransform)inverse);
        MathTransform cornerToDisplay = MathTransforms.concatenate((MathTransform)this.cornerToObjective, (MathTransform)objectiveToDisplay);
        MathTransform displayToCenter = MathTransforms.concatenate((MathTransform)inverse, (MathTransform)this.objectiveToCenter);
        Rectangle bounds = ImageUtilities.getBounds((RenderedImage)recoloredImage);
        MathTransforms.getDomain((MathTransform)cornerToDisplay).ifPresent(domain -> Shapes2D.intersect((RectangularShape)bounds, (Envelope)domain, (int)0, (int)1));
        Shapes2D.transform((MathTransform2D)MathTransforms.bidimensional((MathTransform)cornerToDisplay), (Rectangle2D)bounds, (Rectangle2D)bounds);
        if (objToCenterNoWrap != null && !RenderingData.isWraparoundNeeded(bounds, displayToCenter, nowrap = MathTransforms.concatenate((MathTransform)inverse, objToCenterNoWrap))) {
            this.objectiveToCenter = objToCenterNoWrap;
            displayToCenter = nowrap;
        }
        ColorModelType ct = ColorModelType.find((ColorModel)recoloredImage.getColorModel());
        if (ct.isSlow || ct.useColorRamp) {
            try {
                SampleDimensions.IMAGE_PROCESSOR_ARGUMENT.set(this.dataRanges);
                RenderedImage renderedImage = this.processor.visualize(recoloredImage, bounds, displayToCenter);
                return renderedImage;
            }
            finally {
                SampleDimensions.IMAGE_PROCESSOR_ARGUMENT.remove();
            }
        }
        return this.processor.resample(recoloredImage, bounds, displayToCenter);
    }

    private static MathTransform applyWraparound(MathTransform transform, DirectPosition sourceMedian, DirectPosition targetMedian, CoordinateReferenceSystem targetCRS) throws TransformException {
        if (targetMedian == null) {
            return transform;
        }
        if (sourceMedian != null && !transform.isIdentity()) {
            sourceMedian = transform.transform(sourceMedian, null);
        }
        return new WraparoundApplicator(sourceMedian, targetMedian, targetCRS.getCoordinateSystem()).forDomainOfUse(transform);
    }

    private static boolean isWraparoundNeeded(Rectangle bounds, MathTransform reference, MathTransform nowrap) throws TransformException {
        int numPts = 9;
        int srcDim = nowrap.getSourceDimensions();
        int tgtDim = nowrap.getTargetDimensions();
        double[] source = new double[srcDim * 9];
        double[] target = new double[tgtDim * 9];
        for (int pi = 0; pi < 9; ++pi) {
            double y;
            double x;
            switch (pi % 3) {
                case 0: {
                    x = bounds.getMinX();
                    break;
                }
                case 1: {
                    x = bounds.getMaxX();
                    break;
                }
                default: {
                    x = bounds.getCenterX();
                }
            }
            switch (pi / 3) {
                case 0: {
                    y = bounds.getMinY();
                    break;
                }
                case 1: {
                    y = bounds.getMaxY();
                    break;
                }
                default: {
                    y = bounds.getCenterY();
                }
            }
            int i = pi * srcDim;
            source[i] = x;
            source[i + 1] = y;
        }
        nowrap.transform(source, 0, target, 0, 9);
        reference.transform(source, 0, source, 0, 9);
        for (int i = 0; i < target.length; ++i) {
            double r = source[i];
            if (Math.abs(target[i] - r) < 1.0 || !Double.isFinite(r)) continue;
            return true;
        }
        return false;
    }

    public final RenderedImage prefetch(RenderedImage resampledImage, AffineTransform resampledToDisplay, Envelope2D displayBounds) {
        Rectangle areaOfInterest;
        try {
            areaOfInterest = (Rectangle)AffineTransforms2D.transform((AffineTransform)resampledToDisplay.createInverse(), (Rectangle2D)displayBounds, (Rectangle2D)new Rectangle());
        }
        catch (NoninvertibleTransformException e) {
            RenderingData.recoverableException(e);
            return resampledImage;
        }
        return this.processor.prefetch(resampledImage, areaOfInterest);
    }

    public final AffineTransform getTransform(LinearTransform objectiveToDisplay) {
        if (this.displayToObjective == null) {
            return new AffineTransform();
        }
        AffineTransform resampledToDisplay = AffineTransforms2D.castOrCopy((MathTransform)objectiveToDisplay);
        if (resampledToDisplay == objectiveToDisplay) {
            resampledToDisplay = new AffineTransform(resampledToDisplay);
        }
        resampledToDisplay.concatenate(this.displayToObjective);
        ImageUtilities.roundIfAlmostInteger((AffineTransform)resampledToDisplay);
        return resampledToDisplay;
    }

    public final float getDataPixelSize(DirectPosition objectivePOI) {
        if (this.objectiveToCenter != null) {
            try {
                Matrix d = this.objectiveToCenter.derivative(objectivePOI);
                double sum = 0.0;
                int j = d.getNumRow();
                while (--j >= 0) {
                    int i = d.getNumCol();
                    while (--i >= 0) {
                        double v = d.getElement(j, i);
                        sum += v * v;
                    }
                }
                float r = (float)(1.0 / Math.sqrt(sum));
                if (r > 0.0f && r != Float.POSITIVE_INFINITY) {
                    return r;
                }
            }
            catch (TransformException e) {
                RenderingData.recoverableException((Exception)((Object)e));
            }
        }
        return 0.0f;
    }

    public final MathTransform getDataToObjective(PixelInCell anchor) {
        return PixelTranslation.translate((MathTransform)this.cornerToObjective, (PixelInCell)PixelInCell.CELL_CORNER, (PixelInCell)anchor);
    }

    public final Rectangle objectiveToData(Rectangle2D bounds) throws TransformException {
        if (this.objectiveToCenter == null) {
            return null;
        }
        return (Rectangle)Shapes2D.transform((MathTransform2D)MathTransforms.bidimensional((MathTransform)this.objectiveToCenter), (Rectangle2D)bounds, (Rectangle2D)new Rectangle());
    }

    public final boolean hasChanged(RenderingData previous) {
        return previous.dataGeometry != this.dataGeometry || previous.objectiveToCenter != this.objectiveToCenter;
    }

    private static void recoverableException(Exception e) {
        Logging.recoverableException((Logger)LOGGER, PlanarCanvas.class, (String)"render", (Throwable)e);
    }

    public RenderingData clone() {
        try {
            return (RenderingData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        String lineSeparator = System.lineSeparator();
        StringBuilder buffer = new StringBuilder(6000);
        TableAppender table = new TableAppender((Appendable)buffer);
        table.setMultiLinesCells(true);
        try {
            table.nextLine('\u2550');
            table.append((CharSequence)"Geometry of source coverage:").append((CharSequence)lineSeparator).append((CharSequence)String.valueOf(this.dataGeometry)).appendHorizontalSeparator();
            table.append((CharSequence)"Pixel corners to objective CRS:").append((CharSequence)lineSeparator).append((CharSequence)String.valueOf(this.cornerToObjective)).appendHorizontalSeparator();
            table.append((CharSequence)"Median in data CRS:").append((CharSequence)lineSeparator).append((CharSequence)String.valueOf(this.getSourceMedian())).nextLine();
            table.nextLine('\u2550');
            table.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer.toString();
    }
}

