/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.gazetteer.AbstractLocation;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.coordinate.Position;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

class SimpleLocation
extends AbstractLocation
implements DirectPosition,
Envelope,
GeographicBoundingBox {
    protected double minX = Double.NaN;
    protected double minY = Double.NaN;
    protected double maxX = Double.NaN;
    protected double maxY = Double.NaN;

    SimpleLocation(AbstractLocationType type, CharSequence identifier) {
        super(type, identifier);
    }

    @Override
    public GeographicExtent getGeographicExtent() {
        return this;
    }

    @Override
    public final Envelope getEnvelope() {
        return this;
    }

    @Override
    public final Position getPosition() {
        return this;
    }

    public final DirectPosition getDirectPosition() {
        return this;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return CommonCRS.defaultGeographic();
    }

    public final int getDimension() {
        return 2;
    }

    public final double[] getCoordinate() {
        return new double[]{this.getOrdinate(0), this.getOrdinate(1)};
    }

    public final double getOrdinate(int dimension) {
        return this.getMedian(dimension);
    }

    public final double getMinimum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.minX;
            }
            case 1: {
                return this.minY;
            }
        }
        throw new IndexOutOfBoundsException(SimpleLocation.indexOutOfBounds(dimension));
    }

    public final double getMaximum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.maxX;
            }
            case 1: {
                return this.maxY;
            }
        }
        throw new IndexOutOfBoundsException(SimpleLocation.indexOutOfBounds(dimension));
    }

    public final double getMedian(int dimension) {
        switch (dimension) {
            case 0: {
                return (this.minX + this.maxX) / 2.0;
            }
            case 1: {
                return (this.minY + this.maxY) / 2.0;
            }
        }
        throw new IndexOutOfBoundsException(SimpleLocation.indexOutOfBounds(dimension));
    }

    public final double getSpan(int dimension) {
        switch (dimension) {
            case 0: {
                return this.maxX - this.minX;
            }
            case 1: {
                return this.maxY - this.minY;
            }
        }
        throw new IndexOutOfBoundsException(SimpleLocation.indexOutOfBounds(dimension));
    }

    private static String indexOutOfBounds(int dimension) {
        return Errors.format((short)71, (Object)dimension);
    }

    public final DirectPosition getLowerCorner() {
        return new DirectPosition2D(this.getCoordinateReferenceSystem(), this.minX, this.minY);
    }

    public final DirectPosition getUpperCorner() {
        return new DirectPosition2D(this.getCoordinateReferenceSystem(), this.maxX, this.maxY);
    }

    public final void setOrdinate(int dimension, double value) {
        throw new UnsupportedOperationException(Errors.format((short)153, DirectPosition.class));
    }

    public final Boolean getInclusion() {
        return Boolean.TRUE;
    }

    public double getWestBoundLongitude() {
        return this.minX;
    }

    public double getEastBoundLongitude() {
        return this.maxX;
    }

    public double getSouthBoundLatitude() {
        return this.minY;
    }

    public double getNorthBoundLatitude() {
        return this.maxY;
    }

    final void convert(MathTransform mt, double[] buffer) throws TransformException {
        buffer[3] = buffer[7] = this.maxY;
        buffer[4] = buffer[6] = this.maxX;
        buffer[1] = buffer[5] = this.minY;
        buffer[0] = buffer[2] = this.minX;
        this.maxY = Double.NaN;
        this.minY = Double.NaN;
        this.maxX = Double.NaN;
        this.minX = Double.NaN;
        mt.transform(buffer, 0, buffer, 0, 4);
        int i = 0;
        while (i < 8) {
            double x = buffer[i++];
            double y = buffer[i++];
            if (Double.isNaN(x) || Double.isNaN(y)) {
                throw new TransformException(Errors.format((short)16));
            }
            if (!(x >= this.minX)) {
                this.minX = x;
            }
            if (!(x <= this.maxX)) {
                this.maxX = x;
            }
            if (!(y >= this.minY)) {
                this.minY = y;
            }
            if (y <= this.maxY) continue;
            this.maxY = y;
        }
    }

    static abstract class Projected
    extends SimpleLocation
    implements GeographicBoundingBox {
        protected double westBoundLongitude = Double.NaN;
        protected double eastBoundLongitude = Double.NaN;
        protected double southBoundLatitude = Double.NaN;
        protected double northBoundLatitude = Double.NaN;

        Projected(AbstractLocationType type, CharSequence identifier) {
            super(type, identifier);
        }

        @Override
        public final double getWestBoundLongitude() {
            return this.westBoundLongitude;
        }

        @Override
        public final double getEastBoundLongitude() {
            return this.eastBoundLongitude;
        }

        @Override
        public final double getSouthBoundLatitude() {
            return this.southBoundLatitude;
        }

        @Override
        public final double getNorthBoundLatitude() {
            return this.northBoundLatitude;
        }

        final void computeGeographicBoundingBox(MathTransform inverse) throws TransformException {
            double[] points = new double[]{this.minX, this.minY, this.minX, this.maxY, this.maxX, this.minY, this.maxX, this.maxY};
            inverse.transform(points, 0, points, 0, 4);
            int i = 0;
            while (i < points.length) {
                double \u03c6 = points[i++];
                double \u03bb = points[i++];
                if (Double.isNaN(\u03c6) || Double.isNaN(\u03bb)) {
                    throw new TransformException(Errors.format((short)16));
                }
                if (!(\u03c6 >= this.southBoundLatitude)) {
                    this.southBoundLatitude = \u03c6;
                }
                if (!(\u03c6 <= this.northBoundLatitude)) {
                    this.northBoundLatitude = \u03c6;
                }
                if (!(\u03bb >= this.westBoundLongitude)) {
                    this.westBoundLongitude = \u03bb;
                }
                if (\u03bb <= this.eastBoundLongitude) continue;
                this.eastBoundLongitude = \u03bb;
            }
        }

        final boolean clipGeographicBoundingBox(double \u03bbmin, double \u03c6min, double \u03bbmax, double \u03c6max) {
            boolean changed = false;
            if (this.westBoundLongitude < \u03bbmin) {
                this.westBoundLongitude = \u03bbmin;
                changed = true;
            }
            if (this.eastBoundLongitude > \u03bbmax) {
                this.eastBoundLongitude = \u03bbmax;
                changed = true;
            }
            if (this.southBoundLatitude < \u03c6min) {
                this.southBoundLatitude = \u03c6min;
                changed = true;
            }
            if (this.northBoundLatitude > \u03c6max) {
                this.northBoundLatitude = \u03c6max;
                changed = true;
            }
            return changed;
        }

        final void clipProjectedEnvelope(MathTransform forward, double tx, double ty) throws TransformException {
            double ymax;
            double xmax;
            double[] points = new double[]{this.southBoundLatitude, this.westBoundLongitude, this.northBoundLatitude, this.westBoundLongitude, this.southBoundLatitude, this.eastBoundLongitude, this.northBoundLatitude, this.eastBoundLongitude};
            forward.transform(points, 0, points, 0, 4);
            double xmin = xmax = points[0];
            double ymin = ymax = points[1];
            int i = 2;
            while (i < points.length) {
                double x = points[i++];
                double y = points[i++];
                if (x < xmin) {
                    xmin = x;
                }
                if (x > xmax) {
                    xmax = x;
                }
                if (y < ymin) {
                    ymin = y;
                }
                if (!(y > ymax)) continue;
                ymax = y;
            }
            if (xmin > this.minX + tx) {
                this.minX = xmin;
            }
            if (xmax < this.maxX - tx) {
                this.maxX = xmax;
            }
            if (ymin > this.minY + ty) {
                this.minY = ymin;
            }
            if (ymax < this.maxY - ty) {
                this.maxY = ymax;
            }
        }
    }
}

