/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.landsat;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.landsat.LandsatStore;
import org.apache.sis.storage.wkt.FirstKeywordPeek;
import org.opengis.parameter.ParameterDescriptorGroup;

@StoreMetadata(formatName="Landsat", capabilities={Capability.READ}, resourceTypes={Aggregate.class, GridCoverageResource.class})
public class LandsatStoreProvider
extends DataStoreProvider {
    static final String NAME = "Landsat";
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.landsat");
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR = URIDataStore.Provider.descriptor((String)"Landsat");

    public String getShortName() {
        return NAME;
    }

    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    static Path getMetadataFile(Path directory) {
        Path file;
        if (directory != null && Files.isRegularFile(file = directory.resolve(Path.of(directory.getFileName().toString().concat("_MTL.txt"), new String[0])), new LinkOption[0])) {
            return file;
        }
        return null;
    }

    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        return new Peek().probeContent(this, connector);
    }

    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new LandsatStore(this, connector);
    }

    public Logger getLogger() {
        return LOGGER;
    }

    private static final class Peek
    extends FirstKeywordPeek {
        private static final String KEYWORD = "GROUP=LANDSAT_METADATA_FILE";
        private static final String L1_KEYWORD = "GROUP=L1_METADATA_FILE";
        private static final int KEY = 0;
        private static final int SEPARATOR = 1;
        private static final int VALUE = 2;
        private int part = 0;

        Peek() {
            super(KEYWORD.length());
        }

        protected Path getAuxiliaryPath(StorageConnector connector) throws DataStoreException {
            return LandsatStoreProvider.getMetadataFile((Path)connector.getStorageAs(Path.class));
        }

        protected int isKeywordChar(int c) {
            int s = super.isKeywordChar(c);
            if (s == 0) {
                if (c >= 48 && c <= 57 && this.part == 2) {
                    return 1;
                }
                switch (c) {
                    case 9: 
                    case 32: {
                        if (this.part >= 2) break;
                        return 2;
                    }
                    case 61: {
                        if (this.part != 0) break;
                        this.part = 1;
                        return 1;
                    }
                }
            } else if (this.part == 1) {
                this.part = 2;
            }
            return s;
        }

        protected boolean isPostKeyword(int c) {
            return c == 71 || c == 103 || c == 35;
        }

        protected ProbeResult forKeyword(char[] keyword, int length) {
            String ks = new String(keyword, 0, length);
            if (KEYWORD.equalsIgnoreCase(ks) || L1_KEYWORD.equalsIgnoreCase(ks)) {
                return ProbeResult.SUPPORTED;
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        }
    }
}

