/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.landsat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.sis.storage.AbstractResource;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.StoreResource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.landsat.Band;
import org.apache.sis.storage.landsat.BandGroupName;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.opengis.metadata.Metadata;
import org.opengis.util.GenericName;

final class BandGroup
extends AbstractResource
implements Aggregate,
StoreResource {
    final BandGroupName group;
    GenericName identifier;
    private final Band[] components;

    private BandGroup(StoreListeners parent, BandGroupName group, Band[] resources, int count) {
        super(parent, false);
        this.group = group;
        int n = 0;
        Band[] components = new Band[resources.length];
        for (int i = 0; i < count; ++i) {
            Band r = resources[i];
            if (r.band.group != group) continue;
            components[n++] = r;
        }
        this.components = (Band[])ArraysExt.resize((Object[])components, (int)n);
    }

    static BandGroup[] group(StoreListeners parent, Band[] resources, int count) {
        BandGroupName[] groups = BandGroupName.values();
        BandGroup[] aggregates = new BandGroup[groups.length];
        int n = 0;
        for (BandGroupName group : groups) {
            BandGroup c = new BandGroup(parent, group, resources, count);
            if (c.components.length == 0) continue;
            aggregates[n++] = c;
        }
        return (BandGroup[])ArraysExt.resize((Object[])aggregates, (int)n);
    }

    public DataStore getOriginator() {
        return (DataStore)((StoreListeners)this.listeners.getParent().get()).getSource();
    }

    public Optional<GenericName> getIdentifier() {
        return Optional.of(this.identifier);
    }

    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder metadata = new MetadataBuilder();
        metadata.addTitle((CharSequence)this.group.title);
        metadata.addDefaultMetadata((AbstractResource)this, this.listeners);
        return metadata.build();
    }

    public Collection<Resource> components() {
        return UnmodifiableArrayList.wrap((Object[])this.components);
    }

    static final List<Band> bands(BandGroup[] components) {
        ArrayList<Band> bands = new ArrayList<Band>();
        if (components != null) {
            for (BandGroup c : components) {
                Collections.addAll(bands, c.components);
            }
        }
        return bands;
    }
}

