/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.xml.stream;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.xml.stream.StaxDataStore;
import org.apache.sis.storage.xml.stream.StaxStreamIO;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.StandardDateFormat;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.bind.Context;

public abstract class StaxStreamReader
extends StaxStreamIO
implements XMLStreamConstants,
Spliterator<AbstractFeature>,
Runnable {
    protected final XMLStreamReader reader;
    private boolean isNextDone;
    private Unmarshaller unmarshaller;

    protected StaxStreamReader(StaxDataStore owner) throws Exception {
        super(owner);
        this.reader = owner.createReader(this);
    }

    @Override
    public int characteristics() {
        return 1296;
    }

    @Override
    public abstract boolean tryAdvance(Consumer<? super AbstractFeature> var1) throws BackingStoreException;

    @Override
    public Spliterator<AbstractFeature> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    protected final XMLStreamReader getSubReader(final QName tagName) throws XMLStreamException {
        return new StreamReaderDelegate(this.reader){
            private int nested;

            @Override
            public boolean hasNext() throws XMLStreamException {
                return this.nested >= 0 && super.hasNext();
            }

            @Override
            public int next() throws XMLStreamException {
                if (this.nested < 0) {
                    throw new NoSuchElementException();
                }
                int t = super.next();
                switch (t) {
                    case 1: {
                        if (!tagName.equals(this.getName())) break;
                        ++this.nested;
                        break;
                    }
                    case 2: {
                        if (!tagName.equals(this.getName())) break;
                        --this.nested;
                    }
                }
                return t;
            }
        };
    }

    protected final void moveToRootElement(Predicate<String> isNamespace, String localName) throws EOFException, XMLStreamException, DataStoreContentException {
        if (!this.reader.isStartElement()) {
            do {
                if (this.reader.hasNext()) continue;
                throw new EOFException(this.endOfFile());
            } while (this.reader.next() != 1);
        }
        if (!isNamespace.test(this.reader.getNamespaceURI()) || !localName.equals(this.reader.getLocalName())) {
            throw new DataStoreContentException(this.errors().getString((short)139, (Object)this.owner.getFormatName(), (Object)this.owner.getDisplayName()));
        }
    }

    protected final void skipUntilEnd(QName tagName) throws EOFException, XMLStreamException {
        assert (this.reader.getEventType() == 1);
        this.isNextDone = false;
        int nested = 0;
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    if (!tagName.equals(this.reader.getName())) break;
                    ++nested;
                    break;
                }
                case 2: {
                    if (!tagName.equals(this.reader.getName()) || --nested >= 0) break;
                    return;
                }
            }
        }
        throw new EOFException(this.endOfFile());
    }

    protected final int next() throws XMLStreamException {
        if (!this.isNextDone) {
            return this.reader.next();
        }
        this.isNextDone = false;
        return this.reader.getEventType();
    }

    protected final String getElementText() throws XMLStreamException {
        return Strings.trimOrNull((String)this.reader.getElementText());
    }

    protected final URI getElementAsURI() throws XMLStreamException, URISyntaxException {
        Context context = Context.current();
        return Context.converter((Context)context).toURI((MarshalContext)context, this.getElementText());
    }

    protected final Integer getElementAsInteger() throws XMLStreamException {
        String text = this.getElementText();
        return text != null ? Integer.valueOf(text) : null;
    }

    protected final Double getElementAsDouble() throws XMLStreamException {
        String text = this.getElementText();
        return text != null ? Double.valueOf(StaxStreamReader.parseDouble(text)) : null;
    }

    protected final Date getElementAsDate() throws XMLStreamException {
        String text = this.getElementText();
        return text != null ? StandardDateFormat.toDate((TemporalAccessor)StandardDateFormat.FORMAT.parse(text)) : null;
    }

    protected final Temporal getElementAsTemporal() throws XMLStreamException {
        return StandardDateFormat.parseBest((CharSequence)this.getElementText());
    }

    protected final List<String> getElementAsList() throws XMLStreamException {
        String text = this.getElementText();
        return text != null ? Arrays.asList(text.split(" ")) : null;
    }

    protected static double parseDouble(String value) throws NumberFormatException {
        if (!value.endsWith("INF")) {
            return Double.parseDouble(value);
        }
        block0 : switch (value.length()) {
            case 4: {
                switch (value.charAt(0)) {
                    default: {
                        break block0;
                    }
                    case '-': {
                        return Double.NEGATIVE_INFINITY;
                    }
                    case '+': 
                }
            }
            case 3: {
                return Double.POSITIVE_INFINITY;
            }
        }
        throw new NumberFormatException(value);
    }

    protected static boolean parseBoolean(String value) {
        if (value.length() == 1) {
            switch (value.charAt(0)) {
                case '0': {
                    return false;
                }
                case '1': {
                    return true;
                }
            }
        }
        return Boolean.parseBoolean(value);
    }

    protected final <T> T unmarshal(Class<T> type) throws XMLStreamException, JAXBException {
        Unmarshaller m = this.unmarshaller;
        if (m == null) {
            m = this.getMarshallerPool().acquireUnmarshaller();
            for (Map.Entry entry : this.owner.configuration.entrySet()) {
                m.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        this.unmarshaller = null;
        JAXBElement element = m.unmarshal(this.reader, type);
        this.unmarshaller = m;
        this.isNextDone = true;
        return (T)element.getValue();
    }

    @Override
    public void close() throws JAXBException, XMLStreamException, IOException {
        Unmarshaller m = this.unmarshaller;
        if (m != null) {
            this.unmarshaller = null;
            this.getMarshallerPool().recycle(m);
        }
        this.reader.close();
        super.close();
    }

    @Override
    public final void run() throws BackingStoreException {
        try {
            this.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackingStoreException((Throwable)e);
        }
    }

    protected final String endOfFile() {
        return this.errors().getString((short)137, (Object)this.owner.getDisplayName());
    }

    protected final String canNotParseFile() {
        return IOUtilities.canNotReadFile((Locale)this.owner.getLocale(), (String)this.owner.getFormatName(), (String)this.owner.getDisplayName(), (Object)this.reader);
    }

    protected final String nestedElement(String name) {
        return this.errors().getString((short)94, (Object)name);
    }
}

