/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gpx;

import java.net.URISyntaxException;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.distribution.DefaultFormat;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.gpx.Reader;
import org.apache.sis.storage.gpx.StoreProvider;
import org.apache.sis.storage.gpx.Types;
import org.apache.sis.storage.xml.stream.StaxDataStore;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.Version;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.Format;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

public class Store
extends StaxDataStore
implements FeatureSet {
    Version version;
    private Metadata metadata;
    private Reader reader;
    final Types types;

    public Store(StoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        GeometryLibrary library = (GeometryLibrary)connector.getOption(OptionKey.GEOMETRY_LIBRARY);
        if (library == null || Types.DEFAULT.geometries.library == library) {
            this.types = Types.DEFAULT;
        } else {
            try {
                this.types = new Types((NameFactory)DefaultNameFactory.provider(), null, library);
            }
            catch (FactoryException e) {
                throw new DataStoreException((Throwable)e);
            }
        }
        this.listeners.useReadOnlyEvents();
    }

    final Format getFormat() {
        assert (Thread.holdsLock((Object)this));
        Format format = ((StoreProvider)this.provider).getFormat(this.listeners);
        if (this.version != null) {
            DefaultFormat df = new DefaultFormat(format);
            DefaultCitation citation = new DefaultCitation(df.getFormatSpecificationCitation());
            citation.setEdition((InternationalString)new SimpleInternationalString(this.version.toString()));
            df.setFormatSpecificationCitation((Citation)citation);
            format = df;
        }
        return format;
    }

    public synchronized Version getVersion() throws DataStoreException {
        if (this.version == null) {
            this.getMetadata();
        }
        return this.version;
    }

    public synchronized void setVersion(Version version) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"version", (Object)version);
        this.version = version;
    }

    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            try {
                this.reader = new Reader(this);
                this.version = this.reader.initialize(true);
                this.metadata = this.reader.getMetadata();
            }
            catch (DataStoreException e) {
                throw e;
            }
            catch (RuntimeException | URISyntaxException e) {
                throw new DataStoreContentException((Throwable)e);
            }
            catch (Exception e) {
                throw new DataStoreException((Throwable)e);
            }
        }
        return this.metadata;
    }

    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return Optional.ofNullable(StoreUtilities.getEnvelope((Metadata)this.getMetadata()));
    }

    public DefaultFeatureType getType() {
        return this.types.parent;
    }

    @Deprecated(since="0.8")
    public DefaultFeatureType getFeatureType(String name) throws IllegalNameException {
        return (DefaultFeatureType)this.types.names.get((DataStore)this, name);
    }

    public final synchronized Stream<AbstractFeature> features(boolean parallel) throws DataStoreException {
        Reader r = this.reader;
        this.reader = null;
        if (r == null) {
            try {
                r = new Reader(this);
                this.version = r.initialize(false);
            }
            catch (DataStoreException e) {
                throw e;
            }
            catch (RuntimeException | URISyntaxException e) {
                throw new DataStoreContentException((Throwable)e);
            }
            catch (Exception e) {
                throw new DataStoreException((Throwable)e);
            }
        }
        Stream<AbstractFeature> features = StreamSupport.stream(r, false);
        return (Stream)features.onClose(r);
    }

    final void closeReader() throws Exception {
        Reader r = this.reader;
        if (r != null) {
            this.reader = null;
            r.close();
        }
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.listeners.close();
        this.version = null;
        this.metadata = null;
        try {
            this.closeReader();
        }
        catch (Exception e) {
            DataStoreException ds = new DataStoreException((Throwable)e);
            try {
                super.close();
            }
            catch (DataStoreException s) {
                ds.addSuppressed(s.getCause());
            }
            throw ds;
        }
        super.close();
    }
}

