/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.Console;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogManager;
import org.apache.sis.console.AboutCommand;
import org.apache.sis.console.CRSCommand;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.HelpCommand;
import org.apache.sis.console.IdentifierCommand;
import org.apache.sis.console.InvalidCommandException;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.MetadataCommand;
import org.apache.sis.console.MimeTypeCommand;
import org.apache.sis.console.Option;
import org.apache.sis.console.TransformCommand;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.MonolineFormatter;
import org.apache.sis.util.resources.Errors;

public final class Command {
    public static final int INVALID_COMMAND_EXIT_CODE = 1;
    public static final int INVALID_OPTION_EXIT_CODE = 2;
    public static final int INVALID_ARGUMENT_EXIT_CODE = 3;
    public static final int UNKNOWN_STORAGE_EXIT_CODE = 4;
    public static final int IO_EXCEPTION_EXIT_CODE = 100;
    public static final int SQL_EXCEPTION_EXIT_CODE = 101;
    public static final int OTHER_ERROR_EXIT_CODE = 199;
    private final CommandRunner command;

    protected Command(String[] args) throws InvalidCommandException, InvalidOptionException {
        int commandIndex = -1;
        String commandName = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("--")) {
                String name = arg.substring("--".length());
                Option option = Option.forLabel(name);
                if (!option.hasValue) continue;
                ++i;
                continue;
            }
            commandName = arg;
            commandIndex = i;
            break;
        }
        if (commandName == null) {
            this.command = new HelpCommand(-1, args);
        } else {
            switch (commandName.toLowerCase(Locale.US)) {
                case "help": {
                    this.command = new HelpCommand(commandIndex, args);
                    break;
                }
                case "about": {
                    this.command = new AboutCommand(commandIndex, args);
                    break;
                }
                case "mime-type": {
                    this.command = new MimeTypeCommand(commandIndex, args);
                    break;
                }
                case "metadata": {
                    this.command = new MetadataCommand(commandIndex, args);
                    break;
                }
                case "crs": {
                    this.command = new CRSCommand(commandIndex, args);
                    break;
                }
                case "identifier": {
                    this.command = new IdentifierCommand(commandIndex, args);
                    break;
                }
                case "transform": {
                    this.command = new TransformCommand(commandIndex, args);
                    break;
                }
                default: {
                    throw new InvalidCommandException(Errors.format((short)145, (Object)commandName), commandName);
                }
            }
        }
        CommandRunner.instance = this.command;
    }

    public int run() throws Exception {
        if (this.command.hasContradictoryOptions(Option.BRIEF, Option.VERBOSE)) {
            return 2;
        }
        if (!this.command.options.containsKey((Object)Option.HELP)) {
            try {
                return this.command.run();
            }
            catch (Exception e) {
                this.command.error(null, e);
                throw e;
            }
        }
        this.command.help(this.command.commandName.toLowerCase(Locale.US));
        return 0;
    }

    public static int exitCodeFor(Throwable cause) {
        while (cause != null) {
            if (cause instanceof InvalidCommandException) {
                return 1;
            }
            if (cause instanceof InvalidOptionException) {
                return 2;
            }
            if (cause instanceof IOException) {
                return 100;
            }
            if (cause instanceof SQLException) {
                return 101;
            }
            cause = cause.getCause();
        }
        return 199;
    }

    private static void error(String[] args, Exception e) {
        boolean debug = ArraysExt.containsIgnoreCase((String[])args, (String)"--debug");
        Console console = System.console();
        if (console != null) {
            PrintWriter err = console.writer();
            if (debug) {
                e.printStackTrace(err);
            } else {
                err.println(e.getLocalizedMessage());
            }
            err.flush();
        } else {
            PrintStream err = System.err;
            if (debug) {
                e.printStackTrace(err);
            } else {
                err.println(e.getLocalizedMessage());
            }
            err.flush();
        }
    }

    public static void main(String[] args) {
        int status;
        Command c;
        LogManager manager = LogManager.getLogManager();
        if (MonolineFormatter.class.getName().equals(manager.getProperty(ConsoleHandler.class.getName() + ".formatter"))) {
            MonolineFormatter.install();
        }
        try {
            c = new Command(args);
        }
        catch (InvalidCommandException e) {
            Command.error(args, e);
            System.exit(1);
            return;
        }
        catch (InvalidOptionException e) {
            Command.error(args, e);
            System.exit(2);
            return;
        }
        try {
            status = c.run();
        }
        catch (Exception e) {
            status = Command.exitCodeFor(e);
        }
        if (status != 0) {
            System.exit(status);
        }
    }
}

