/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.setup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.sis.gui.setup.Inflater;
import org.apache.sis.gui.setup.Wizard;

public final class FXFinder {
    static final int JAVAFX_VERSION = 13;
    static final String JAVAFX_HOME = "https://openjfx.io/";
    static final String JAVAFX_DIRECTORY_PREFIX = "javafx-sdk-";
    private static final String JAVAFX_LIB_DIRECTORY = "lib";
    private static final String JAVAFX_SENTINEL_FILE = "javafx.controls.jar";
    static final String PATH_VARIABLE = "PATH_TO_FX";
    private static final String SIS_CONF_DIRECTORY = "conf";
    private static final String SIS_UNZIP_DIRECTORY = "opt";
    private static final String WINDOWS_BATCH_EXTENSION = ".bat";
    private static final int CANCEL_EXIT_CODE = 1;
    private static final int ERROR_EXIT_CODE = 2;
    private File specified;
    private File validated;
    private final Path setenv;
    private Inflater inflater;
    boolean useRelativePath;
    private final boolean isWindows;

    private FXFinder(String setenv) {
        this.setenv = Path.of(setenv, new String[0]).normalize();
        this.isWindows = setenv.endsWith(WINDOWS_BATCH_EXTENSION);
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            if (Wizard.show(new FXFinder(args[0]))) {
                return;
            }
        } else {
            System.out.println("Required: path to setenv.sh");
        }
        System.exit(2);
    }

    final String diagnostic() {
        if (Files.isReadable(this.setenv) && Files.isWritable(this.setenv)) {
            return null;
        }
        return "Cannot edit " + this.setenv;
    }

    final String[][] getEnvironmentVariables() {
        return new String[][]{this.getEnvironmentVariable("JAVA_HOME"), this.getEnvironmentVariable(PATH_VARIABLE), this.getEnvironmentVariable("SIS_DATA"), this.getEnvironmentVariable("SIS_OPTS")};
    }

    private String[] getEnvironmentVariable(String name) {
        String value;
        try {
            value = System.getenv(name);
            if (value == null) {
                value = "(undefined)";
            } else if (value.isEmpty()) {
                value = "(blank)";
            } else if (name.equals("SIS_DATA") && value.equals("bin/../data")) {
                value = Path.of(value, new String[0]).toAbsolutePath().toString();
            }
        }
        catch (SecurityException e) {
            value = "(unreadable)";
        }
        return new String[]{name, value};
    }

    static String getJavafxBundleName() {
        String name;
        try {
            name = System.getProperty("os.name");
        }
        catch (SecurityException e) {
            name = null;
        }
        if (name == null) {
            name = "<operating system>";
        }
        return "JavaFX " + name + " SDK";
    }

    final String getValidatedDirectory() {
        return this.validated != null ? this.validated.getPath() : null;
    }

    final File getDirectory() {
        return this.specified;
    }

    final boolean setDirectory(File dir) {
        this.specified = dir;
        this.validated = null;
        if (new File(dir, JAVAFX_SENTINEL_FILE).exists()) {
            this.validated = dir;
            return true;
        }
        File lib = new File(dir, JAVAFX_LIB_DIRECTORY);
        if (new File(lib, JAVAFX_SENTINEL_FILE).exists()) {
            this.validated = lib;
            return true;
        }
        return false;
    }

    static String checkZip(File file) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.isDirectory()) continue;
                String basedir = entry.getName();
                if (basedir.startsWith(JAVAFX_DIRECTORY_PREFIX)) {
                    int start;
                    char c;
                    int end;
                    for (end = start = JAVAFX_DIRECTORY_PREFIX.length(); end < basedir.length() && (c = basedir.charAt(end)) >= '0' && c <= '9'; ++end) {
                    }
                    if (end > start) {
                        int version = Integer.parseInt(basedir.substring(start, end));
                        if (version < 13) {
                            String string = "<html>Apache SIS requires JavaFX version 13 or later. The given file contains JavaFX version " + version + ".</html>";
                            return string;
                        }
                        if (zip.getEntry(basedir + "lib/javafx.controls.jar") != null) {
                            String string = null;
                            return string;
                        }
                    }
                }
                break;
            }
        }
        return "<html>Not a recognized ZIP file for JavaFX SDK.</html>";
    }

    final File getDestinationDirectory() throws IOException {
        File basedir = this.setenv.toAbsolutePath().toFile().getParentFile();
        if (basedir != null && SIS_CONF_DIRECTORY.equals(basedir.getName()) && (basedir = basedir.getParentFile()) != null) {
            File destination = new File(basedir, SIS_UNZIP_DIRECTORY);
            if (destination.isDirectory() || destination.mkdir()) {
                return destination;
            }
            throw new IOException("Cannot create directory: " + destination);
        }
        throw new FileNotFoundException("No parent directory to " + this.setenv + ".");
    }

    final boolean decompress(Wizard wizard) {
        if (this.validated == null) {
            this.inflater = new Inflater(wizard, this.specified);
            Thread t = new Thread((Runnable)this.inflater, "Inflater");
            t.start();
            return true;
        }
        return false;
    }

    final void cancel() {
        if (this.inflater != null) {
            this.inflater.cancel();
        }
        System.exit(1);
    }

    final void commit() throws IOException {
        this.inflater = null;
        Object command = PATH_VARIABLE;
        if (this.isWindows) {
            command = "SET " + (String)command;
        }
        ArrayList<String> content = new ArrayList<String>();
        int insertAt = -1;
        for (String line : Files.readAllLines(this.setenv)) {
            if ((line = line.trim()).startsWith((String)command)) {
                insertAt = content.size();
                continue;
            }
            content.add(line);
        }
        if (insertAt < 0) {
            insertAt = content.size();
        }
        StringBuilder value = new StringBuilder(100).append((String)command).append('=');
        if (this.useRelativePath) {
            File relative = FXFinder.relativeToBase(this.validated);
            if (relative != null) {
                value.append(this.isWindows ? "%BASE_DIR%" : "$BASE_DIR").append(File.separatorChar).append(relative);
            } else {
                this.useRelativePath = false;
            }
        }
        if (!this.useRelativePath) {
            value.append(this.validated);
        }
        content.add(insertAt, value.toString());
        Files.write(this.setenv, content, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static File relativeToBase(File dir) {
        if (dir != null) {
            if (SIS_UNZIP_DIRECTORY.equals(dir.getName())) {
                return new File(SIS_UNZIP_DIRECTORY);
            }
            File parent = FXFinder.relativeToBase(dir.getParentFile());
            if (parent != null) {
                return new File(parent, dir.getName());
            }
        }
        return null;
    }
}

