/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.util.Collection;
import java.util.Locale;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.gui.metadata.Section;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.CodeList;

final class RepresentationInfo
extends Section<SpatialRepresentation> {
    private ReferenceSystem referenceSystem;

    RepresentationInfo(MetadataSummary owner) {
        super(owner);
        this.finished();
    }

    @Override
    void setInformation(Metadata metadata) {
        this.referenceSystem = null;
        if (metadata != null) {
            for (ReferenceSystem rs : CollectionsExt.nonNull((Collection)metadata.getReferenceSystemInfo())) {
                if (rs == null) continue;
                this.referenceSystem = rs;
                break;
            }
        }
        this.setInformation(CollectionsExt.nonNull((Collection)(metadata == null ? null : metadata.getSpatialRepresentationInfo())), SpatialRepresentation[]::new);
    }

    @Override
    void buildContent(SpatialRepresentation info) {
        if (info instanceof GridSpatialRepresentation) {
            this.build((GridSpatialRepresentation)info);
        }
        this.addLine((short)168, IdentifiedObjects.getDisplayName((IdentifiedObject)this.referenceSystem, (Locale)this.owner.vocabulary.getLocale()));
    }

    private void build(GridSpatialRepresentation info) {
        this.addLine((short)144, this.owner.format(info.getNumberOfDimensions()));
        StringBuffer gridSize = new StringBuffer(20);
        StringBuffer resolution = new StringBuffer(20);
        for (Dimension dim : CollectionsExt.nonNull((Collection)info.getAxisDimensionProperties())) {
            Double r;
            String name = this.owner.string(Types.getCodeTitle((CodeList)dim.getDimensionName()));
            Integer size = dim.getDimensionSize();
            if (name != null || size != null) {
                if (gridSize.length() != 0) {
                    gridSize.append(" \u00d7 ");
                }
                this.owner.format(size, gridSize);
                if (name != null) {
                    if (size != null) {
                        gridSize.append(' ');
                    }
                    gridSize.append(name);
                }
            }
            if ((r = dim.getResolution()) == null) continue;
            if (resolution.length() != 0) {
                resolution.append(" \u00d7 ");
            }
            this.owner.format(r, resolution);
        }
        if (gridSize.length() != 0) {
            this.addLine((short)65, gridSize.toString());
        }
        if (resolution.length() != 0) {
            this.addLine((short)172, resolution.toString());
        }
        this.addLine((short)23, this.owner.string(Types.getCodeTitle((CodeList)info.getCellGeometry())));
    }
}

