/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuItem;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.internal.GUIUtilities;
import org.apache.sis.gui.map.ValuesFormatter;
import org.apache.sis.gui.map.ValuesUnderCursor;
import org.apache.sis.util.resources.Vocabulary;

final class ValuesFromCoverage
extends ValuesUnderCursor
implements ChangeListener<GridCoverage> {
    private ValuesFormatter formatter;
    private final BitSet selectedBands = new BitSet();
    private boolean needsBandRefresh;
    private boolean refreshing;

    public ValuesFromCoverage() {
        this.valueChoices.setText(Vocabulary.format((short)178));
    }

    private void clear() {
        this.formatter = null;
        this.refreshing = false;
        this.needsBandRefresh = false;
        this.selectedBands.clear();
        this.valueChoices.getItems().clear();
    }

    final void setSlice(GridExtent extent) {
        if (this.formatter != null) {
            this.formatter.setSlice(extent);
        }
    }

    private static GridExtent getSelectedSlice(ObservableValue<?> property) {
        Object bean;
        if (property instanceof ReadOnlyProperty && (bean = ((ReadOnlyProperty)property).getBean()) instanceof CoverageCanvas) {
            return ((CoverageCanvas)((Object)bean)).getSliceExtent();
        }
        return null;
    }

    public void changed(ObservableValue<? extends GridCoverage> property, final GridCoverage previous, final GridCoverage coverage) {
        if (coverage == null) {
            this.clear();
            return;
        }
        final GridExtent slice = ValuesFromCoverage.getSelectedSlice(property);
        final Locale locale = GUIUtilities.getLocale(property);
        BackgroundThreads.execute((Runnable)new Task<ValuesFormatter>(){
            private ValuesFormatter inherit;
            private List<SampleDimension> bands;
            {
                this.inherit = ValuesFromCoverage.this.formatter;
            }

            protected ValuesFormatter call() {
                this.bands = coverage.getSampleDimensions();
                if (previous == null || !this.bands.equals(previous.getSampleDimensions())) {
                    this.inherit = null;
                }
                return new ValuesFormatter(ValuesFromCoverage.this, this.inherit, coverage, slice, this.bands, locale);
            }

            protected void succeeded() {
                ValuesFromCoverage.this.formatter = (ValuesFormatter)this.getValue();
                if (this.inherit == null) {
                    int numBands = this.bands.size();
                    Object[] menuItems = new CheckMenuItem[numBands];
                    BitSet selection = ValuesFromCoverage.this.selectedBands;
                    selection.clear();
                    selection.set(0, numBands <= 3 ? numBands : 1, true);
                    for (int b = 0; b < numBands; ++b) {
                        menuItems[b] = ValuesFromCoverage.this.createMenuItem(b, this.bands.get(b), locale);
                    }
                    ValuesFromCoverage.this.valueChoices.getItems().setAll(menuItems);
                    ValuesFromCoverage.this.needsBandRefresh = true;
                }
            }

            protected void failed() {
                ValuesFromCoverage.this.clear();
                ValuesFromCoverage.this.setError(this.getException());
            }
        });
    }

    private CheckMenuItem createMenuItem(int index, SampleDimension sd, Locale locale) {
        CheckMenuItem item = new CheckMenuItem(sd.getName().toInternationalString().toString(locale));
        item.setSelected(this.selectedBands.get(index));
        item.selectedProperty().addListener((p, o, n) -> {
            this.selectedBands.set(index, (boolean)n);
            this.needsBandRefresh = true;
        });
        return item;
    }

    @Override
    protected ValuesUnderCursor.Formatter formatter() {
        if (this.refreshing) {
            return null;
        }
        final ValuesFormatter formatter = this.formatter;
        if (formatter != null && this.needsBandRefresh && this.usePrototype()) {
            ObservableList menus = this.valueChoices.getItems();
            final String[] labels = new String[menus.size()];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = ((MenuItem)menus.get(i)).getText();
            }
            final HashSet others = new HashSet();
            final BitSet selection = (BitSet)this.selectedBands.clone();
            BackgroundThreads.execute((Runnable)new Task<String>(){

                protected String call() {
                    return formatter.setSelectedBands(selection, labels, others);
                }

                protected void succeeded() {
                    ValuesFromCoverage.this.needsBandRefresh = !ValuesFromCoverage.this.prototype((String)this.getValue(), others);
                    ValuesFromCoverage.this.refreshing = false;
                }

                protected void failed() {
                    ValuesFromCoverage.this.clear();
                    ValuesFromCoverage.this.setError(this.getException());
                }
            });
            this.refreshing = true;
        }
        return formatter;
    }
}

