/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.EnumMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javafx.util.Duration;
import org.apache.sis.io.stream.ByteRangeChannel;
import org.apache.sis.measure.Range;
import org.apache.sis.util.collection.RangeSet;
import org.apache.sis.util.internal.Numerics;

final class FileAccessItem
implements Runnable,
EventHandler<ActionEvent> {
    private static final int HEIGHT = 16;
    private static final int MARGIN_TOP = 1;
    private static final int MARGIN_RIGHT = 6;
    private static final int CURSOR_WIDTH = 10;
    private static final Duration CURSOR_DURATION = Duration.seconds((double)4.0);
    private static final Duration SEEK_DURATION = Duration.minutes((double)1.0);
    final List<FileAccessItem> owner;
    final String filename;
    private final EnumMap<Mode, RangeSet<Long>> accessRanges;
    final Pane accessView;
    private final ObservableList<Node> staticGroup;
    private final ObservableList<Node> seeksGroup;
    private FadeTransition cursor;
    private long cursorPosition;
    private long fileSize;
    private double columnWidth;
    private NextAddRange next;

    FileAccessItem(List<FileAccessItem> owner, String filename) {
        this.owner = owner;
        this.filename = filename;
        Group staticView = new Group();
        Group seeksView = new Group();
        this.staticGroup = staticView.getChildren();
        this.seeksGroup = seeksView.getChildren();
        this.accessView = new Pane(new Node[]{staticView, seeksView});
        this.accessRanges = new EnumMap(Mode.class);
        staticView.setAutoSizeChildren(false);
        Rectangle background = new Rectangle();
        background.setY(1.0);
        background.setHeight(16.0);
        background.setStroke((Paint)Mode.READ.fill.brighter());
        background.setFill((Paint)Color.TRANSPARENT);
        background.setStrokeType(StrokeType.INSIDE);
        this.staticGroup.add((Object)background);
        this.accessView.widthProperty().addListener((p, o, n) -> this.resize(n.doubleValue()));
    }

    private void resize(double width) {
        double old = this.columnWidth;
        this.columnWidth = width - 6.0;
        double scale = this.columnWidth / (double)this.fileSize;
        if (Double.isFinite(scale)) {
            this.adjustSizes(scale, true);
            if (this.cursor != null) {
                Rectangle r = (Rectangle)this.cursor.getNode();
                r.setX(Math.max(0.0, Math.min(scale * (double)this.cursorPosition - 5.0, this.columnWidth - 10.0)));
            }
            double ratio = this.columnWidth / old;
            for (Node node : this.seeksGroup) {
                Line line = (Line)node;
                double x = line.getStartX() * ratio;
                line.setStartX(x);
                line.setEndX(x);
            }
        }
    }

    private void addSeek(long position) {
        double x = (double)position * (this.columnWidth / (double)this.fileSize);
        Line line = new Line(x, 1.0, x, 17.0);
        line.setStroke((Paint)Color.DARKBLUE);
        this.seeksGroup.add((Object)line);
        FadeTransition t = new FadeTransition(CURSOR_DURATION, (Node)line);
        t.setDelay(SEEK_DURATION);
        t.setFromValue(1.0);
        t.setToValue(0.0);
        t.setOnFinished((EventHandler)this);
        t.play();
    }

    private void addRange(long lower, long upper, Mode mode) {
        this.cursorPosition = lower;
        RangeSet ranges = this.accessRanges.get((Object)mode);
        if (ranges == null) {
            ranges = RangeSet.create(Long.class, (boolean)true, (boolean)false);
            this.accessRanges.put(mode, (RangeSet<Long>)ranges);
        }
        boolean add = ranges.add((Comparable)Long.valueOf(lower), (Comparable)Long.valueOf(upper));
        for (RangeSet<Long> other : this.accessRanges.values()) {
            if (other == null || other == ranges) continue;
            add |= other.remove((Comparable)Long.valueOf(lower), (Comparable)Long.valueOf(upper));
        }
        double scale = this.columnWidth / (double)this.fileSize;
        if (Double.isFinite(scale)) {
            if (add) {
                this.adjustSizes(scale, false);
            }
            if (mode != Mode.CACHE) {
                Rectangle r;
                if (this.cursor == null) {
                    r = new Rectangle(0.0, 1.0, 10.0, 16.0);
                    r.setArcWidth(4.0);
                    r.setArcHeight(6.0);
                    r.setStroke((Paint)Color.ORANGE);
                    r.setFill((Paint)Color.YELLOW);
                    this.accessView.getChildren().add((Object)r);
                    this.cursor = new FadeTransition(CURSOR_DURATION, (Node)r);
                    this.cursor.setOnFinished((EventHandler)this);
                    this.cursor.setFromValue(1.0);
                    this.cursor.setToValue(0.0);
                } else {
                    r = (Rectangle)this.cursor.getNode();
                }
                r.setX(Math.max(0.0, Math.min(scale * (double)lower - 5.0, this.columnWidth - 10.0)));
                this.cursor.playFromStart();
            }
        }
    }

    public void handle(ActionEvent event) {
        ObservableList list;
        FadeTransition animation = (FadeTransition)event.getSource();
        if (animation == this.cursor) {
            this.cursor = null;
            list = this.accessView.getChildren();
        } else {
            list = this.seeksGroup;
        }
        boolean removed = list.remove((Object)animation.getNode());
        assert (removed) : animation;
    }

    final void adjustSizes(double scale, boolean resized) {
        ListIterator bars = this.staticGroup.listIterator();
        ((Rectangle)bars.next()).setWidth(this.columnWidth);
        for (Map.Entry<Mode, RangeSet<Long>> entry : this.accessRanges.entrySet()) {
            Mode mode = entry.getKey();
            for (Range range : entry.getValue()) {
                Rectangle r;
                long min = (Long)range.getMinValue();
                long max = (Long)range.getMaxValue();
                double x = scale * (double)min;
                double width = scale * (double)(max - min);
                if (bars.hasNext()) {
                    r = (Rectangle)bars.next();
                    if (resized || r.getX() + r.getWidth() >= x) {
                        r.setX(x);
                        r.setWidth(width);
                        mode.colorize(r);
                        continue;
                    }
                    bars.remove();
                }
                r = new Rectangle(x, 1.0, width, 16.0);
                r.setStrokeType(StrokeType.INSIDE);
                mode.colorize(r);
                bars.add(r);
            }
        }
        this.staticGroup.remove(bars.nextIndex(), this.staticGroup.size());
    }

    private synchronized void addRangeLater(long lower, long count, Mode mode) {
        long upper = Numerics.saturatingAdd((long)lower, (long)count);
        if (this.next != null && this.next.mode == mode && this.next.upper >= lower && this.next.lower <= upper) {
            lower = Math.min(this.next.lower, lower);
            upper = Math.max(this.next.upper, upper);
        } else {
            this.next = new NextAddRange(mode);
            Platform.runLater((Runnable)this.next);
        }
        this.next.lower = lower;
        this.next.upper = upper;
    }

    @Override
    public void run() {
        this.owner.remove(this);
    }

    private static enum Mode {
        CACHE(Color.LIGHTGRAY),
        READ(Color.LIGHTSEAGREEN),
        WRITE(Color.LIGHTCORAL);

        private final Color border;
        private final Color fill;

        private Mode(Color fill) {
            this.fill = fill;
            this.border = fill.darker();
        }

        final void colorize(Rectangle r) {
            r.setStroke((Paint)this.border);
            r.setFill((Paint)this.fill);
        }
    }

    private final class NextAddRange
    implements Runnable {
        private final Mode mode;
        long lower;
        long upper;

        NextAddRange(Mode mode) {
            this.mode = mode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileAccessItem fileAccessItem = FileAccessItem.this;
            synchronized (fileAccessItem) {
                if (FileAccessItem.this.next == this) {
                    FileAccessItem.this.next = null;
                }
            }
            FileAccessItem.this.addRange(this.lower, this.upper, this.mode);
        }
    }

    final class InputObserver
    extends InputStream {
        private final InputStream in;
        private final Mode mode;
        private long position;
        private long mark;

        InputObserver(InputStream in) {
            this.in = in;
            this.mode = Mode.READ;
        }

        InputObserver(InputStream in, long start) {
            this.in = in;
            this.mode = Mode.CACHE;
            this.position = start;
        }

        private void range(long count, Mode mode) {
            if (count > 0L) {
                FileAccessItem.this.addRangeLater(this.position, count, mode);
                if (this.position > (this.position += count)) {
                    this.position = Long.MAX_VALUE;
                }
            }
        }

        private void range(long count) {
            this.range(count, this.mode);
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b >= 0) {
                this.range(1L);
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            len = this.in.read(b, off, len);
            this.range(len);
            return len;
        }

        @Override
        public byte[] readNBytes(int len) throws IOException {
            byte[] b = this.in.readNBytes(len);
            this.range(b.length);
            return b;
        }

        @Override
        public long transferTo(OutputStream out) throws IOException {
            long n = this.in.transferTo(out);
            this.range(n);
            return n;
        }

        @Override
        public long skip(long n) throws IOException {
            n = this.in.skip(n);
            this.range(n, Mode.CACHE);
            return n;
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public boolean markSupported() {
            return this.in.markSupported();
        }

        @Override
        public void mark(int readlimit) {
            this.in.mark(readlimit);
            this.mark = this.position;
        }

        @Override
        public void reset() throws IOException {
            this.in.reset();
            this.position = this.mark;
        }

        @Override
        public void close() throws IOException {
            if (this.mode == Mode.READ) {
                Platform.runLater((Runnable)FileAccessItem.this);
            }
            this.in.close();
        }
    }

    final class Observer
    extends ByteRangeChannel {
        private final SeekableByteChannel channel;

        Observer(SeekableByteChannel channel) throws IOException {
            this.channel = channel;
            FileAccessItem.this.fileSize = channel.size();
        }

        public void rangeOfInterest(long lower, long upper) {
            if (this.channel instanceof ByteRangeChannel) {
                ((ByteRangeChannel)this.channel).rangeOfInterest(lower, upper);
            }
        }

        public int read(ByteBuffer dst) throws IOException {
            long position = this.position();
            int count = this.channel.read(dst);
            FileAccessItem.this.addRangeLater(position, count, Mode.READ);
            return count;
        }

        public int write(ByteBuffer src) throws IOException {
            long position = this.position();
            int count = this.channel.write(src);
            FileAccessItem.this.addRangeLater(position, count, Mode.WRITE);
            return count;
        }

        public long position() throws IOException {
            return this.channel.position();
        }

        public SeekableByteChannel position(long position) throws IOException {
            this.channel.position(position);
            Platform.runLater(() -> FileAccessItem.this.addSeek(position));
            return this;
        }

        public long size() throws IOException {
            return this.channel.size();
        }

        public SeekableByteChannel truncate(long size) throws IOException {
            FileAccessItem.this.fileSize = this.channel.truncate(size).size();
            return this;
        }

        public boolean isOpen() {
            return this.channel.isOpen();
        }

        public void close() throws IOException {
            Platform.runLater((Runnable)FileAccessItem.this);
            this.channel.close();
        }
    }
}

