/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.internal;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.internal.ExceptionReporter;
import org.apache.sis.gui.internal.GUIUtilities;
import org.apache.sis.gui.internal.ImageConverter;
import org.apache.sis.gui.internal.PropertyValueFormats;
import org.apache.sis.gui.internal.PropertyValueFormatter;
import org.apache.sis.gui.internal.Styles;
import org.apache.sis.math.Statistics;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;

public final class PropertyView
implements Localized,
ChangeListener<Number> {
    private final PropertyValueFormats formats;
    private Object value;
    public final ObjectProperty<Node> view;
    private TextArea textView;
    private ListView<String> listView;
    private ImageView imageView;
    private Pane imageCanvas;
    private GridPane imagePane;
    private Label sampleValueRange;
    private Label meanValue;
    private Rectangle visibleImageBounds;
    private ImageConverter runningTask;
    private ImageConverter pendingTask;

    public PropertyView(PropertyValueFormatter formatter) {
        this.formats = formatter.formats;
        this.view = new SimpleObjectProperty((Object)this, "view");
    }

    public PropertyView(Locale locale, ObjectProperty<Node> view, ObjectProperty<Background> background) {
        this.formats = new PropertyValueFormats(locale);
        this.view = view;
        if (background != null) {
            this.getImageCanvas().backgroundProperty().bind(background);
        }
    }

    public Locale getLocale() {
        return this.formats.getLocale();
    }

    public void set(Object newValue, Rectangle visibleBounds) {
        boolean boundsChanged;
        boolean bl = boundsChanged = !Objects.equals(visibleBounds, this.visibleImageBounds);
        if (newValue != this.value || boundsChanged) {
            Object content;
            this.visibleImageBounds = visibleBounds;
            if (newValue instanceof RenderedImage) {
                content = this.setImage((RenderedImage)newValue, boundsChanged);
            } else {
                ImageConverter task = this.runningTask;
                if (task != null) {
                    this.runningTask = null;
                    this.pendingTask = null;
                    task.cancel(false);
                }
                content = newValue == null ? null : (newValue instanceof Throwable ? this.setText((Throwable)newValue) : (newValue instanceof IdentifiedObject ? this.setCRS((IdentifiedObject)newValue) : (newValue instanceof Collection ? this.setList(((Collection)newValue).toArray()) : (newValue.getClass().isArray() ? this.setList(newValue) : this.setText(this.formats.formatValue(newValue, true))))));
            }
            this.view.set(content);
            this.value = newValue;
        }
    }

    private Node setText(String text) {
        TextArea node = this.textView;
        if (node == null) {
            node = new TextArea();
            node.setEditable(false);
            node.setFont(Font.font((String)"Monospaced"));
            this.textView = node;
        }
        node.setText(text);
        return node;
    }

    private Node setText(Throwable ex) {
        return this.setText(ExceptionReporter.getStackTrace(ex));
    }

    private Node setList(Object array) {
        ListView node = this.listView;
        if (node == null) {
            this.listView = node = new ListView();
        }
        Object[] list = new String[Array.getLength(array)];
        for (int i = 0; i < list.length; ++i) {
            list[i] = this.formats.formatValue(Array.get(array, i), true);
        }
        this.listView.getItems().setAll(list);
        return node;
    }

    private Node setCRS(IdentifiedObject crs) {
        return this.setText(crs.toString());
    }

    private Pane getImageCanvas() {
        if (this.imageCanvas == null) {
            this.imageCanvas = new Pane();
            this.imageCanvas.widthProperty().addListener((ChangeListener)this);
            this.imageCanvas.heightProperty().addListener((ChangeListener)this);
        }
        return this.imageCanvas;
    }

    private Node setImage(RenderedImage image, boolean boundsChanged) {
        ImageConverter converter;
        Pane imageCanvas = this.getImageCanvas();
        ImageView node = this.imageView;
        if (node == null) {
            node = new ImageView();
            node.setPreserveRatio(true);
            imageCanvas.getChildren().setAll((Object[])new Node[]{node});
            GUIUtilities.setClipToBounds(imageCanvas);
            GridPane.setConstraints((Node)imageCanvas, (int)0, (int)0, (int)2, (int)1);
            GridPane.setHgrow((Node)imageCanvas, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)imageCanvas, (Priority)Priority.ALWAYS);
            Vocabulary vocabulary = Vocabulary.getResources((Locale)this.getLocale());
            Label rangeLabel = new Label(vocabulary.getLabel((short)215));
            Label meanLabel = new Label(vocabulary.getLabel((short)129));
            this.sampleValueRange = new Label();
            rangeLabel.setLabelFor((Node)this.sampleValueRange);
            this.meanValue = new Label();
            meanLabel.setLabelFor((Node)this.meanValue);
            Insets insets = new Insets(9.0, 0.0, 0.0, 9.0);
            rangeLabel.setPadding(insets);
            this.sampleValueRange.setPadding(insets);
            insets = new Insets(3.0, 0.0, 9.0, 9.0);
            meanLabel.setPadding(insets);
            this.meanValue.setPadding(insets);
            this.imagePane = Styles.createControlGrid(1, rangeLabel, meanLabel);
            this.imagePane.getChildren().add((Object)imageCanvas);
            this.imagePane.setPadding(Insets.EMPTY);
            this.imagePane.setVgap(0.0);
            this.imagePane.setHgap(0.0);
            this.imageView = node;
        }
        if ((converter = new ImageConverter(image, this.visibleImageBounds, node, (Region)imageCanvas)).needsRun(boundsChanged)) {
            converter.setOnSucceeded(e -> this.taskCompleted((Statistics[])converter.getValue()));
            converter.setOnFailed(e -> {
                this.taskCompleted(null);
                this.view.set((Object)this.setText(e.getSource().getException()));
            });
            if (this.runningTask != null) {
                this.pendingTask = converter;
            } else {
                this.runningTask = converter;
                BackgroundThreads.execute((Runnable)((Object)converter));
            }
        }
        return this.imagePane;
    }

    private void taskCompleted(Statistics[] statistics) {
        this.runningTask = this.pendingTask;
        this.pendingTask = null;
        if (this.runningTask != null) {
            BackgroundThreads.execute((Runnable)((Object)this.runningTask));
        }
        String range = null;
        String mean = null;
        if (statistics != null && statistics.length != 0) {
            Statistics s = statistics[0];
            StringBuffer buffer = new StringBuffer();
            this.formats.formatPair(s.minimum(), " \u2026 ", s.maximum(), buffer);
            range = buffer.toString();
            buffer.setLength(0);
            this.formats.formatPair(s.mean(), " \u00b1 ", s.standardDeviation(false), buffer);
            Vocabulary vocabulary = Vocabulary.getResources((Locale)this.getLocale());
            buffer.append(" (").append(vocabulary.getString((short)185)).append(')');
            mean = buffer.toString();
        }
        this.sampleValueRange.setText(range);
        this.meanValue.setText(mean);
    }

    public void changed(ObservableValue<? extends Number> property, Number oldValue, Number newValue) {
        if (this.value instanceof RenderedImage) {
            this.setImage((RenderedImage)this.value, false);
        }
    }

    public void clear() {
        this.value = null;
        this.view.set(null);
        if (this.textView != null) {
            this.textView.setText(null);
        }
        if (this.listView != null) {
            this.listView.getItems().clear();
        }
        if (this.imageView != null) {
            ImageConverter.clear(this.imageView);
        }
    }
}

