/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.internal;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.util.internal.Numerics;

public class PropertyValueFormats
extends CompoundFormat<Object> {
    protected PropertyValueFormats(Locale locale) {
        super(locale, TimeZone.getDefault());
    }

    public final Class<? extends Object> getValueType() {
        return Object.class;
    }

    public final Object parse(CharSequence text, ParsePosition pos) throws ParseException {
        throw new ParseException(null, 0);
    }

    public final void format(Object value, Appendable toAppendTo) {
        StringBuffer buffer = (StringBuffer)toAppendTo;
        Format f = this.getFormat(value.getClass());
        if (f != null) {
            f.format(value, buffer, new FieldPosition(0));
        } else {
            buffer.append(value);
        }
    }

    public final String formatValue(Object value, boolean toStringAllowed) {
        Format f = this.getFormat(value.getClass());
        if (f == null) {
            return value.toString();
        }
        if (value instanceof Number) {
            return Numerics.useScientificNotationIfNeeded((Format)f, (Object)value, Format::format);
        }
        return f.format(value);
    }

    public final void formatPair(double first, String separator, double second, StringBuffer toAppendTo) {
        FieldPosition pos = new FieldPosition(0);
        Format f = this.getFormat(Number.class);
        PropertyValueFormats.format(f, first, toAppendTo, pos);
        toAppendTo.append(separator);
        PropertyValueFormats.format(f, second, toAppendTo, pos);
    }

    private static void format(Format f, double value, StringBuffer buffer, FieldPosition pos) {
        Numerics.useScientificNotationIfNeeded((Format)f, (Object)value, (nf, v) -> {
            nf.format(v, buffer, pos);
            return null;
        });
    }
}

