/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Window;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Static;

public final class GUIUtilities
extends Static {
    private GUIUtilities() {
    }

    public static Locale getLocale(ObservableValue<?> property) {
        Object bean;
        if (property instanceof ReadOnlyProperty && (bean = ((ReadOnlyProperty)property).getBean()) instanceof Localized) {
            return ((Localized)bean).getLocale();
        }
        return null;
    }

    public static Window getWindow(ObservableValue<?> property) {
        if (property instanceof ReadOnlyProperty) {
            ContextMenu parent;
            Object bean = ((ReadOnlyProperty)property).getBean();
            if (bean instanceof Node) {
                Scene scene = ((Node)bean).getScene();
                if (scene != null) {
                    return scene.getWindow();
                }
            } else if (bean instanceof MenuItem && (parent = ((MenuItem)bean).getParentPopup()) != null) {
                while (true) {
                    Window owner;
                    if (!((owner = parent.getOwnerWindow()) instanceof ContextMenu)) {
                        return owner;
                    }
                    parent = (ContextMenu)owner;
                }
            }
        }
        return null;
    }

    public static Window getWindow(Node control) {
        Scene scene;
        if (control != null && (scene = control.getScene()) != null) {
            return scene.getWindow();
        }
        return null;
    }

    public static void setClipToBounds(Pane pane) {
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)pane.widthProperty());
        clip.heightProperty().bind((ObservableValue)pane.heightProperty());
        pane.setClip((Node)clip);
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> void appendPathSorted(TreeItem<T> item, T ... path) {
        block0: for (T search : path) {
            ObservableList children = item.getChildren();
            int lo = 0;
            int hi = children.size() - 1;
            while (lo <= hi) {
                int m = lo + hi >>> 1;
                TreeItem child = (TreeItem)children.get(m);
                int c = ((Comparable)child.getValue()).compareTo(search);
                if (c < 0) {
                    lo = m + 1;
                    continue;
                }
                if (c > 0) {
                    hi = m - 1;
                    continue;
                }
                item = child;
                continue block0;
            }
            item = new TreeItem(search);
            children.add(lo, (Object)item);
        }
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> void removePathSorted(TreeItem<T> item, T ... path) {
        ObservableList removeFrom = null;
        int removeIndex = 0;
        for (T search : path) {
            TreeItem child;
            block6: {
                int sm;
                ObservableList children = item.getChildren();
                int hi = sm = children.size() - 1;
                int lo = 0;
                while (lo <= hi) {
                    int m = lo + hi >>> 1;
                    child = (TreeItem)children.get(m);
                    int c = ((Comparable)child.getValue()).compareTo(search);
                    if (c < 0) {
                        lo = m + 1;
                        continue;
                    }
                    if (c > 0) {
                        hi = m - 1;
                        continue;
                    }
                    if (sm != 0 || removeFrom == null) {
                        removeFrom = children;
                        removeIndex = m;
                    }
                    break block6;
                }
                if (sm < 0) break;
                return;
            }
            item = child;
        }
        if (removeFrom != null) {
            removeFrom.remove(removeIndex);
        }
    }

    public static <T> void forceCellUpdate(TreeItem<T> item) {
        Object value = item.getValue();
        item.setValue(null);
        item.setValue(value);
    }

    public static <T> void copySelection(ChoiceBox<T> source, ChoiceBox<T> target) {
        target.getSelectionModel().select(source.getSelectionModel().getSelectedItem());
    }

    public static <E> boolean copyAsDiff(List<? extends E> source, ObservableList<E> target) {
        if (source.isEmpty()) {
            boolean empty = target.isEmpty();
            target.clear();
            return !empty;
        }
        if (target.isEmpty()) {
            return target.setAll(source);
        }
        List<E> lcs = GUIUtilities.longestCommonSubsequence(source, target);
        boolean modified = false;
        int upper = target.size();
        int i = lcs.size();
        while (--i >= 0) {
            E keep = lcs.get(i);
            int lower = upper;
            while (target.get(--lower) != keep) {
            }
            if (lower + 1 < upper) {
                target.remove(lower + 1, upper);
                modified = true;
            }
            upper = lower;
        }
        if (upper != 0) {
            target.remove(0, upper);
            modified = true;
        }
        assert (lcs.equals(target));
        int lower = 0;
        for (int i2 = 0; i2 < target.size(); ++i2) {
            Object skip = target.get(i2);
            upper = lower;
            while (source.get(upper) != skip) {
                ++upper;
            }
            if (lower < upper) {
                target.addAll(i2, source.subList(lower, upper));
                i2 += upper - lower;
                modified = true;
            }
            lower = upper + 1;
        }
        upper = source.size();
        if (lower < upper) {
            target.addAll(source.subList(lower, upper));
            modified = true;
        }
        assert (source.equals(target));
        return modified;
    }

    static <E> List<? extends E> longestCommonSubsequence(List<? extends E> x, List<? extends E> y) {
        List<Object> suffix;
        List<Object> prefix;
        List<E> ox = x;
        List<E> oy = y;
        int nx = x.size();
        int ny = y.size();
        int i = 0;
        while (true) {
            if (i >= nx) {
                return x;
            }
            if (i >= ny) {
                return y;
            }
            if (x.get(i) != y.get(i)) {
                if (i == 0) {
                    prefix = List.of();
                    break;
                }
                prefix = x.subList(0, i);
                assert (y.subList(0, i).equals(prefix));
                x = x.subList(i, nx);
                y = y.subList(i, ny);
                nx -= i;
                ny -= i;
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (true) {
            int sx = nx - i2;
            int sy = ny - i2;
            if (sx == 0) {
                return ox;
            }
            if (sy == 0) {
                return oy;
            }
            if (x.get(sx - 1) != y.get(sy - 1)) {
                if (i2 == 0) {
                    suffix = List.of();
                    break;
                }
                suffix = x.subList(sx, nx);
                assert (y.subList(sy, ny).equals(suffix));
                x = x.subList(0, sx);
                y = y.subList(0, sy);
                nx -= i2;
                ny -= i2;
                break;
            }
            ++i2;
        }
        int[][] lengths = new int[nx + 1][ny + 1];
        for (int i3 = 1; i3 <= nx; ++i3) {
            int im = i3 - 1;
            E xim = x.get(im);
            for (int j = 1; j <= ny; ++j) {
                int jm = j - 1;
                lengths[i3][j] = y.get(jm) == xim ? Math.incrementExact(lengths[im][jm]) : Math.max(lengths[i3][jm], lengths[im][j]);
            }
        }
        ArrayList<Object> lcs = new ArrayList<Object>(lengths[nx][ny] + prefix.size() + suffix.size());
        while (nx > 0 && ny > 0) {
            int lg = lengths[nx][ny];
            if (lengths[nx - 1][ny] >= lg) {
                --nx;
                continue;
            }
            if (lengths[nx][--ny] >= lg) continue;
            E ex = x.get(--nx);
            assert (ex == y.get(ny));
            lcs.add(ex);
        }
        Collections.reverse(lcs);
        lcs.addAll(0, prefix);
        lcs.addAll(suffix);
        return lcs;
    }

    public static Quantity<Length> shorter(Quantity<Length> quantity, double m) {
        Unit unit = m < 1.0 ? Units.CENTIMETRE : (m < 1000.0 ? Units.METRE : Units.KILOMETRE);
        if (quantity != null && unit.equals(quantity.getUnit())) {
            return quantity;
        }
        m = Units.METRE.getConverterTo(unit).convert(Math.max(m, 0.01));
        return Quantities.create((double)m, (Unit)unit);
    }

    public static Color fromARGB(int code) {
        return Color.rgb((int)(0xFF & code >>> 16), (int)(0xFF & code >>> 8), (int)(0xFF & code));
    }

    public static int toARGB(Color color) {
        return GUIUtilities.toByte(color.getOpacity()) << 24 | GUIUtilities.toByte(color.getRed()) << 16 | GUIUtilities.toByte(color.getGreen()) << 8 | GUIUtilities.toByte(color.getBlue());
    }

    private static int toByte(double value) {
        return (int)Math.round(value * 255.0);
    }
}

