/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Locale;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Labeled;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.apache.sis.gui.dataset.WindowHandler;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.gui.internal.ToolbarButton;

public final class WindowManager {
    final WindowHandler main;
    final Locale locale;
    public final ObservableList<WindowHandler> windows;
    final ObservableList<WindowHandler> modifiableWindowList;

    WindowManager(WindowHandler main, Locale locale) {
        this.main = main;
        this.locale = locale;
        this.modifiableWindowList = FXCollections.observableArrayList();
        this.windows = FXCollections.unmodifiableObservableList(this.modifiableWindowList);
    }

    final Stage newWindow(Region content) {
        Stage stage = new Stage();
        Button mainWindow = new Button("\u2302\ufe0f");
        Button fullScreen = new Button("\u21f1\ufe0f");
        Resources localized = Resources.forLocale(this.locale);
        mainWindow.setTooltip(new Tooltip(localized.getString((short)25)));
        fullScreen.setTooltip(new Tooltip(localized.getString((short)22)));
        mainWindow.setOnAction(e -> this.main.show());
        fullScreen.setOnAction(e -> stage.setFullScreen(true));
        ToolBar tools = new ToolBar(new Node[]{mainWindow, fullScreen});
        tools.getItems().addAll((Object[])ToolbarButton.remove((Node)content));
        Font font = Font.font((double)20.0);
        for (Node node : tools.getItems()) {
            if (!(node instanceof Labeled)) continue;
            ((Labeled)node).setFont(font);
        }
        BorderPane pane = new BorderPane();
        stage.fullScreenProperty().addListener((p, o, entering) -> pane.setTop((Node)(entering != false ? null : tools)));
        pane.setTop((Node)tools);
        pane.setCenter((Node)content);
        stage.setScene(new Scene((Parent)pane));
        Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
        stage.setWidth(0.8 * bounds.getWidth());
        stage.setHeight(0.8 * bounds.getHeight());
        return stage;
    }
}

