/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import org.apache.sis.gui.dataset.ResourceCell;
import org.apache.sis.gui.dataset.ResourceEvent;
import org.apache.sis.gui.dataset.ResourceItem;
import org.apache.sis.gui.dataset.RootResource;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.internal.DataStoreOpener;
import org.apache.sis.gui.internal.ExceptionReporter;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.logging.Logging;

public class ResourceTree
extends TreeView<Resource> {
    final Locale locale = Locale.getDefault();
    public final ObjectProperty<EventHandler<ResourceEvent>> onResourceLoaded;
    public final ObjectProperty<EventHandler<ResourceEvent>> onResourceClosed;
    private final Queue<ResourceItem.Completer> pendingItems = new LinkedList<ResourceItem.Completer>();

    public ResourceTree() {
        this.setCellFactory(v -> new ResourceCell());
        this.setOnDragOver(ResourceTree::onDragOver);
        this.setOnDragDropped(this::onDragDropped);
        this.onResourceLoaded = new SimpleObjectProperty((Object)this, "onResourceLoaded");
        this.onResourceClosed = new SimpleObjectProperty((Object)this, "onResourceClosed");
    }

    public Resource getResource() {
        TreeItem item = this.getRoot();
        return item == null ? null : (Resource)item.getValue();
    }

    public void setResource(Resource resource) {
        this.setRoot(resource == null ? null : new ResourceItem(resource));
        this.setShowRoot(!(resource instanceof RootResource));
    }

    public boolean addResource(Resource resource) {
        assert (Platform.isFxApplicationThread());
        if (resource == null) {
            return false;
        }
        RootResource addTo = null;
        TreeItem item = this.getRoot();
        if (item != null) {
            Resource root = (Resource)item.getValue();
            if (root == resource) {
                return false;
            }
            if (root instanceof RootResource) {
                addTo = (RootResource)root;
            }
        }
        if (addTo == null) {
            TreeItem group = new TreeItem();
            this.setShowRoot(false);
            this.setRoot(group);
            addTo = new RootResource((TreeItem<Resource>)group, (TreeItem<Resource>)item);
            group.setValue((Object)addTo);
        }
        return addTo.add(resource);
    }

    public void loadResource(Object source) {
        if (source != null) {
            if (source instanceof Resource) {
                this.addResource((Resource)source);
            } else {
                DataStoreOpener opener = new DataStoreOpener(source);
                DataStore existing = opener.fromCache();
                if (existing != null) {
                    this.addResource((Resource)existing);
                } else {
                    opener.setOnSucceeded(event -> this.addLoadedResource((DataStore)event.getSource().getValue(), source));
                    opener.setOnFailed(event -> ExceptionReporter.show((Node)this, event));
                    BackgroundThreads.execute((Runnable)((Object)opener));
                }
            }
        }
    }

    private void addLoadedResource(DataStore store, Object source) {
        boolean added = this.addResource((Resource)store);
        EventHandler handler = (EventHandler)this.onResourceLoaded.getValue();
        if (handler != null) {
            Path path;
            try {
                path = IOUtilities.toPathOrNull((Object)source);
            }
            catch (IllegalArgumentException | FileSystemNotFoundException e) {
                ResourceTree.recoverableException("loadResource", e);
                return;
            }
            if (path != null) {
                if (added) {
                    ((ResourceItem)this.findOrRemove((Resource)store, (boolean)false)).path = path;
                }
                handler.handle((Event)new ResourceEvent(this, path, ResourceEvent.LOADED));
            }
        }
    }

    private void onDragDropped(DragEvent event) {
        Dragboard db = event.getDragboard();
        List files = db.getFiles();
        boolean success = false;
        if (files != null) {
            for (File file : files) {
                this.loadResource(file);
            }
            success = true;
        } else {
            String url = db.getUrl();
            if (url != null) {
                try {
                    this.loadResource(new URL(url));
                    success = true;
                }
                catch (MalformedURLException e) {
                    int start = url.lastIndexOf(47, url.length() - 2) + 1;
                    int stop = url.indexOf(63, start);
                    if (stop <= 0) {
                        stop = url.length();
                    }
                    ExceptionReporter.canNotReadFile((Node)this, url.substring(start, stop), (Throwable)e);
                }
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private static void onDragOver(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasFiles() || db.hasUrl()) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
        }
        event.consume();
    }

    public void removeAndClose(Resource resource) {
        TreeItem<Resource> item = this.findOrRemove(resource, true);
        if (item instanceof ResourceItem) {
            resource = ((ResourceItem)item).getSource();
        }
        if (resource instanceof DataStore) {
            DataStore store = (DataStore)resource;
            DataStoreOpener.removeAndClose(store, (Node)this);
            EventHandler handler = (EventHandler)this.onResourceClosed.get();
            if (handler != null) {
                Path path = null;
                if (item instanceof ResourceItem) {
                    path = ((ResourceItem)item).path;
                }
                if (path == null) {
                    try {
                        path = store.getOpenParameters().map(p -> IOUtilities.toPathOrNull((Object)p.parameter("location").getValue())).orElse(null);
                    }
                    catch (IllegalArgumentException | FileSystemNotFoundException e) {
                        ResourceTree.recoverableException("removeAndClose", e);
                    }
                }
                if (path != null) {
                    handler.handle((Event)new ResourceEvent(this, path, ResourceEvent.CLOSED));
                }
            }
        }
    }

    final TreeItem<Resource> findOrRemove(Resource resource, boolean remove) {
        assert (Platform.isFxApplicationThread());
        if (resource != null) {
            Resource root;
            TreeItem item;
            if (remove) {
                ObservableList items = this.getSelectionModel().getSelectedItems();
                int i = items.size();
                while (--i >= 0) {
                    if (!((ResourceItem)((Object)items.get(i))).contains(resource)) continue;
                    this.getSelectionModel().clearSelection(i);
                }
            }
            if ((item = this.getRoot()) != null && (root = (Resource)item.getValue()) != null) {
                if (root == resource) {
                    if (remove) {
                        this.setRoot(null);
                    }
                    return item;
                }
                if (root instanceof RootResource) {
                    return ((RootResource)root).contains(resource, remove);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fetchLabel(ResourceItem.Completer item) {
        boolean isEmpty;
        Queue<ResourceItem.Completer> queue = this.pendingItems;
        synchronized (queue) {
            isEmpty = this.pendingItems.isEmpty();
            this.pendingItems.add(item);
        }
        if (isEmpty) {
            BackgroundThreads.execute(() -> {
                while (true) {
                    ResourceItem.Completer c;
                    Queue<ResourceItem.Completer> queue = this.pendingItems;
                    synchronized (queue) {
                        c = this.pendingItems.poll();
                    }
                    if (c == null) break;
                    c.fetch(this.locale);
                }
            });
        }
    }

    final Resources localized() {
        return Resources.forLocale(this.locale);
    }

    private static void recoverableException(String method, Exception e) {
        Logging.recoverableException((Logger)LogHandler.LOGGER, ResourceTree.class, (String)method, (Throwable)e);
    }

    static void unexpectedException(String method, Exception e) {
        Logging.unexpectedException((Logger)LogHandler.LOGGER, ResourceTree.class, (String)method, (Throwable)e);
    }
}

