/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.apache.sis.coverage.Category;
import org.apache.sis.gui.controls.ColorColumnHandler;
import org.apache.sis.gui.controls.ColorRamp;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.internal.ImmutableObjectProperty;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.image.Colorizer;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

final class CoverageStyling
extends ColorColumnHandler<Category>
implements Function<Category, Color[]> {
    private final Map<String, ColorRamp> customizedColors = new HashMap<String, ColorRamp>();
    private final CoverageCanvas canvas;

    CoverageStyling(CoverageCanvas canvas) {
        this.canvas = canvas;
        if (canvas != null) {
            canvas.setColorizer(Colorizer.forCategories((Function)this));
        }
    }

    final void copyStyling(CoverageStyling source) {
        this.customizedColors.putAll(source.customizedColors);
        if (this.canvas != null) {
            this.canvas.stylingChanged();
        }
    }

    private void clear(ObservableList<Category> items) {
        Object[] content = (Category[])items.toArray(Category[]::new);
        items.clear();
        this.customizedColors.clear();
        items.setAll(content);
        if (this.canvas != null) {
            this.canvas.stylingChanged();
        }
    }

    private static String key(Category category) {
        return category.getName().toString(Locale.ROOT);
    }

    @Override
    protected ObservableValue<ColorRamp> getObservableValue(Category category) {
        ColorRamp ramp = this.customizedColors.get(CoverageStyling.key(category));
        if (ramp == null) {
            if (!category.isQuantitative()) {
                return null;
            }
            ramp = ColorRamp.DEFAULT;
        }
        return new ImmutableObjectProperty<ColorRamp>(ramp);
    }

    @Override
    public Color[] apply(Category category) {
        int[] ARGB;
        ColorRamp ramp = this.customizedColors.get(CoverageStyling.key(category));
        if (ramp != null && (ARGB = ramp.colors) != null) {
            Color[] colors = new Color[ARGB.length];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = new Color(ARGB[i], true);
            }
            return colors;
        }
        return null;
    }

    @Override
    protected ColorRamp.Type applyColors(Category category, ColorRamp colors) {
        String key = CoverageStyling.key(category);
        ColorRamp old = colors != null ? this.customizedColors.put(key, colors) : this.customizedColors.remove(key);
        if (this.canvas != null && !Objects.equals(colors, old)) {
            this.canvas.stylingChanged();
        }
        return category.isQuantitative() ? ColorRamp.Type.GRADIENT : ColorRamp.Type.SOLID;
    }

    final TableView<Category> createCategoryTable(Resources resources, Vocabulary vocabulary) {
        TableColumn name = new TableColumn(vocabulary.getString((short)139));
        name.setCellValueFactory(CoverageStyling::getCategoryName);
        name.setCellFactory(CoverageStyling::createNameCell);
        name.setEditable(false);
        name.setId("name");
        TableView table = new TableView();
        table.getColumns().add((Object)name);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.addColumnTo(table, vocabulary.getString((short)228));
        MenuItem reset = new MenuItem(resources.getString((short)55));
        reset.setOnAction(e -> this.clear((ObservableList<Category>)table.getItems()));
        table.setContextMenu(new ContextMenu(new MenuItem[]{reset}));
        table.setEditable(true);
        return table;
    }

    private static TableCell<Category, String> createNameCell(TableColumn<Category, String> column) {
        TableCell cell = (TableCell)TableColumn.DEFAULT_CELL_FACTORY.call(column);
        cell.setAlignment(Pos.CENTER_LEFT);
        return cell;
    }

    private static ObservableValue<String> getCategoryName(TableColumn.CellDataFeatures<Category, String> cell) {
        InternationalString name = ((Category)cell.getValue()).getName();
        return name != null ? new ImmutableObjectProperty<String>(name.toString()) : null;
    }
}

