/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.net.URI;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.netcdf.MetadataReader;
import org.apache.sis.storage.netcdf.NetcdfStoreProvider;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.DiscreteSampling;
import org.apache.sis.storage.netcdf.base.RasterResource;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.Metadata;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameSpace;

public class NetcdfStore
extends DataStore
implements Aggregate {
    private Decoder decoder;
    private final URI location;
    private Metadata metadata;
    private List<Resource> components;

    public NetcdfStore(NetcdfStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super((DataStoreProvider)provider, connector);
        this.location = (URI)connector.getStorageAs(URI.class);
        Path path = (Path)connector.getStorageAs(Path.class);
        try {
            this.decoder = NetcdfStoreProvider.decoder(this.listeners, connector);
        }
        catch (IOException | ArithmeticException e) {
            throw new DataStoreException((Throwable)e);
        }
        if (this.decoder == null) {
            throw new UnsupportedStorageException(super.getLocale(), "NetCDF", connector.getStorage(), (OpenOption[])connector.getOption(OptionKey.OPEN_OPTIONS));
        }
        this.decoder.location = path;
        String id = Strings.trimOrNull((String)this.decoder.stringValue("id"));
        if (id == null) {
            id = this.decoder.getFilename();
        }
        if (id != null) {
            DefaultNameFactory f = this.decoder.nameFactory;
            this.decoder.namespace = f.createNameSpace((GenericName)f.createLocalName(null, (CharSequence)id), null);
        }
        if (((Object)((Object)this)).getClass() == NetcdfStore.class) {
            this.listeners.useReadOnlyEvents();
        }
    }

    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters((DataStoreProvider)this.provider, (URI)this.location));
    }

    public synchronized Version getConventionVersion() throws DataStoreException {
        for (CharSequence value : CharSequences.split((CharSequence)this.decoder().stringValue("Conventions"), (char)',')) {
            if (!CharSequences.regionMatches((CharSequence)value, (int)0, (CharSequence)"CF-", (boolean)true)) continue;
            return new Version(value.subSequence(3, value.length()).toString());
        }
        return null;
    }

    public Optional<GenericName> getIdentifier() throws DataStoreException {
        NameSpace namespace = this.decoder().namespace;
        return namespace != null ? Optional.of(namespace.name()) : Optional.empty();
    }

    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            try {
                MetadataReader reader = new MetadataReader(this.decoder());
                this.metadata = reader.read();
            }
            catch (IOException | ArithmeticException e) {
                throw new DataStoreException((Throwable)e);
            }
        }
        return this.metadata;
    }

    public Optional<TreeTable> getNativeMetadata() throws DataStoreException {
        DefaultTreeTable table = new DefaultTreeTable(new TableColumn[]{TableColumn.NAME, TableColumn.VALUE});
        TreeTable.Node root = table.getRoot();
        root.setValue(TableColumn.NAME, (Object)"NetCDF");
        this.decoder().addAttributesTo(root);
        return Optional.of(table);
    }

    public synchronized Collection<Resource> components() throws DataStoreException {
        if (this.components == null) {
            try {
                Decoder decoder = this.decoder();
                DiscreteSampling[] resources = decoder.getDiscreteSampling(this);
                List<Resource> grids = RasterResource.create(decoder, this);
                if (!grids.isEmpty()) {
                    grids.addAll((Collection<Resource>)UnmodifiableArrayList.wrap((Object[])resources));
                    resources = (Resource[])grids.toArray(Resource[]::new);
                }
                this.components = UnmodifiableArrayList.wrap((Object[])resources);
            }
            catch (IOException e) {
                throw new DataStoreException((Throwable)e);
            }
        }
        return this.components;
    }

    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        if (listener == null || eventType == null || eventType.isAssignableFrom(WarningEvent.class)) {
            super.addListener(eventType, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DataStoreException {
        try {
            this.listeners.close();
            Object reader = this.decoder;
            if (reader != null) {
                reader.close(this);
            }
        }
        catch (IOException e) {
            throw new DataStoreException((Throwable)e);
        }
        finally {
            NetcdfStore netcdfStore = this;
            synchronized (netcdfStore) {
                this.components = null;
                this.metadata = null;
                this.decoder = null;
            }
        }
    }

    private Decoder decoder() throws DataStoreClosedException {
        Decoder reader = this.decoder;
        if (reader == null) {
            throw new DataStoreClosedException(this.getLocale(), "NetCDF", new OpenOption[]{StandardOpenOption.READ});
        }
        return reader;
    }

    public String toString() {
        return Strings.bracket(((Object)((Object)this)).getClass(), (Object)((Object)this.decoder));
    }
}

