/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import java.util.Arrays;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.apache.sis.referencing.operation.matrix.NonSquareMatrix;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

class GeneralMatrix
extends MatrixSIS
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = 8447482612423035360L;
    private static final double ZERO_THRESHOLD = 1.0E-14;
    final double[] elements;
    short numRow;
    short numCol;

    GeneralMatrix(int n, int n2, boolean bl, int n3) {
        GeneralMatrix.ensureValidSize(n, n2);
        this.numRow = (short)n;
        this.numCol = (short)n2;
        this.elements = new double[n * n2 * n3];
        if (bl) {
            int n4 = Math.min(n, n2) * n2;
            for (int i = 0; i < n4; i += n2 + 1) {
                this.elements[i] = 1.0;
            }
        }
    }

    GeneralMatrix(int n, int n2, double[] dArray) {
        GeneralMatrix.ensureValidSize(n, n2);
        GeneralMatrix.ensureLengthMatch(n * n2, dArray);
        this.numRow = (short)n;
        this.numCol = (short)n2;
        this.elements = (double[])dArray.clone();
    }

    GeneralMatrix(Matrix matrix) {
        int n = matrix.getNumRow();
        int n2 = matrix.getNumCol();
        GeneralMatrix.ensureValidSize(n, n2);
        this.numRow = (short)n;
        this.numCol = (short)n2;
        if (matrix instanceof ExtendedPrecisionMatrix) {
            this.elements = ((ExtendedPrecisionMatrix)matrix).getExtendedElements();
            assert (this.elements.length % (n * n2) == 0);
        } else {
            this.elements = new double[n * n2];
            GeneralMatrix.getElements(matrix, n, n2, this.elements);
        }
    }

    GeneralMatrix(GeneralMatrix generalMatrix) {
        this.numRow = generalMatrix.numRow;
        this.numCol = generalMatrix.numCol;
        this.elements = (double[])generalMatrix.elements.clone();
    }

    static GeneralMatrix createExtendedPrecision(int n, int n2, boolean bl) {
        if (n == n2) {
            return new GeneralMatrix(n, n2, bl, 2);
        }
        return new NonSquareMatrix(n, n2, bl, 2);
    }

    static void inferErrors(double[] dArray) {
        int n;
        for (int i = n = dArray.length / 2; i < dArray.length; ++i) {
            dArray[i] = DoubleDouble.errorForWellKnownValue(dArray[i - n]);
        }
    }

    static int indexOfErrors(int n, int n2, double[] dArray) {
        assert (dArray.length % (n * n2) == 0);
        return n * n2 % dArray.length;
    }

    private static void ensureValidSize(int n, int n2) {
        ArgumentChecks.ensureBetween("numRow", 1, Short.MAX_VALUE, n);
        ArgumentChecks.ensureBetween("numCol", 1, Short.MAX_VALUE, n2);
    }

    public final int getNumRow() {
        return this.numRow;
    }

    public final int getNumCol() {
        return this.numCol;
    }

    @Override
    final boolean isExtendedPrecision() {
        return this.elements.length > this.numRow * this.numCol;
    }

    @Override
    final void get(int n, int n2, DoubleDouble doubleDouble) {
        int n3 = n * this.numCol + n2;
        doubleDouble.value = this.elements[n3];
        if ((n3 += this.numRow * this.numCol) < this.elements.length) {
            doubleDouble.error = this.elements[n3];
            assert (doubleDouble.equals(this.getNumber(n, n2)));
        } else {
            doubleDouble.error = DoubleDouble.errorForWellKnownValue(doubleDouble.value);
        }
    }

    @Override
    final void set(int n, int n2, DoubleDouble doubleDouble) {
        int n3 = n * this.numCol + n2;
        int n4 = n3 + this.numRow * this.numCol;
        if (n4 < this.elements.length) {
            this.elements[n3] = doubleDouble.value;
            this.elements[n4] = doubleDouble.error;
            assert (doubleDouble.equals(this.getNumber(n, n2)));
        } else {
            this.elements[n3] = doubleDouble.doubleValue();
        }
    }

    @Override
    public long getInteger(int n, int n2) {
        if (n >= 0 && n < this.numRow && n2 >= 0 && n2 < this.numCol) {
            int n3 = n * this.numCol + n2;
            long l = Math.round(this.elements[n3]);
            if ((n3 += this.numRow * this.numCol) < this.elements.length) {
                l += (long)this.elements[n3];
            }
            return l;
        }
        throw GeneralMatrix.indexOutOfBounds(n, n2);
    }

    @Override
    public Number getNumber(int n, int n2) {
        if (n >= 0 && n < this.numRow && n2 >= 0 && n2 < this.numCol) {
            int n3 = n * this.numCol + n2;
            double d = this.elements[n3];
            if ((n3 += this.numRow * this.numCol) < this.elements.length) {
                return new DoubleDouble(d, this.elements[n3]);
            }
            return d;
        }
        throw GeneralMatrix.indexOutOfBounds(n, n2);
    }

    @Override
    public final double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRow && n2 >= 0 && n2 < this.numCol) {
            return this.elements[n * this.numCol + n2];
        }
        throw GeneralMatrix.indexOutOfBounds(n, n2);
    }

    public final void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.numRow && n2 >= 0 && n2 < this.numCol) {
            int n3 = n * this.numCol + n2;
            this.elements[n3] = d;
            if ((n3 += this.numRow * this.numCol) < this.elements.length) {
                this.elements[n3] = DoubleDouble.errorForWellKnownValue(d);
            }
        } else {
            throw GeneralMatrix.indexOutOfBounds(n, n2);
        }
    }

    static double[] getExtendedElements(Matrix matrix, int n, int n2, boolean bl) {
        double[] dArray;
        int n3 = n * n2 * 2;
        if (matrix instanceof GeneralMatrix) {
            dArray = ((GeneralMatrix)matrix).elements;
            if (dArray.length == n3) {
                if (bl) {
                    dArray = (double[])dArray.clone();
                }
                return dArray;
            }
            dArray = Arrays.copyOf(dArray, n3);
        } else if (matrix instanceof ExtendedPrecisionMatrix) {
            dArray = ((ExtendedPrecisionMatrix)matrix).getExtendedElements();
            if (dArray.length == n3) {
                return dArray;
            }
            dArray = Arrays.copyOf(dArray, n3);
        } else {
            dArray = new double[n3];
            GeneralMatrix.getElements(matrix, n, n2, dArray);
        }
        GeneralMatrix.inferErrors(dArray);
        return dArray;
    }

    @Override
    public final double[] getExtendedElements() {
        return (double[])this.elements.clone();
    }

    @Override
    public final double[] getElements() {
        return Arrays.copyOf(this.elements, this.numRow * this.numCol);
    }

    @Override
    final void getElements(double[] dArray) {
        System.arraycopy(this.elements, 0, dArray, 0, this.numRow * this.numCol);
    }

    @Override
    public final void setElements(double[] dArray) {
        GeneralMatrix.ensureLengthMatch(this.numRow * this.numCol, dArray);
        System.arraycopy(dArray, 0, this.elements, 0, dArray.length);
        if (this.elements.length != dArray.length) {
            GeneralMatrix.inferErrors(dArray);
        }
    }

    final boolean setElements(Number[] numberArray) {
        short s = this.numRow;
        short s2 = this.numCol;
        int n = s * s2;
        if (numberArray.length != n) {
            throw new IllegalArgumentException(Errors.format((short)133, n, numberArray.length));
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            double d;
            double d2;
            Number number = numberArray[i];
            if (DoubleDouble.shouldConvert(number)) {
                number = new DoubleDouble(number);
            }
            this.elements[i] = d2 = number.doubleValue();
            if (number instanceof DoubleDouble) {
                d = ((DoubleDouble)number).error;
                if (!bl) {
                    bl = true;
                    for (int j = 0; j < i; ++j) {
                        this.elements[j + n] = DoubleDouble.errorForWellKnownValue(this.elements[j]);
                    }
                }
            } else {
                if (!bl) continue;
                d = DoubleDouble.errorForWellKnownValue(d2);
            }
            this.elements[i + n] = d;
        }
        return bl;
    }

    @Override
    public void setMatrix(Matrix matrix) throws MismatchedMatrixSizeException {
        if (matrix instanceof GeneralMatrix) {
            GeneralMatrix generalMatrix = (GeneralMatrix)matrix;
            GeneralMatrix.ensureSizeMatch(this.numRow, this.numCol, matrix);
            int n = generalMatrix.elements.length;
            if (this.elements.length <= n) {
                System.arraycopy(generalMatrix.elements, 0, this.elements, 0, this.elements.length);
            } else {
                System.arraycopy(generalMatrix.elements, 0, this.elements, 0, n);
                GeneralMatrix.inferErrors(this.elements);
            }
        } else {
            super.setMatrix(matrix);
        }
    }

    @Override
    public final boolean isAffine() {
        return this.isAffine(true);
    }

    final boolean isAffine(boolean bl) {
        short s = this.numRow;
        short s2 = this.numCol;
        if (s == s2 || !bl) {
            int n = s * s2;
            if (this.elements[--n] == 1.0) {
                int n2 = (s - 1) * s2;
                while (--n >= n2) {
                    if (this.elements[n] == 0.0) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean isIdentity() {
        short s = this.numRow;
        short s2 = this.numCol;
        if (s != s2) {
            return false;
        }
        int n = 0;
        int n2 = s * s2;
        for (int i = 0; i < n2; ++i) {
            double d = this.elements[i];
            if (i == n) {
                if (d != 1.0) {
                    return false;
                }
                n += s2 + 1;
                continue;
            }
            if (d == 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transpose() {
        int n = this.numRow;
        short s = this.numCol;
        int n2 = GeneralMatrix.indexOfErrors(n, s, this.elements);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                int n3 = i * s + j;
                int n4 = j * s + i;
                ArraysExt.swap(this.elements, n3, n4);
                if (n2 == 0) continue;
                ArraysExt.swap(this.elements, n3 + n2, n4 + n2);
            }
        }
    }

    final void setToProduct(Matrix matrix, Matrix matrix2) {
        int n = this.numRow;
        int n2 = this.numCol;
        int n3 = matrix.getNumCol();
        assert (matrix2.getNumRow() == n3);
        assert (n == matrix.getNumRow() && n2 == matrix2.getNumCol());
        double[] dArray = GeneralMatrix.getExtendedElements(matrix, n, n3, false);
        double[] dArray2 = GeneralMatrix.getExtendedElements(matrix2, n3, n2, false);
        int n4 = n * n2;
        int n5 = n * n3;
        int n6 = n3 * n2;
        DoubleDouble doubleDouble = new DoubleDouble();
        DoubleDouble doubleDouble2 = new DoubleDouble();
        int n7 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n8;
                doubleDouble2.clear();
                double d = 0.0;
                int n9 = j;
                int n10 = n8 + n3;
                for (n8 = i * n3; n8 < n10; ++n8) {
                    doubleDouble.setFrom(dArray, n8, n5);
                    if (!doubleDouble.isZero()) {
                        double d2 = dArray2[n9];
                        double d3 = dArray2[n9 + n6];
                        if (d2 != 0.0 || d3 != 0.0) {
                            doubleDouble.multiply(d2, d3);
                            doubleDouble2.add(doubleDouble);
                            double d4 = Math.abs(doubleDouble.value);
                            if (d4 > d) {
                                d = d4;
                            }
                        }
                    }
                    n9 += n2;
                }
                if (Math.abs(doubleDouble2.value) < Math.ulp(d) * 1.0E-14) {
                    doubleDouble2.clear();
                }
                doubleDouble2.storeTo(this.elements, n7++, n4);
            }
        }
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof GeneralMatrix) {
            GeneralMatrix generalMatrix = (GeneralMatrix)object;
            return this.numRow == generalMatrix.numRow && this.numCol == generalMatrix.numCol && Arrays.equals(this.elements, generalMatrix.elements);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return (this.numRow << 16 | this.numCol) ^ Arrays.hashCode(this.elements) ^ 0xE7C389E0;
    }

    @Override
    public MatrixSIS clone() {
        return new GeneralMatrix(this);
    }
}

