/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gml.UniversalTimeAdapter;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.TemporalDatum;

@XmlType(name="TemporalDatumType")
@XmlRootElement(name="TemporalDatum")
public class DefaultTemporalDatum
extends AbstractDatum
implements TemporalDatum {
    private static final long serialVersionUID = 3357241732140076884L;
    private long origin;

    public DefaultTemporalDatum(Map<String, ?> map, Date date) {
        super(map);
        ArgumentChecks.ensureNonNull("origin", date);
        this.origin = date.getTime();
    }

    protected DefaultTemporalDatum(TemporalDatum temporalDatum) {
        super((Datum)temporalDatum);
        this.origin = ImplementationHelper.toMilliseconds(temporalDatum.getOrigin());
    }

    public static DefaultTemporalDatum castOrCopy(TemporalDatum temporalDatum) {
        return temporalDatum == null || temporalDatum instanceof DefaultTemporalDatum ? (DefaultTemporalDatum)temporalDatum : new DefaultTemporalDatum(temporalDatum);
    }

    public Class<? extends TemporalDatum> getInterface() {
        return TemporalDatum.class;
    }

    @XmlSchemaType(name="dateTime")
    @XmlElement(name="origin", required=true)
    @XmlJavaTypeAdapter(value=UniversalTimeAdapter.class)
    public Date getOrigin() {
        return ImplementationHelper.toDate(this.origin);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                return this.origin == ((DefaultTemporalDatum)object).origin;
            }
        }
        return Objects.equals(this.getOrigin(), ((TemporalDatum)object).getOrigin());
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + this.origin;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        formatter.append(new Origin(this.getOrigin()));
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return formatter.shortOrLong("TDatum", "TimeDatum");
    }

    private DefaultTemporalDatum() {
        this.origin = Long.MIN_VALUE;
    }

    private void setOrigin(Date date) {
        if (this.origin == Long.MIN_VALUE) {
            this.origin = date.getTime();
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultTemporalDatum.class, "setOrigin", "origin");
        }
    }

    private static final class Origin
    extends FormattableObject {
        private final Date origin;

        Origin(Date date) {
            this.origin = date;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            formatter.append(this.origin);
            return "TimeOrigin";
        }
    }
}

