/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.metadata.EX_Extent;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@XmlTransient
public class AbstractReferenceSystem
extends AbstractIdentifiedObject
implements ReferenceSystem {
    private static final long serialVersionUID = 3337659819553899435L;
    private Extent domainOfValidity;
    private InternationalString scope;

    public AbstractReferenceSystem(Map<String, ?> map) {
        super(map);
        this.domainOfValidity = Containers.property(map, "domainOfValidity", Extent.class);
        this.scope = Types.toInternationalString(map, "scope");
    }

    protected AbstractReferenceSystem(ReferenceSystem referenceSystem) {
        super((IdentifiedObject)referenceSystem);
        this.domainOfValidity = referenceSystem.getDomainOfValidity();
        this.scope = referenceSystem.getScope();
    }

    public Class<? extends ReferenceSystem> getInterface() {
        return ReferenceSystem.class;
    }

    @XmlElement(name="domainOfValidity")
    @XmlJavaTypeAdapter(value=EX_Extent.class)
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @XmlElement(name="scope", required=true)
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                AbstractReferenceSystem abstractReferenceSystem = (AbstractReferenceSystem)object;
                return Objects.equals(this.domainOfValidity, abstractReferenceSystem.domainOfValidity) && Objects.equals(this.scope, abstractReferenceSystem.scope);
            }
            case BY_CONTRACT: {
                ReferenceSystem referenceSystem = (ReferenceSystem)object;
                return Utilities.deepEquals(this.getDomainOfValidity(), referenceSystem.getDomainOfValidity(), comparisonMode) && Utilities.deepEquals(this.getScope(), referenceSystem.getScope(), comparisonMode);
            }
        }
        return true;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.domainOfValidity, this.scope);
    }

    AbstractReferenceSystem() {
    }

    private void setDomainOfValidity(Extent extent) {
        if (this.domainOfValidity == null) {
            this.domainOfValidity = extent;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractReferenceSystem.class, "setDomainOfValidity", "domainOfValidity");
        }
    }

    private void setScope(InternationalString internationalString) {
        if (this.scope == null) {
            this.scope = internationalString;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractReferenceSystem.class, "setScope", "scope");
        }
    }
}

