/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import javax.measure.Unit;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.WraparoundTransform;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class WraparoundApplicator {
    private final DirectPosition sourceMedian;
    private final DirectPosition targetMedian;
    private final CoordinateSystem targetCS;

    public WraparoundApplicator(DirectPosition directPosition, DirectPosition directPosition2, CoordinateSystem coordinateSystem) {
        this.sourceMedian = directPosition;
        this.targetMedian = directPosition2;
        this.targetCS = coordinateSystem;
    }

    public static MathTransform forTargetCRS(CoordinateOperation coordinateOperation) throws TransformException {
        WraparoundApplicator wraparoundApplicator = new WraparoundApplicator(null, null, coordinateOperation.getTargetCRS().getCoordinateSystem());
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        for (int n : CoordinateOperations.wrapAroundChanges(coordinateOperation)) {
            mathTransform = wraparoundApplicator.concatenate(mathTransform, n);
        }
        return mathTransform;
    }

    public MathTransform forDomainOfUse(MathTransform mathTransform) throws TransformException {
        int n = this.targetCS.getDimension();
        for (int i = 0; i < n; ++i) {
            mathTransform = this.concatenate(mathTransform, i);
        }
        return mathTransform;
    }

    private MathTransform concatenate(MathTransform mathTransform, int n) throws TransformException {
        double d;
        double d2;
        double d3 = WraparoundApplicator.range(this.targetCS, n);
        if (!(d3 > 0.0) || d3 == Double.POSITIVE_INFINITY) {
            return mathTransform;
        }
        try {
            if (this.targetMedian == null) {
                CoordinateSystemAxis coordinateSystemAxis = this.targetCS.getAxis(n);
                d2 = (coordinateSystemAxis.getMinimumValue() + coordinateSystemAxis.getMaximumValue()) / 2.0;
            } else {
                d2 = this.targetMedian.getOrdinate(n);
            }
            if (!Double.isFinite(d2)) {
                if (this.targetMedian != null) {
                    return mathTransform;
                }
                d2 = 0.0;
            }
            d = this.sourceMedian != null ? this.sourceMedian.getOrdinate(n) : Double.NaN;
        }
        catch (BackingStoreException backingStoreException) {
            throw backingStoreException.unwrapOrRethrow(TransformException.class);
        }
        double d4 = Math.max(Math.abs(d), Math.abs(d2));
        if (Math.abs(d - d2) < d4 * 1.0E-13) {
            int n2 = Math.getExponent(d4);
            if (WraparoundApplicator.error(d, n2) <= WraparoundApplicator.error(d2, n2)) {
                d2 = d;
            } else {
                d = d2;
            }
        }
        MathTransform mathTransform2 = WraparoundTransform.create(mathTransform.getTargetDimensions(), n, d3, d, d2);
        return MathTransforms.concatenate(mathTransform, mathTransform2);
    }

    private static double error(double d, int n) {
        d = Math.scalb(d, 6 - n);
        return Math.abs(d - Math.rint(d));
    }

    static double range(CoordinateSystem coordinateSystem, int n) {
        CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n);
        if (coordinateSystemAxis != null && RangeMeaning.WRAPAROUND.equals((Object)coordinateSystemAxis.getRangeMeaning())) {
            double d = coordinateSystemAxis.getMaximumValue() - coordinateSystemAxis.getMinimumValue();
            if (d > 0.0 && d != Double.POSITIVE_INFINITY) {
                return d;
            }
            AxisDirection axisDirection = AxisDirections.absolute(coordinateSystemAxis.getDirection());
            if (AxisDirection.EAST.equals((Object)axisDirection) && coordinateSystem instanceof EllipsoidalCS) {
                d = 360.0;
                Unit unit = coordinateSystemAxis.getUnit();
                if (unit != null) {
                    d = Units.DEGREE.getConverterTo(Units.ensureAngular(unit)).convert(d);
                }
                return d;
            }
        }
        return Double.NaN;
    }
}

