/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.AbstractReferenceSystem;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.gazetteer.AbstractLocation;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.referencing.gazetteer.ModifiableLocationType;
import org.apache.sis.referencing.gazetteer.ModifiableLocationTypeAdapter;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

@XmlTransient
public abstract class ReferencingByIdentifiers
extends AbstractReferenceSystem {
    public static final String THEME_KEY = "theme";
    public static final String OVERALL_OWNER_KEY = "overallOwner";
    private static final long serialVersionUID = 5353942546043471933L;
    private final InternationalString theme;
    private final AbstractParty overallOwner;
    final List<AbstractLocationType> locationTypes;

    public ReferencingByIdentifiers(Map<String, ?> map, ModifiableLocationType ... modifiableLocationTypeArray) {
        super(map);
        this.theme = Types.toInternationalString(map, THEME_KEY);
        this.overallOwner = Containers.property(map, OVERALL_OWNER_KEY, AbstractParty.class);
        this.locationTypes = AbstractLocationType.snapshot(this, modifiableLocationTypeArray);
    }

    static Map<String, Object> properties(Object object, String string, AbstractParty abstractParty) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(8);
        hashMap.put("name", object);
        hashMap.put("identifiers", new ImmutableIdentifier(Citations.SIS, "SIS", string));
        hashMap.put("domainOfValidity", Extents.WORLD);
        hashMap.put(THEME_KEY, Vocabulary.formatInternational((short)126));
        hashMap.put(OVERALL_OWNER_KEY, abstractParty);
        return hashMap;
    }

    public InternationalString getTheme() {
        return this.theme;
    }

    public AbstractParty getOverallOwner() {
        return this.overallOwner;
    }

    public List<? extends ModifiableLocationType> getLocationTypes() {
        return ModifiableLocationTypeAdapter.copy(this.locationTypes);
    }

    final AbstractLocationType rootType() {
        return this.locationTypes.get(0);
    }

    public abstract Coder createCoder();

    public boolean equals(Object object, ComparisonMode comparisonMode) {
        ReferencingByIdentifiers referencingByIdentifiers;
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                ReferencingByIdentifiers referencingByIdentifiers2 = (ReferencingByIdentifiers)((Object)object);
                return Objects.equals(this.theme, referencingByIdentifiers2.theme) && Objects.equals(this.overallOwner, referencingByIdentifiers2.overallOwner) && this.locationTypes.equals(referencingByIdentifiers2.locationTypes);
            }
            case BY_CONTRACT: {
                referencingByIdentifiers = (ReferencingByIdentifiers)((Object)object);
                if (Utilities.deepEquals(this.getTheme(), referencingByIdentifiers.getTheme(), comparisonMode) && Utilities.deepEquals(this.getOverallOwner(), referencingByIdentifiers.getOverallOwner(), comparisonMode)) break;
                return false;
            }
        }
        referencingByIdentifiers = (ReferencingByIdentifiers)((Object)object);
        return Utilities.deepEquals(this.locationTypes, referencingByIdentifiers.locationTypes, comparisonMode);
    }

    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.theme, this.overallOwner, this.locationTypes);
    }

    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendName((IdentifiedObject)this, (Formatter)formatter, (ElementKind)ElementKind.NAME);
        if (this.theme != null) {
            formatter.newLine();
            formatter.append((FormattableObject)new SubElement("Theme", this.theme));
        }
        if (this.overallOwner != null) {
            formatter.newLine();
            formatter.append((FormattableObject)new SubElement("Owner", this.overallOwner.getName()));
        }
        for (AbstractLocationType abstractLocationType : this.locationTypes) {
            formatter.newLine();
            formatter.append((FormattableObject)new SubElement("LocationType", abstractLocationType.getName()));
        }
        return "ReferenceSystemUsingIdentifiers";
    }

    private static final class SubElement
    extends FormattableObject {
        private final String name;
        private final InternationalString value;

        SubElement(String string, InternationalString internationalString) {
            this.name = string;
            this.value = internationalString;
        }

        protected String formatTo(Formatter formatter) {
            formatter.append(this.value != null ? this.value.toString(formatter.getLocale()) : null, null);
            return this.name;
        }
    }

    public static abstract class Coder {
        protected Coder() {
        }

        public abstract ReferencingByIdentifiers getReferenceSystem();

        public abstract Quantity<?> getPrecision(DirectPosition var1);

        public abstract void setPrecision(Quantity<?> var1, DirectPosition var2) throws IncommensurableException;

        public String encode(DirectPosition directPosition, Quantity<?> quantity) throws IncommensurableException, TransformException {
            this.setPrecision(quantity, directPosition);
            return this.encode(directPosition);
        }

        public abstract String encode(DirectPosition var1) throws TransformException;

        public abstract AbstractLocation decode(CharSequence var1) throws TransformException;

        static void recoverableException(Class<?> clazz, String string, Exception exception) {
            Logging.recoverableException(Logger.getLogger("org.apache.sis.referencing.gazetteer"), clazz, string, exception);
        }
    }
}

