/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.storage.xml.stream.NamespaceEraser;
import org.apache.sis.internal.storage.xml.stream.StaxDataStore;
import org.apache.sis.internal.storage.xml.stream.StaxStreamIO;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.collection.BackingStoreException;

public abstract class StaxStreamWriter
extends StaxStreamIO
implements Consumer<AbstractFeature> {
    protected final XMLStreamWriter writer;
    private Marshaller marshaller;

    protected StaxStreamWriter(StaxDataStore staxDataStore, OutputStream outputStream) throws DataStoreException, XMLStreamException, IOException {
        super(staxDataStore);
        this.writer = staxDataStore.createWriter(this, outputStream);
    }

    public void writeStartDocument() throws Exception {
        Charset charset = this.owner.encoding;
        if (charset != null) {
            this.writer.writeStartDocument(charset.name(), null);
        } else {
            this.writer.writeStartDocument();
        }
    }

    public void writeEndDocument() throws Exception {
        this.writer.writeEndDocument();
    }

    public abstract void write(AbstractFeature var1) throws Exception;

    @Override
    public void accept(AbstractFeature abstractFeature) throws BackingStoreException {
        try {
            this.write(abstractFeature);
        }
        catch (BackingStoreException backingStoreException) {
            throw backingStoreException;
        }
        catch (Exception exception) {
            IOException iOException;
            if (exception instanceof UncheckedIOException) {
                iOException = ((UncheckedIOException)exception).getCause();
            }
            throw new BackingStoreException(this.errors().getString((short)17, this.owner.getFormatName(), this.owner.getDisplayName()), iOException);
        }
    }

    protected final void writeSingleValue(String string, Object object) throws XMLStreamException {
        if (object != null) {
            this.writer.writeStartElement(string);
            this.writer.writeCharacters(object.toString());
            this.writer.writeEndElement();
        }
    }

    protected final void writeSingle(String string, Date date) throws XMLStreamException {
        if (date != null) {
            this.writeSingleValue(string, date.toInstant());
        }
    }

    protected final void writeList(String string, Iterable<?> iterable) throws XMLStreamException {
        if (iterable != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object obj : iterable) {
                if (obj == null) continue;
                int n = stringBuilder.length();
                if (n != 0 && stringBuilder.charAt(n - 1) != ' ') {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(obj);
            }
            this.writeSingleValue(string, stringBuilder.toString());
        }
    }

    protected final <T> void marshal(String string, String string2, Class<T> clazz, T t) throws XMLStreamException, JAXBException {
        Object object;
        Marshaller marshaller = this.marshaller;
        if (marshaller == null) {
            marshaller = this.getMarshallerPool().acquireMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
            object = this.owner.encoding;
            if (object != null) {
                marshaller.setProperty("jaxb.encoding", (Object)((Charset)object).name());
            }
            for (Map.Entry entry : this.owner.configuration.entrySet()) {
                marshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        Object object2 = this.writer;
        if (string != null) {
            object2 = new NamespaceEraser((XMLStreamWriter)object2, string);
            object = new QName(string, string2);
        } else {
            object = new QName(string2);
        }
        this.marshaller = null;
        marshaller.marshal((Object)new JAXBElement((QName)object, clazz, t), (XMLStreamWriter)object2);
        this.marshaller = marshaller;
    }

    @Override
    public void close() throws Exception {
        Marshaller marshaller = this.marshaller;
        if (marshaller != null) {
            this.marshaller = null;
            this.getMarshallerPool().recycle(marshaller);
        }
        this.writer.close();
        IOUtilities.truncate((AutoCloseable)this.stream);
        super.close();
    }
}

