/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.storage.gpx.Bounds;
import org.apache.sis.internal.storage.gpx.Link;
import org.apache.sis.internal.storage.gpx.Metadata;
import org.apache.sis.internal.storage.gpx.Person;
import org.apache.sis.internal.storage.gpx.StoreProvider;
import org.apache.sis.internal.storage.gpx.Types;
import org.apache.sis.internal.storage.gpx.WritableStore;
import org.apache.sis.internal.storage.xml.stream.StaxStreamWriter;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.IllegalFeatureTypeException;
import org.apache.sis.storage.gps.Fix;
import org.apache.sis.util.Version;

final class Writer
extends StaxStreamWriter {
    private final int version;
    private final Metadata metadata;

    Writer(WritableStore writableStore, Metadata metadata, OutputStream outputStream) throws DataStoreException, XMLStreamException, IOException {
        super(writableStore, outputStream);
        this.metadata = metadata;
        Version version = writableStore.version;
        this.version = version != null && version.compareTo(StoreProvider.V1_0, 2) <= 0 ? 0 : 1;
    }

    @Override
    public void writeStartDocument() throws Exception {
        String string;
        Version version;
        switch (this.version) {
            default: {
                version = StoreProvider.V1_1;
                string = "http://www.topografix.com/GPX/1/1";
                break;
            }
            case 0: {
                version = StoreProvider.V1_0;
                string = "http://www.topografix.com/GPX/1/0";
            }
        }
        super.writeStartDocument();
        this.writer.setDefaultNamespace(string);
        this.writer.writeStartElement("gpx");
        this.writer.writeDefaultNamespace(string);
        this.writer.writeAttribute("version", version.toString());
        if (this.metadata != null) {
            String string2 = this.metadata.creator;
            if (string2 != null) {
                this.writer.writeAttribute("creator", string2);
            }
            switch (this.version) {
                default: {
                    this.marshal("http://www.topografix.com/GPX/1/1", "metadata", Metadata.class, this.metadata);
                    break;
                }
                case 0: {
                    this.writeSingleValue("name", this.metadata.name);
                    this.writeSingleValue("desc", this.metadata.description);
                    Person person = this.metadata.author;
                    if (person != null) {
                        this.writeSingleValue("author", person.name);
                        this.writeSingleValue("email", person.email);
                    }
                    this.writeLinks(this.metadata.links);
                    this.writeSingle("time", this.metadata.time);
                    this.writeList("keywords", this.metadata.keywords);
                    this.marshal("http://www.topografix.com/GPX/1/1", "bounds", Bounds.class, this.metadata.bounds);
                }
            }
        }
    }

    @Override
    public void write(AbstractFeature abstractFeature) throws DataStoreException, XMLStreamException, JAXBException {
        if (abstractFeature != null) {
            Types types = ((WritableStore)this.owner).types;
            DefaultFeatureType defaultFeatureType = abstractFeature.getType();
            if (types.wayPoint.isAssignableFrom(defaultFeatureType)) {
                this.writeWayPoint(abstractFeature, "wpt");
            } else {
                boolean bl = types.route.isAssignableFrom(defaultFeatureType);
                if (!bl && !types.track.isAssignableFrom(defaultFeatureType)) {
                    throw new IllegalFeatureTypeException(this.owner.getLocale(), this.owner.getFormatName(), defaultFeatureType.getName());
                }
                this.writer.writeStartElement(bl ? "rte" : "trk");
                this.writeSingleValue("name", abstractFeature.getPropertyValue("name"));
                this.writeSingleValue("cmt", abstractFeature.getPropertyValue("cmt"));
                this.writeSingleValue("desc", abstractFeature.getPropertyValue("desc"));
                this.writeSingleValue("src", abstractFeature.getPropertyValue("src"));
                this.writeLinks((Collection)abstractFeature.getPropertyValue("link"));
                this.writeSingleValue("number", abstractFeature.getPropertyValue("number"));
                if (this.version != 0) {
                    this.writeSingleValue("type", abstractFeature.getPropertyValue("type"));
                }
                if (bl) {
                    for (Object e : (Collection)abstractFeature.getPropertyValue("rtept")) {
                        this.writeWayPoint((AbstractFeature)e, "rtept");
                    }
                } else {
                    for (Object e : (Collection)abstractFeature.getPropertyValue("trkseg")) {
                        if (e == null) continue;
                        this.writer.writeStartElement("trkseg");
                        for (Object e2 : (Collection)((AbstractFeature)e).getPropertyValue("trkpt")) {
                            this.writeWayPoint((AbstractFeature)e2, "trkpt");
                        }
                        this.writer.writeEndElement();
                    }
                }
                this.writer.writeEndElement();
            }
        }
    }

    private void writeWayPoint(AbstractFeature abstractFeature, String string) throws XMLStreamException, JAXBException {
        double[] dArray;
        if (abstractFeature != null && (dArray = (double[])Geometries.wrap(abstractFeature.getPropertyValue("sis:geometry")).map(GeometryWrapper::getPointCoordinates).orElse(null)) != null && dArray.length >= 2) {
            this.writer.writeStartElement(string);
            this.writer.writeAttribute("lat", Double.toString(dArray[1]));
            this.writer.writeAttribute("lon", Double.toString(dArray[0]));
            this.writeSingleValue("ele", abstractFeature.getPropertyValue("ele"));
            this.writeSingleValue("time", abstractFeature.getPropertyValue("time"));
            this.writeSingleValue("magvar", abstractFeature.getPropertyValue("magvar"));
            this.writeSingleValue("geoidheight", abstractFeature.getPropertyValue("geoidheight"));
            this.writeSingleValue("name", abstractFeature.getPropertyValue("name"));
            this.writeSingleValue("cmt", abstractFeature.getPropertyValue("cmt"));
            this.writeSingleValue("desc", abstractFeature.getPropertyValue("desc"));
            this.writeSingleValue("src", abstractFeature.getPropertyValue("src"));
            this.writeLinks((Collection)abstractFeature.getPropertyValue("link"));
            this.writeSingleValue("sym", abstractFeature.getPropertyValue("sym"));
            this.writeSingleValue("type", abstractFeature.getPropertyValue("type"));
            this.writeSingle((Fix)((Object)abstractFeature.getPropertyValue("fix")));
            this.writeSingleValue("sat", abstractFeature.getPropertyValue("sat"));
            this.writeSingleValue("hdop", abstractFeature.getPropertyValue("hdop"));
            this.writeSingleValue("vdop", abstractFeature.getPropertyValue("vdop"));
            this.writeSingleValue("pdop", abstractFeature.getPropertyValue("pdop"));
            this.writeSingleValue("ageofdgpsdata", abstractFeature.getPropertyValue("ageofdgpsdata"));
            this.writeSingleValue("dgpsid", abstractFeature.getPropertyValue("dgpsid"));
            this.writer.writeEndElement();
        }
    }

    private void writeSingle(Fix fix) throws XMLStreamException {
        if (fix != null) {
            this.writeSingleValue("fix", fix.toGPX());
        }
    }

    private void writeLinks(Collection<?> collection) throws XMLStreamException, JAXBException {
        if (collection != null) {
            block3: for (Object obj : collection) {
                if (obj == null) continue;
                switch (this.version) {
                    default: {
                        this.marshal("http://www.topografix.com/GPX/1/1", "link", Link.class, (Link)obj);
                        continue block3;
                    }
                    case 0: 
                }
                this.writeSingleValue("url", ((Link)obj).uri.toASCIIString());
                this.writeSingleValue("urlname", ((Link)obj).text);
                return;
            }
        }
    }
}

